(function ($) {
    "use strict";
    /* ================= HYDRATE RULE ROW ================= */
    function hydrate_existing_condition_row($row) {
        if ($row.find('.yeekit-cond-remove').length === 0) {
            $row.append(
                `<span class="yeekit-cond-remove dashicons dashicons-no-alt" title="${yeekit_dd_rule_params.i18n.remove_condition}"></span>`
            );
        }
        const $typeSelect = $row.find('.yeekit-cond-type');
        if ($typeSelect.length && $typeSelect.children().length === 0) {
            const groups = yeekit_dd_admin.condition_groups;
            const selected = $typeSelect.data('selected');
            Object.keys(groups).forEach(function (groupKey) {
                const group = groups[groupKey];
                const $optgroup = $('<optgroup>', { label: group.label });
                Object.keys(group.conditions).forEach(function (condKey) {
                    const cond = group.conditions[condKey];
                    const $opt = $('<option>', {
                        value: condKey,
                        text: cond.label
                    });
                    if (selected && condKey === selected) {
                        $opt.prop('selected', true);
                    }
                    $optgroup.append($opt);
                });
                $typeSelect.append($optgroup);
            });
        }
        render_rule_value($row);
    }
    /* ================= HELPERS ================= */
    function init_enhanced_select(context) {
        if ($.fn.select2) {
            context.find('.wc-enhanced-select').select2({ width: 'resolve' });
        }
    }
    function init_product_ajax_search() {
        // deprecated – product filter no longer uses selectWoo
    }
    function init_attribute_ajax_search(select) {
        select.selectWoo({
            ajax: {
                url: yeekit_dd_admin.ajax_url,
                dataType: 'json',
                delay: 250,
                data: params => ({
                    action: 'yeekit_dd_search_attributes',
                    nonce: yeekit_dd_admin.ajax_nonce,
                    q: params.term || ''
                }),
                processResults: data => ({ results: data })
            },
            minimumInputLength: 1,
            width: '100%'
        });
    }
    function init_product_selectwoo($select) {
        $select.each(function () {
            const $this = $(this);
            if ($this.data('init')) return;
            $this.data('init', 1);
            $this.selectWoo({
                ajax: {
                    url: yeekit_dd_admin.ajax_url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            action: 'yeekit_dd_search_products',
                            nonce: yeekit_dd_admin.ajax_nonce,
                            q: params.term || ''
                        };
                    },
                    processResults: function (data) {
                        return { results: data };
                    }
                },
                minimumInputLength: 1,
                width: '100%',
                allowClear: true
            });
        });
    }
    function init_coupon_search($select) {
        $select.each(function () {
            const $this = $(this);
            if ($this.data('init')) return;
            $this.data('init', 1);
            $this.selectWoo({
                ajax: {
                    url: yeekit_dd_admin.ajax_url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            action: 'yeekit_dd_search_coupons',
                            nonce: yeekit_dd_admin.ajax_nonce,
                            q: params.term || ''
                        };
                    },
                    processResults: function (data) {
                        return { results: data };
                    }
                },
                minimumInputLength: 1,
                width: '100%',
                placeholder: yeekit_dd_rule_params.i18n.search_coupons,
                allowClear: true
            });
        });
    }
    function get_next_filter_index() {
        let max = 0;
        $('.yeekit-filter-row').each(function () {
            const idx = parseInt($(this).data('index'), 10);
            if (idx > max) max = idx;
        });
        return max + 1;
    }
    function build_filter_row(index) {
        return `
            <div class="yeekit-filter-row" data-index="${index}">
                <select name="filters[${index}][type]" class="yeekit-filter-type">
                    <option value="cart_item_products">${yeekit_dd_rule_params.i18n.products}</option>
                    <option value="cart_item_product_category">${yeekit_dd_rule_params.i18n.category}</option>
                    <option value="cart_item_product_tags">${yeekit_dd_rule_params.i18n.tags}</option>
                    <option value="cart_item_product_attributes">${yeekit_dd_rule_params.i18n.attributes}</option>
                    <option value="cart_item_product_sku">${yeekit_dd_rule_params.i18n.skus}</option>
                    <option value="cart_item_product_onsale">${yeekit_dd_rule_params.i18n.on_sale_products}</option>
                </select>
                <select name="filters[${index}][operator]" class="yeekit-filter-operator">
                    <option value="in">${yeekit_dd_rule_params.i18n.in_list}</option>
                    <option value="not_in">${yeekit_dd_rule_params.i18n.not_in_list}</option>
                </select>
                <div class="yeekit-filter-value"></div>
                <span class="yeekit-filter-remove dashicons dashicons-no-alt"
                      title="${yeekit_dd_rule_params.i18n.remove_filter}"></span>

                <p class="yeekit-filter-desc yeekit-desc-cart_item_products">${yeekit_dd_rule_params.i18n.desc_products}</p>
                <p class="yeekit-filter-desc yeekit-desc-cart_item_product_category">${yeekit_dd_rule_params.i18n.desc_category}</p>
                <p class="yeekit-filter-desc yeekit-desc-cart_item_product_tags">${yeekit_dd_rule_params.i18n.desc_tags}</p>
                <p class="yeekit-filter-desc yeekit-desc-cart_item_product_attributes">${yeekit_dd_rule_params.i18n.desc_attributes}</p>
                <p class="yeekit-filter-desc yeekit-desc-cart_item_product_sku">${yeekit_dd_rule_params.i18n.desc_skus}</p>
                <p class="yeekit-filter-desc yeekit-desc-cart_item_product_onsale">${yeekit_dd_rule_params.i18n.desc_on_sale}</p>
            </div>
        `;
    }
    function get_next_condition_index() {
        let max = -1;
        $('.yeekit-cond-row').each(function () {
            const idx = parseInt($(this).data('index'), 10);
            if (idx > max) max = idx;
        });
        return max + 1;
    }
    /* ================= RENDER FILTER VALUE ================= */
    function render_filter_value(type, index, valueTd) {
        const row = valueTd.closest('.yeekit-filter-row');
        const prevType = row.data('current-type');
        row.data('current-type', type);
        // If type changed, wipe old value UI completely
        if (prevType && prevType !== type) {
            valueTd.empty();
        }
        /* === 1. If PHP has already rendered SELECT, just init === */
        const existingSelect = valueTd.find('select');
        const existingTextarea = valueTd.find('textarea');
        if (existingSelect.length) {
            if (type === 'cart_item_products') {
                init_product_selectwoo(existingSelect);
            } else if (type === 'cart_item_product_attributes') {
                init_attribute_ajax_search(existingSelect);
            } else if (
                type === 'cart_item_product_category' ||
                type === 'cart_item_product_tags'
            ) {
                // IMPORTANT: init select2 on the SELECT itself
                if ($.fn.select2) {
                    existingSelect.select2({ width: 'resolve' });
                }
            }
            return;
        }
        if (existingTextarea.length) {
            return;
        }
        /* === 2. Get saved value from hidden input === */
        let saved = [];
        valueTd.find('input[type="hidden"]').each(function () {
            if ($(this).val()) {
                saved.push($(this).val());
            }
        });

        /* === 3. Render by type === */
        switch (type) {
            case 'cart_item_products':
                valueTd.html(`
                    <select class="yeekit-product-ajax-select"
                            name="filters[${index}][value][]"
                            multiple></select>
                `);
                // init selectWoo for product search
                init_product_selectwoo(valueTd.find('select'));
                break;
            case 'cart_item_product_category':
            case 'cart_item_product_tags':
                valueTd.html(`
                    <select class="wc-enhanced-select"
                            name="filters[${index}][value][]"
                            multiple></select>
                `);
                const options = type === 'cart_item_product_category'
                    ? $(yeekit_dd_admin.product_categories)
                    : $(yeekit_dd_admin.product_tags);
                valueTd.find('select')
                    .append(options.clone().find('option').prop('selected', false))
                    .val(saved)
                    .trigger('change');
                init_enhanced_select(valueTd);
                break;
            case 'cart_item_product_attributes':
                valueTd.html(`
                    <select class="yeekit-attribute-search"
                            name="filters[${index}][value][]"
                            multiple></select>
                `);
                init_attribute_ajax_search(valueTd.find('select'));
                break;
            case 'cart_item_product_sku':
                valueTd.html(`
                    <textarea name="filters[${index}][value]"
                              rows="3"></textarea>
                `);
                break;
            case 'cart_item_product_onsale':
                valueTd.html(`
                    <input type="hidden" name="filters[${index}][value]" value="1">
                    <span class="description">${yeekit_dd_admin.i18n_on_sale}</span>
                `);
                break;
        }
    }
    /* ================= RULES HELPERS ================= */
    function get_condition_config(type) {
        if (
            typeof yeekit_dd_admin === 'undefined' ||
            !yeekit_dd_admin.condition_groups
        ) {
            console.warn('yeekit_dd_admin.condition_groups is missing');
            return null;
        }
        let cfg = null;
        Object.values(yeekit_dd_admin.condition_groups).forEach(group => {
            if (group.conditions && group.conditions[type]) {
                cfg = group.conditions[type];
            }
        });
        return cfg;
    }
    // STEP 1: Add helper to render value description
    function render_value_description(cfg) {
        if (!cfg || !cfg.desc) return '';
        return `<p class="description yeekit-cond-desc">${cfg.desc}</p>`;
    }
    // STEP 2: Safe version of render_rule_value
    function render_rule_value($row) {
        const type = $row.find('.yeekit-cond-type').val();
        const $operator = $row.find('.yeekit-cond-operator');
        const $value = $row.find('.yeekit-cond-value');
        const cfg = get_condition_config(type);
        if (!cfg) return;

        const prevType = $row.data('current-type');
        $row.data('current-type', type);

        // Reset only if type changed
        if (prevType && prevType !== type) {
            $operator.empty();
            $value.empty();
        }

        /* ===== OPERATOR ===== */
        if ($operator.children().length === 0) {
            (cfg.operators || []).forEach(op => {
                $operator.append(`<option value="${op}">${op}</option>`);
            });
        }

        /* ===== VALUE ===== */
        const valueType = cfg.value_type || 'text';

        // Get index from row to align with rules[type] and rules[operator]
        const index = $row.data('index');

        // 1. Build HTML if empty
        if ($value.children().length === 0) {
            let html = '';
            switch (valueType) {
                case 'none': break;
                case 'number':
                    html = `<input type="number" name="rules[value][${index}]" step="0.01">`;
                    break;
                case 'text':
                    html = `<input type="text" name="rules[value][${index}]">`;
                    break;
                case 'bool':
                case 'boolean':
                    html = `<input type="hidden" name="rules[value][${index}]" value="">`;
                    break;
                case 'date':
                    html = `<input type="date" name="rules[value][${index}]">`;
                    break;
                case 'datetime':
                    html = `<input type="datetime-local" name="rules[value][${index}]">`;
                    break;
                case 'time':
                    html = `<input type="time" name="rules[value][${index}]">`;
                    break;
                case 'weekday':
                    html = `
                        <select name="rules[value][${index}][]" multiple>
                            <option value="monday">${yeekit_dd_rule_params.i18n.monday}</option>
                            <option value="tuesday">${yeekit_dd_rule_params.i18n.tuesday}</option>
                            <option value="wednesday">${yeekit_dd_rule_params.i18n.wednesday}</option>
                            <option value="thursday">${yeekit_dd_rule_params.i18n.thursday}</option>
                            <option value="friday">${yeekit_dd_rule_params.i18n.friday}</option>
                            <option value="saturday">${yeekit_dd_rule_params.i18n.saturday}</option>
                            <option value="sunday">${yeekit_dd_rule_params.i18n.sunday}</option>
                        </select>`;
                    break;
                case 'static_select':
                    html = `<select name="rules[value][${index}][]" multiple>`;
                    Object.keys(cfg.options || {}).forEach(k => {
                        html += `<option value="${k}">${cfg.options[k]}</option>`;
                    });
                    html += `</select>`;
                    break;
                case 'product_select':
                case 'attribute_select':
                case 'taxonomy_select':
                case 'coupon_select':
                    // Enhanced selects share structure (but different classes ideally, though name matters most)
                    html = `<select name="rules[value][${index}][]" multiple></select>`;
                    // For taxonomy, we add wc-enhanced-select for consistency?
                    if (valueType === 'taxonomy_select') {
                        html = `<select class="wc-enhanced-select" name="rules[value][${index}][]" multiple></select>`;
                    }
                    break;
                default:
                    html = `<input type="text" name="rules[value][${index}]">`;
                    break;
            }
            $value.html(html);

            // 1b. Load Options (Only for NEW elements)
            if (valueType === 'taxonomy_select') {
                let taxonomyHtml = '';
                if (cfg.taxonomy === 'product_cat' && yeekit_dd_admin.product_categories) {
                    taxonomyHtml = $(yeekit_dd_admin.product_categories).html();
                } else if (cfg.taxonomy === 'product_tag' && yeekit_dd_admin.product_tags) {
                    taxonomyHtml = $(yeekit_dd_admin.product_tags).html();
                }
                if (taxonomyHtml) {
                    $value.find('select').html(taxonomyHtml);
                }
            }
        }

        // 2. Initialize Plugins (Always run safely)
        const $select = $value.find('select');
        if ($select.length) {
            if (valueType === 'product_select') {
                init_product_selectwoo($select);
            } else if (valueType === 'attribute_select') {
                init_attribute_ajax_search($select);
            } else if (valueType === 'coupon_select') {
                init_coupon_search($select);
            } else if (['taxonomy_select', 'weekday', 'static_select'].includes(valueType)) {
                if ($.fn.select2) {
                    // Simple guard or just re-init (select2 is usually safe to re-call)
                    $select.select2({ width: 'resolve' });
                }
            }
        }

        // 3. Render Description
        const descHtml = render_value_description(cfg);
        $row.find('.yeekit-cond-desc').remove();
        if (descHtml) {
            $row.append(descHtml);
        }
    }
    /* ================= RENDER RULE ROW ================= */
    function build_condition_row(index) {
        let options = '';

        if (
            typeof yeekit_dd_admin !== 'undefined' &&
            yeekit_dd_admin.condition_groups
        ) {
            const groups = yeekit_dd_admin.condition_groups;

            Object.keys(groups).forEach(function (groupKey) {
                const group = groups[groupKey];
                options += `<optgroup label="${group.label}">`;

                Object.keys(group.conditions || {}).forEach(function (condKey) {
                    options += `<option value="${condKey}">${group.conditions[condKey].label}</option>`;
                });

                options += `</optgroup>`;
            });
        } else {
            console.warn('condition_groups missing when building rule row');
        }

        return `
            <div class="yeekit-cond-row" data-index="${index}">
                <select name="rules[type][${index}]" class="yeekit-cond-type">${options}</select>
                <select name="rules[operator][${index}]" class="yeekit-cond-operator"></select>
                <span class="yeekit-cond-value"></span>
                <span class="yeekit-cond-remove dashicons dashicons-no-alt"></span>
            </div>
        `;
    }
    /* ================= EVENTS ================= */
    $(document).ready(function () {
        init_enhanced_select($(document));
        $('.yeekit-filter-row').each(function () {
            const row = $(this);
            const index = row.data('index');
            const type = row.find('.yeekit-filter-type').val();
            const valueTd = row.find('.yeekit-filter-value');
            if (type) {
                render_filter_value(type, index, valueTd);
            }
        });

        // select2 for product search
        if ($.fn.selectWoo) {

            init_product_selectwoo($('.yeekit-product-ajax-select'));
        } else if ($.fn.select2) {
            $('.yeekit-product-ajax-select').select2();
        }

        // Toggle fields based on Discount Type
        function toggle_fields() {
            const type = $('.yeekit-product-discount-type').val();
            const $filterBlock = $('.yeekit-add-filter').closest('.yeekit-dd-block');
            const $discountBlock = $('.yeekit-discount-type').closest('.yeekit-dd-block');
            const $bulkBlock = $('.yeekit-bulk-discount-block');
            const $setBlock = $('.yeekit-set-discount-block');
            const $bogoBlock = $('.yeekit-buyx-getx-block');
            const $bxgyBlock = $('.yeekit-buyx-gety-block');
            const $titleRow = $('.yeekit-discount-title-row');

            // Reset Blocks
            $filterBlock.show();

            $discountBlock.hide();
            $bulkBlock.hide();
            $setBlock.hide();
            $bogoBlock.hide();
            $bxgyBlock.hide();
            $titleRow.hide();

            // Toggle Description
            $('.yeekit-type-desc').hide();
            if (type && type !== 'not_selected') {
                $('.yeekit-desc-' + type).show();
            }

            if (type === 'yeekit_simple_discount' || type === 'yeekit_cart_discount' || type === 'not_selected' || !type) {
                $discountBlock.show();
                // Show title ONLY for cart discount
                if (type === 'yeekit_cart_discount') {
                    $titleRow.show();
                }
            } else if (type === 'yeekit_free_shipping') {
                $filterBlock.hide();
                $discountBlock.hide();
                $bulkBlock.hide();
            } else if (type === 'yeekit_bulk_discount') {
                $discountBlock.hide();
                $bulkBlock.show();
                if ($('#yeekit-bulk-tiers-container').children().length === 0) $('#yeekit-add-bulk-tier').click();
            } else if (type === 'yeekit_set_discount') {
                $setBlock.show();
                if ($('#yeekit-set-tiers-container').children().length === 0) $('#yeekit-add-set-tier').click();
            } else if (type === 'yeekit_buy_x_get_x') {
                $bogoBlock.show();
                $discountBlock.hide();
                if ($('#yeekit-buyx-getx-tiers-container').children().length === 0) $('#yeekit-add-bogo-tier').click();
            } else if (type === 'yeekit_buy_x_get_y') {
                $bxgyBlock.show();
                if ($('#yeekit-buyx-gety-tiers-container').children().length === 0) $('#yeekit-add-bxgy-tier').click();
            } else {
                $discountBlock.show();
            }
        }

        // Toggle Filter Description
        $(document).on('change', '.yeekit-filter-type', function () {
            const val = $(this).val();
            const $row = $(this).closest('.yeekit-filter-row');
            $row.find('.yeekit-filter-desc').hide();
            $row.find('.yeekit-desc-' + val).show();
        });

        // Init Filter Description on load
        $('.yeekit-filter-type').trigger('change');

        // Discount Type Toggle
        $(document).on('change', '.yeekit-product-discount-type', toggle_fields);
        // toggle_fields(); // Moved to end of ready

        // Toggle Discount Amount Type Description
        $(document).on('change', '.yeekit-discount-type', function () {
            const val = $(this).val();
            const $wrapper = $(this).closest('td'); // Or closest block

            // Toggle Type Desc
            $('.yeekit-discount-type-desc').hide();
            $('.yeekit-desc-' + val).show();

            // Toggle Value Desc
            $('.yeekit-value-desc').hide();
            if (val === 'percentage') {
                $('.yeekit-val-desc-percentage').show();
            } else {
                $('.yeekit-val-desc-currency').show();
            }
        });
        $('.yeekit-discount-type').trigger('change');

        // BXGY Discount Type Initial Visibility
        $('.buyx_gety_discount_select').each(function () {
            const val = $(this).val();
            const $wrapper = $(this).closest('.yeekit-tier-row').find('.yeekit-bxgy-discount-value-wrapper');
            if (val === 'free_product') {
                $wrapper.hide();
            } else {
                $wrapper.show();
            }
        });

        // Initialize Select2/SelectWoo for existing elements explicitly if not covered
        if ($.fn.selectWoo) {
            init_product_selectwoo($('.yeekit-product-ajax-select'));
        }

        /* ================= BULK TIER UI ================= */
        $(document).on('click', '#yeekit-add-bulk-tier', function () {
            const index = $('#yeekit-bulk-tiers-container .yeekit-tier-row').length;
            const row = `
                <div class="yeekit-tier-row yeekit-bulk-tier-row">
                    <div class="tier-content">
                        <div class="tier-line-1">
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.min_qty || 'Min Qty'}</label>
                                <input type="number" name="rule[bulk_tiers][${index}][min_qty]" value="" min="0" step="1">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.max_qty || 'Max Qty'}</label>
                                <input type="number" name="rule[bulk_tiers][${index}][max_qty]" value="" min="0" step="1" placeholder="Any">
                            </div>
                        </div>
                        <div class="tier-line-2">
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.type || 'Discount Type'}</label>
                                <select name="rule[bulk_tiers][${index}][type]">
                                    <option value="percentage">Percentage</option>
                                    <option value="fixed">Fixed Discount</option>
                                    <option value="fixed_price">Fixed price for item</option>
                                </select>
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.value || 'Value'}</label>
                                <input type="number" name="rule[bulk_tiers][${index}][value]" value="" step="0.01">
                            </div>
                            <div class="yeekit-form-group tier-grow">
                                <label>${yeekit_dd_rule_params.i18n.label || 'Label'}</label>
                                <input type="text" name="rule[bulk_tiers][${index}][label]" value="">
                            </div>
                        </div>
                    </div>
                    <div class="tier-actions">
                        <span class="yeekit-remove-tier dashicons dashicons-no-alt" title="Remove range"></span>
                    </div>
                </div>
            `;
            $('#yeekit-bulk-tiers-container').append(`
                <div class="yeekit-tier-row yeekit-bulk-tier-row">
                    <div class="tier-content">
                        <div class="tier-line-1">
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.min_qty}</label>
                                <input type="number" name="rule[bulk_tiers][${index}][min_qty]" value="" min="0" step="1">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.max_qty}</label>
                                <input type="number" name="rule[bulk_tiers][${index}][max_qty]" value="" min="0" step="1" placeholder="Any">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.type}</label>
                                <select name="rule[bulk_tiers][${index}][type]">
                                    <option value="percentage">${yeekit_dd_rule_params.i18n.percentage}</option>
                                    <option value="fixed">${yeekit_dd_rule_params.i18n.fixed}</option>
                                    <option value="fixed_price">${yeekit_dd_rule_params.i18n.fixed_price}</option>
                                </select>
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.value}</label>
                                <input type="number" name="rule[bulk_tiers][${index}][value]" value="" step="0.01">
                            </div>
                            <div class="yeekit-form-group tier-grow">
                                <label>${yeekit_dd_rule_params.i18n.label}</label>
                                <input type="text" name="rule[bulk_tiers][${index}][label]" value="">
                            </div>
                        </div>
                    </div>
                    <div class="tier-actions">
                        <span class="yeekit-remove-tier dashicons dashicons-no-alt" title="${yeekit_dd_rule_params.i18n.remove_range}"></span>
                    </div>
                </div>
            `);
        });

        $(document).on('click', '.yeekit-remove-tier', function () {
            $(this).closest('.yeekit-tier-row').remove();
        });

        /* ================= SET DISCOUNT TIER UI ================= */
        $(document).on('click', '#yeekit-add-set-tier', function () {
            const index = $('#yeekit-set-tiers-container .yeekit-tier-row').length;
            const row = `
                <div class="yeekit-tier-row yeekit-set-tier-row">
                    <div class="tier-content">
                        <div class="tier-line-1">
                            <div class="yeekit-form-group">
                                <label class="yeekit-set-qty-header">Minimum Quantity</label>
                                <input type="number" name="rule[set_adjustments][ranges][${index}][qty]" value="1" min="1" step="1">
                            </div>
                            <div class="yeekit-form-group">
                                <label>Recursive</label>
                                <div class="yeekit-checkbox-wrapper">
                                    <input type="checkbox" name="rule[set_adjustments][ranges][${index}][is_recursive]" value="1" class="yeekit-set-recursive-check">
                                </div>
                            </div>
                        </div>
                        <div class="tier-line-2">
                            <div class="yeekit-form-group">
                                <label>Discount Type</label>
                                <select name="rule[set_adjustments][ranges][${index}][type]" class="set-discount-type">
                                    <option value="fixed_set_price">Fixed price for set / bundle</option>
                                    <option value="percentage">Percentage discount per item</option>
                                    <option value="flat">Fixed discount per item</option>
                                </select>
                            </div>
                            <div class="yeekit-form-group">
                                <label>Value</label>
                                <input type="number" name="rule[set_adjustments][ranges][${index}][value]" value="" step="0.01">
                            </div>
                            <div class="yeekit-form-group tier-grow">
                                <label>Label</label>
                                <input type="text" name="rule[set_adjustments][ranges][${index}][label]" value="">
                            </div>
                        </div>
                    </div>
                    <div class="tier-actions">
                        <span class="yeekit-remove-set-tier dashicons dashicons-no-alt" title="Remove range"></span>
                    </div>
                </div>
            `;
            $('#yeekit-set-tiers-container').append(`
                <div class="yeekit-tier-row yeekit-set-tier-row">
                    <div class="tier-content">
                        <div class="tier-line-1">
                            <div class="yeekit-form-group">
                                <label class="yeekit-set-qty-header">${yeekit_dd_rule_params.i18n.minimum_quantity}</label>
                                <input type="number" name="rule[set_adjustments][ranges][${index}][qty]" value="1" min="1" step="1">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.type}</label>
                                <select name="rule[set_adjustments][ranges][${index}][type]" class="set-discount-type">
                                    <option value="fixed_set_price">${yeekit_dd_rule_params.i18n.fixed_price_set}</option>
                                    <option value="percentage">${yeekit_dd_rule_params.i18n.percentage_item}</option>
                                    <option value="flat">${yeekit_dd_rule_params.i18n.flat_item}</option>
                                </select>
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.value}</label>
                                <input type="number" name="rule[set_adjustments][ranges][${index}][value]" value="" step="0.01">
                            </div>
                            <div class="yeekit-form-group tier-grow">
                                <label>${yeekit_dd_rule_params.i18n.label}</label>
                                <input type="text" name="rule[set_adjustments][ranges][${index}][label]" value="">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.recursive}</label>
                                <div class="yeekit-checkbox-wrapper">
                                    <input type="checkbox" name="rule[set_adjustments][ranges][${index}][is_recursive]" value="1" class="yeekit-set-recursive-check">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tier-actions">
                        <span class="yeekit-remove-set-tier dashicons dashicons-no-alt" title="${yeekit_dd_rule_params.i18n.remove_range}"></span>
                    </div>
                </div>
            `);
            updateSetHeader();
        });

        $(document).on('click', '.yeekit-remove-set-tier', function () {
            $(this).closest('.yeekit-tier-row').remove();
            updateSetHeader();
        });

        function updateSetHeader() {
            const anyRecursive = $('.yeekit-set-recursive-check:checked').length > 0;
            if (anyRecursive) {
                $('.yeekit-set-qty-header').text(yeekit_dd_rule_params.i18n.quantity);
                // Hide Add/Remove buttons if recursive
                $('#yeekit-add-set-tier').hide();
                $('.yeekit-remove-set-tier').hide();
            } else {
                $('.yeekit-set-qty-header').text(yeekit_dd_rule_params.i18n.minimum_quantity);
                $('#yeekit-add-set-tier').show();
                $('.yeekit-remove-set-tier').show();
            }
        }

        $(document).on('change', '.yeekit-set-recursive-check', function () {
            const $checkbox = $(this);
            const $row = $checkbox.closest('.yeekit-tier-row');
            const isChecked = $checkbox.is(':checked');
            const $container = $('#yeekit-set-tiers-container');
            const rowCount = $container.find('.yeekit-tier-row').length;

            if (isChecked) {
                // If there are other rows, ask for confirmation
                if (rowCount > 1) {
                    if (!confirm(yeekit_dd_rule_params.i18n.recursive_confirm || 'If you make this recursive other row(s) will be removed!')) {
                        $checkbox.prop('checked', false);
                        return;
                    }
                    // Remove other rows
                    $row.siblings().remove();
                }
            }
            updateSetHeader();
        });

        // Init state
        updateSetHeader();


        /* ================= BUY X GET Y TIER UI ================= */
        function initBxgySelect2($row) {
            // Check current type to init correctly
            if ($row.find('.yeekit-product-ajax-select').length) {
                init_product_selectwoo($row.find('.yeekit-product-ajax-select'));
            }
            if ($row.find('.wc-enhanced-select').length) {
                // Determine if category or tag? BXGY only supports Product/Category/All for now.
                // Assuming Category for enhanced select in BXGY context if not otherwise specified.
                // But we need to populate options first?
                // The updateBxgyRows function handles population.
                if ($.fn.select2) {
                    $row.find('.wc-enhanced-select').select2({ width: 'resolve' });
                }
            }
        }

        function getBxgyType() {
            return $('.select_bxgy_type').val() || 'bxgy_product';
        }

        function renderBxgyGetContent(type, namePrefix, values = []) {
            let html = '';
            let label = yeekit_dd_rule_params.i18n.get_product;

            if (type === 'bxgy_category') {
                label = yeekit_dd_rule_params.i18n.get_category;
                html = `<label>${label}</label>
                        <select name="${namePrefix}[]" class="wc-enhanced-select" multiple style="min-width:150px;">`;

                if (yeekit_dd_admin && yeekit_dd_admin.product_categories) {
                    // Populate options
                    // We need to construct jQuery object to clone options
                    // Or simpler string replacement if product_categories is HTML string
                    html += $(yeekit_dd_admin.product_categories).html();
                }
                html += `</select>`;
            } else if (type === 'bxgy_all') {
                label = yeekit_dd_rule_params.i18n.get_any_product;
                html = `<label>${label}</label>
                        <input type="hidden" name="${namePrefix}" value="all">
                        <span class="description">${yeekit_dd_rule_params.i18n.customer_gets_any}</span>`;
            } else {
                // Default Product
                html = `<label>${label}</label>
                        <select name="${namePrefix}[]" class="yeekit-product-ajax-select" multiple style="min-width:150px;"></select>`;
            }
            return html;
        }

        // Helper to update ALL rows when Type changes
        function updateBxgyRows() {
            const type = getBxgyType();

            $('#yeekit-buyx-gety-tiers-container .yeekit-tier-row').each(function () {
                const $row = $(this);
                const $wrapper = $row.find('.yeekit-bxgy-get-item-wrapper'); // We need to add this class to wrapper

                // If wrapper doesn't exist (old HTML structure), find by structure
                // Structure: .tier-line-2 .yeekit-fieldset-content .yeekit-form-group.tier-grow
                let $target = $wrapper;
                if ($target.length === 0) {
                    $target = $row.find('.tier-line-2 .yeekit-fieldset-content .yeekit-form-group:first');
                    $target.addClass('yeekit-bxgy-get-item-wrapper');
                }

                // Check if we need to re-render
                // We can check a data attribute or class
                const currentType = $target.data('type');
                if (currentType !== type) {
                    // Re-render
                    // Warning: This clears values!
                    const index = $row.index(); // Note: index might be loose, but name needs correct index
                    // We need to extract the index from existing input name
                    // name="rule[buyx_gety_adjustments][ranges][${index}][get_product][]"
                    let namePrefix = `rule[buyx_gety_adjustments][ranges][${index}][get_product]`;

                    // Try to find index from existing input
                    const $oldInput = $target.find('input, select');
                    if ($oldInput.length) {
                        const name = $oldInput.attr('name');
                        if (name) {
                            const match = name.match(/ranges\]\[(\d+)\]/);
                            if (match) namePrefix = `rule[buyx_gety_adjustments][ranges][${match[1]}][get_product]`;
                        }
                    }

                    $target.html(renderBxgyGetContent(type, namePrefix));
                    $target.data('type', type);

                    // Re-init
                    if (type === 'bxgy_product') {
                        init_product_selectwoo($target.find('.yeekit-product-ajax-select'));
                    } else if (type === 'bxgy_category') {
                        if ($.fn.select2) $target.find('.wc-enhanced-select').select2({ width: 'resolve' });

                        // If we are updating for the first time on page load, we might want to preserve values?
                        // But changing type usually implies invalidating values. 
                        // For page load, PHP renders correctly (we will fix PHP).
                        // This JS is for client-side switch.
                    }
                }
            });
        }

        $(document).on('change', '.select_bxgy_type', function () {
            if (confirm(yeekit_dd_rule_params.i18n.change_type_confirm || 'Changing type will reset selected items in rows. Continue?')) {
                updateBxgyRows();
            } else {
                // Revert selection?
                // location.reload(); // Too aggressive
            }
        });

        $(document).on('click', '#yeekit-add-bxgy-tier', function () {
            const index = $('#yeekit-buyx-gety-tiers-container .yeekit-tier-row').length;
            const type = getBxgyType();
            // Generate content based on type
            const getContent = renderBxgyGetContent(type, `rule[buyx_gety_adjustments][ranges][${index}][get_product]`);

            const row = `
                <div class="yeekit-tier-row yeekit-buyx-gety-tier-row">
                    <div class="tier-content">
                        <div class="tier-line-1">
                            <div class="yeekit-fieldset-group">
                                <div class="yeekit-fieldset-legend">${yeekit_dd_rule_params.i18n.buy_quantity}</div>
                                <div class="yeekit-fieldset-content">
                                    <div class="yeekit-form-group">
                                        <label class="yeekit-bxgy-min-qty-header">${yeekit_dd_rule_params.i18n.min_qty}</label>
                                        <input type="number" name="rule[buyx_gety_adjustments][ranges][${index}][min_qty]" value="1" min="1" step="1">
                                    </div>
                                    <div class="yeekit-form-group yeekit-bxgy-max-qty-wrapper">
                                        <label class="yeekit-bxgy-max-qty-header">${yeekit_dd_rule_params.i18n.max_qty}</label>
                                        <input type="number" name="rule[buyx_gety_adjustments][ranges][${index}][max_qty]" value="" min="1" step="1" class="yeekit-bxgy-max-qty">
                                    </div>
                                </div>
                            </div>
                            <div class="yeekit-fieldset-group tier-grow">
                                <div class="yeekit-fieldset-legend">${yeekit_dd_rule_params.i18n.get_quantity}</div>
                                <div class="yeekit-fieldset-content">
                                    <div class="yeekit-form-group tier-grow yeekit-bxgy-get-item-wrapper" data-type="${type}">
                                        ${getContent}
                                    </div>
                                    <div class="yeekit-form-group">
                                        <label>${yeekit_dd_rule_params.i18n.get_qty}</label>
                                        <input type="number" name="rule[buyx_gety_adjustments][ranges][${index}][get_qty]" value="1" min="1" step="1">
                                    </div>
                                    <div class="yeekit-form-group">
                                        <label>${yeekit_dd_rule_params.i18n.type}</label>
                                        <select name="rule[buyx_gety_adjustments][ranges][${index}][discount_type]" class="buyx_gety_discount_select">
                                            <option value="free_product">${yeekit_dd_rule_params.i18n.free}</option>
                                            <option value="percentage">${yeekit_dd_rule_params.i18n.percentage}</option>
                                            <option value="flat">${yeekit_dd_rule_params.i18n.fixed}</option>
                                            <option value="fixed_price">${yeekit_dd_rule_params.i18n.fixed_price}</option>
                                        </select>
                                    </div>
                                    <div class="yeekit-form-group yeekit-bxgy-discount-value-wrapper">
                                        <label>${yeekit_dd_rule_params.i18n.value}</label>
                                        <input type="number" name="rule[buyx_gety_adjustments][ranges][${index}][discount_value]" value="" step="0.01" class="yeekit-bxgy-discount-value">
                                    </div>
                                </div>
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.recursive}</label>
                                <div class="yeekit-checkbox-wrapper">
                                    <input type="checkbox" name="rule[buyx_gety_adjustments][ranges][${index}][is_recursive]" value="1" class="yeekit-bxgy-recursive-check">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tier-actions">
                        <span class="yeekit-remove-bxgy-tier dashicons dashicons-no-alt" title="${yeekit_dd_rule_params.i18n.remove_range}"></span>
                    </div>
                </div>
            `;
            const $row = $(row);
            $('#yeekit-buyx-gety-tiers-container').append($row);
            initBxgySelect2($row);
        });

        $(document).on('click', '.yeekit-remove-bxgy-tier', function () {
            $(this).closest('.yeekit-tier-row').remove();
            updateBxgyHeader();
        });

        function updateBxgyVisibility() {
            const anyRecursive = $('.yeekit-bxgy-recursive-check:checked').length > 0;

            // Recursive Logic: Hide Max Qty
            $('.yeekit-bxgy-recursive-check').each(function () {
                const checked = $(this).is(':checked');
                // Hide Parent Wrapper yeekit-bxgy-max-qty-wrapper
                $(this).closest('.yeekit-tier-row').find('.yeekit-bxgy-max-qty-wrapper').toggle(!checked);
            });

            // Button visibility based on Recursive
            if (anyRecursive) {
                $('#yeekit-add-bxgy-tier').hide();
                $('.yeekit-remove-bxgy-tier').hide();
            } else {
                $('#yeekit-add-bxgy-tier').show();
                $('.yeekit-remove-bxgy-tier').show();
            }

            // Discount Type Logic: Hide Value if Free
            $('.buyx_gety_discount_select').each(function () {
                const val = $(this).val();
                const $wrapper = $(this).closest('.yeekit-tier-row').find('.yeekit-bxgy-discount-value-wrapper');
                if (val === 'free_product') {
                    $wrapper.hide();
                } else {
                    $wrapper.show();
                }
            });
            updateBxgyHeader();
        }

        function updateBxgyHeader() {
            const anyRecursive = $('.yeekit-bxgy-recursive-check:checked').length > 0;
            if (anyRecursive) {
                $('.yeekit-bxgy-min-qty-header').text(yeekit_dd_rule_params.i18n.quantity);
            } else {
                $('.yeekit-bxgy-min-qty-header').text(yeekit_dd_rule_params.i18n.min_qty);
            }
        }

        // Handle Recursive Click with Confirmation
        $(document).on('change', '.yeekit-bxgy-recursive-check', function () {
            const isChecked = $(this).is(':checked');
            const rowCount = $('#yeekit-buyx-gety-tiers-container .yeekit-tier-row').length;

            if (isChecked && rowCount > 1) {
                if (!confirm(yeekit_dd_rule_params.i18n.recursive_confirm || 'Recursive option works with a single range. Remove other ranges?')) {
                    $(this).prop('checked', false);
                    updateBxgyVisibility();
                    return;
                }
                $(this).closest('.yeekit-tier-row').siblings().remove();
            }
            updateBxgyVisibility();
        });

        $(document).on('change', '.buyx_gety_discount_select', updateBxgyVisibility);
        updateBxgyVisibility(); // Init

        /* ================= BUY X GET X TIER UI ================= */
        $(document).on('click', '#yeekit-add-bogo-tier', function () {
            const index = $('#yeekit-buyx-getx-tiers-container .yeekit-tier-row').length;
            const row = `
                <div class="yeekit-tier-row yeekit-buyx-getx-tier-row">
                    <div class="tier-content">
                        <div class="tier-line-1">
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.min_qty}</label>
                                <input type="number" name="rule[buyx_getx_adjustments][ranges][${index}][min_qty]" value="1" min="1" step="1">
                            </div>
                            <div class="yeekit-form-group yeekit-bogo-max-qty-wrapper">
                                <label class="yeekit-bogo-max-qty-header">${yeekit_dd_rule_params.i18n.max_qty}</label>
                                <input type="number" name="rule[buyx_getx_adjustments][ranges][${index}][max_qty]" value="" min="1" step="1" class="yeekit-bogo-max-qty">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.free_qty}</label>
                                <input type="number" name="rule[buyx_getx_adjustments][ranges][${index}][free_qty]" value="1" min="1" step="1">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.type}</label>
                                <select name="rule[buyx_getx_adjustments][ranges][${index}][free_type]" class="awdr-bogo-discount-type buyx_getx_discount_select">
                                    <option value="free_product">${yeekit_dd_rule_params.i18n.free}</option>
                                    <option value="percentage">${yeekit_dd_rule_params.i18n.percentage}</option>
                                    <option value="flat">${yeekit_dd_rule_params.i18n.fixed}</option>
                                </select>
                            </div>
                            <div class="yeekit-form-group yeekit-bogo-amount-wrapper">
                                <label>${yeekit_dd_rule_params.i18n.value}</label>
                                <input type="number" name="rule[buyx_getx_adjustments][ranges][${index}][amount]" value="" step="0.01" class="yeekit-bogo-amount">
                            </div>
                            <div class="yeekit-form-group">
                                <label>${yeekit_dd_rule_params.i18n.recursive}</label>
                                <div class="yeekit-checkbox-wrapper">
                                    <input type="checkbox" name="rule[buyx_getx_adjustments][ranges][${index}][is_recursive]" value="1" class="yeekit-bogo-recursive-check">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tier-actions">
                        <span class="yeekit-remove-bogo-tier dashicons dashicons-no-alt" title="${yeekit_dd_rule_params.i18n.remove_range}"></span>
                    </div>
                </div>
            `;
            $('#yeekit-buyx-getx-tiers-container').append(row);
            $('#yeekit-buyx-getx-tiers-container .yeekit-tier-row:last .awdr-bogo-discount-type').trigger('change');
        });

        $(document).on('click', '.yeekit-remove-bogo-tier', function () {
            $(this).closest('.yeekit-tier-row').remove();
        });


        // BOGO Recursive Logic
        $(document).on('change', '.yeekit-bogo-recursive-check', function () {
            const $checkbox = $(this);
            const $row = $checkbox.closest('.yeekit-tier-row');
            const isChecked = $checkbox.is(':checked');
            const $container = $('#yeekit-buyx-getx-tiers-container');
            const rowCount = $container.find('.yeekit-tier-row').length;

            if (isChecked) {
                // If there are other rows, ask for confirmation
                if (rowCount > 1) {
                    if (!confirm(yeekit_dd_rule_params.i18n.recursive_confirm)) {
                        $checkbox.prop('checked', false);
                        return;
                    }
                    // Remove other rows
                    $row.siblings().remove();
                }

                // Hide Add Range button
                $('#yeekit-add-bogo-tier').hide();
                // Hide Max Qty Column Wrapper
                $('.yeekit-bogo-max-qty-wrapper').hide();
                // Hide Remove button
                $('.yeekit-remove-bogo-tier').hide();
            } else {
                // Unchecked
                // Show Add Range button
                $('#yeekit-add-bogo-tier').show();
                // Show Max Qty Column Wrapper
                $('.yeekit-bogo-max-qty-wrapper').show();
                // Show Remove button
                $('.yeekit-remove-bogo-tier').show();
            }
        });

        // Toggle BOGO Amount Visibility
        $(document).on('change', '.awdr-bogo-discount-type', function () {
            const val = $(this).val();
            const $wrapper = $(this).closest('.yeekit-tier-row').find('.yeekit-bogo-amount-wrapper');
            if (val === 'free_product') {
                $wrapper.hide();
            } else {
                $wrapper.show();
            }
        });
        // Init logic for existing BOGO rows
        $('.awdr-bogo-discount-type').each(function () {
            $(this).trigger('change');
        });

        // Init BOGO state
        function initBogoState() {
            if ($('.yeekit-bogo-recursive-check:checked').length > 0) {
                $('#yeekit-add-bogo-tier').hide();
                $('.yeekit-bogo-max-qty-wrapper').hide();
                $('.yeekit-remove-bogo-tier').hide();
            } else {
                $('#yeekit-add-bogo-tier').show();
                $('.yeekit-bogo-max-qty-wrapper').show();
                $('.yeekit-remove-bogo-tier').show();
            }
        }
        initBogoState();


        /* ================= DYNAMIC CONDITIONS ================= */
        // condition type change
        $(document).on('change', '.yeekit-cond-type', function () {
            const $row = $(this).closest('.yeekit-cond-row');
            render_rule_value($row);
        });
        $(document).on('change', '.yeekit-filter-type', function () {
            const row = $(this).closest('.yeekit-filter-row');
            render_filter_value(
                $(this).val(),
                row.data('index'),
                row.find('.yeekit-filter-value')
            );
        });
        $(document).on('click', '.yeekit-add-filter', function () {
            const index = get_next_filter_index();
            $('.yeekit-filters-wrap').append(build_filter_row(index));
            const row = $('.yeekit-filter-row[data-index="' + index + '"]');
            render_filter_value(
                row.find('.yeekit-filter-type').val(),
                index,
                row.find('.yeekit-filter-value')
            );
        });
        $(document).on('click', '.yeekit-filter-remove', function () {
            $(this).closest('.yeekit-filter-row').remove();
        });
        // Remove condition (rule) - Added missing listener
        $(document).on('click', '.yeekit-cond-remove', function () {
            $(this).closest('.yeekit-cond-row').remove();
        });
        // add new condition (rule)
        // Fixed selector to use ID '#' because PHP renders id="yeekit-dd-add-condition"
        $(document).on('click', '#yeekit-dd-add-condition', function (e) {
            e.preventDefault();
            const index = get_next_condition_index();
            const $row = $(build_condition_row(index));
            $('#yeekit-dd-conditions-wrap').append($row); // Note: PHP has id="yeekit-dd-conditions-wrap"
            // hydrate type select + render operator/value
            hydrate_existing_condition_row($row);
        });
        // init existing rule rows
        $('.yeekit-cond-row').each(function () {
            hydrate_existing_condition_row($(this));
        });
        // change rule type
        $(document).on('change', '.yeekit-cond-type', function () {
            render_rule_value($(this).closest('.yeekit-cond-row'));
        });
        toggle_fields();

        // Fix: Prevent "Changes you made may not be saved" warning when saving rule or other forms
        $('form').on('submit', function () {
            window.onbeforeunload = null;
        });
    });
})(jQuery);
jQuery(document).ready(function ($) {
    /* ================= SETTINGS VISIBILITY ================= */
    function toggle_sale_badge_settings() {
        var badge_setting = $('#yk_dd_show_on_sale_badge').val();
        var $dependents = $('#yk_dd_customize_sale_badge, #yk_dd_force_override_sale_badge, #yk_dd_show_percentage_in_sale_badge, #yk_dd_sale_badge_text, #yk_dd_sale_badge_content').closest('tr');

        if (badge_setting === 'disabled') {
            $dependents.hide();
        } else {
            $dependents.show();
            toggle_customize_settings();
        }
    }

    function toggle_customize_settings() {
        var badge_setting = $('#yk_dd_show_on_sale_badge').val();
        if (badge_setting === 'disabled') return; // Handled by parent

        var customize = $('#yk_dd_customize_sale_badge').is(':checked');
        var $forceOverrideRow = $('#yk_dd_force_override_sale_badge').closest('tr');

        // Customize -> Show Force Override
        if (customize) {
            $forceOverrideRow.show();
            toggle_force_override_settings(); // Trigger child dependency
        } else {
            $forceOverrideRow.hide();
            // Also hide children of Force Override
            $('#yk_dd_show_percentage_in_sale_badge, #yk_dd_sale_badge_text').closest('tr').hide();
        }
    }

    function toggle_force_override_settings() {
        // Can only be active if Customize is checked
        var customize = $('#yk_dd_customize_sale_badge').is(':checked');
        if (!customize) return;

        var force = $('#yk_dd_force_override_sale_badge').is(':checked');
        var $dependents = $('#yk_dd_show_percentage_in_sale_badge, #yk_dd_sale_badge_text').closest('tr');

        if (force) {
            $dependents.show();
        } else {
            $dependents.hide();
        }
    }

    // Init and Bind
    if ($('#yk_dd_show_on_sale_badge').length) {
        $(document).on('change', '#yk_dd_show_on_sale_badge', toggle_sale_badge_settings);
        $(document).on('change', '#yk_dd_customize_sale_badge', toggle_customize_settings);
        $(document).on('change', '#yk_dd_force_override_sale_badge', toggle_force_override_settings);

        // Initial run
        toggle_sale_badge_settings();
        // toggle_customize_settings is called by toggle_sale_badge_settings, but we doubly ensure
        toggle_customize_settings();
    }
});

jQuery(function ($) {
    /* ================= SHOW DISCOUNTED PRICE VISIBILITY ================= */
    function toggle_discounted_price_settings() {
        var setting = $('#yk_dd_show_discounted_price').val();
        var $dependents = $('#yk_dd_show_discounted_price_pages').closest('tr');

        if (setting === 'disabled') {
            $dependents.hide();
        } else {
            $dependents.show();
        }
    }

    if ($('#yk_dd_show_discounted_price').length) {
        $(document).on('change', '#yk_dd_show_discounted_price', toggle_discounted_price_settings);
        toggle_discounted_price_settings();
    }
    /* ================= CART NOTIFICATION VISIBILITY ================= */
    function toggle_cart_notification_settings() {
        var enabled = $('#yk_dd_show_cart_notifications').is(':checked');
        var $dependents = $('#yk_dd_cart_notification_text').closest('tr');

        if (enabled) {
            $dependents.show();
        } else {
            $dependents.hide();
        }
    }

    if ($('#yk_dd_show_cart_notifications').length) {
        $(document).on('change', '#yk_dd_show_cart_notifications', toggle_cart_notification_settings);
        toggle_cart_notification_settings();
    }
});

