<?php
namespace YayMail\Elements;

use YayMail\Abstracts\BaseElement;
use YayMail\Utils\SingletonTrait;

/**
 * Countdown Elements
 */
class Countdown extends BaseElement {

    use SingletonTrait;

    protected static $type = 'countdown';

    public $available_email_ids = [];

    public static function get_data( $attributes = [] ) {
        self::$icon = '<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.22003 8.48994C7.91003 8.28994 7.50003 8.18994 7.01003 8.18994C6.52003 8.18994 6.10003 8.28994 5.78003 8.48994C5.46003 8.68994 5.22003 8.96994 5.07003 9.32994C4.92003 9.67994 4.84003 10.0999 4.84003 10.5699V14.1999C4.84003 14.6599 4.92003 15.0699 5.08003 15.4199C5.24003 15.7699 5.48003 16.0399 5.80003 16.2399C6.12003 16.4399 6.52003 16.5399 7.01003 16.5399C7.50003 16.5399 7.88003 16.4399 8.20003 16.2399C8.52003 16.0399 8.76003 15.7699 8.92003 15.4199C9.08003 15.0699 9.16003 14.6599 9.16003 14.1999V10.5699C9.16003 10.0999 9.08003 9.67994 8.93003 9.32994C8.78003 8.96994 8.54003 8.68994 8.22003 8.48994ZM7.60003 14.1699C7.60003 14.2999 7.59003 14.4499 7.56003 14.6099C7.53003 14.7599 7.48003 14.8999 7.40003 15.0099C7.32003 15.1199 7.19003 15.1799 7.01003 15.1799C6.83003 15.1799 6.71003 15.1199 6.62003 15.0099C6.53003 14.8999 6.48003 14.7599 6.45003 14.6099C6.42003 14.4499 6.41003 14.2999 6.41003 14.1699V10.5999C6.41003 10.4499 6.42003 10.2999 6.44003 10.1399C6.47003 9.97994 6.52003 9.83994 6.60003 9.72994C6.69003 9.60994 6.82003 9.54994 7.01003 9.54994C7.20003 9.54994 7.33003 9.60994 7.41003 9.72994C7.49003 9.83994 7.54003 9.97994 7.56003 10.1399C7.59003 10.2999 7.60003 10.4499 7.60003 10.5999V14.1699Z" />
<path d="M20 3.75H14C13.21 3.75 12.5 4.09 12 4.62C11.5 4.08 10.79 3.75 10 3.75H4C2.48 3.75 1.25 4.98 1.25 6.5V18.5C1.25 20.02 2.48 21.25 4 21.25H10C10.79 21.25 11.5 20.91 12 20.38C12.5 20.92 13.21 21.25 14 21.25H20C21.52 21.25 22.75 20.02 22.75 18.5V6.5C22.75 4.98 21.52 3.75 20 3.75ZM17.54 5.25V5.69C17.49 5.77 17.41 5.85 17.31 5.94C17.22 6.02 17.09 6.06 16.94 6.06C16.74 6.06 16.6 6 16.51 5.88C16.43 5.76 16.38 5.59 16.36 5.38C16.36 5.34 16.36 5.29 16.36 5.25H17.55H17.54ZM10 19.75H4C3.31 19.75 2.75 19.19 2.75 18.5V6.5C2.75 5.81 3.31 5.25 4 5.25H10C10.69 5.25 11.25 5.81 11.25 6.5V18.5C11.25 19.19 10.69 19.75 10 19.75ZM16.57 16.91C16.67 16.78 16.81 16.72 17 16.72C17.19 16.72 17.34 16.78 17.43 16.91C17.52 17.04 17.58 17.2 17.61 17.4C17.64 17.6 17.66 17.81 17.65 18.02C17.65 18.2 17.64 18.39 17.61 18.58C17.58 18.77 17.52 18.94 17.43 19.07C17.34 19.2 17.19 19.27 17 19.27C16.81 19.27 16.66 19.21 16.56 19.08C16.47 18.95 16.41 18.78 16.38 18.59C16.35 18.39 16.34 18.2 16.34 18.02C16.34 17.8 16.35 17.59 16.38 17.4C16.41 17.2 16.48 17.04 16.57 16.91ZM16.41 14.21C16.41 13.93 16.46 13.7 16.55 13.53C16.65 13.35 16.8 13.26 17 13.26C17.2 13.26 17.34 13.35 17.43 13.53C17.52 13.7 17.57 13.93 17.57 14.22C17.57 14.47 17.55 14.69 17.51 14.88C17.47 15.07 17.41 15.21 17.32 15.31C17.24 15.41 17.13 15.46 17 15.46C16.86 15.46 16.74 15.41 16.65 15.31C16.56 15.21 16.5 15.07 16.46 14.88C16.43 14.69 16.41 14.46 16.41 14.21ZM21.25 18.5C21.25 19.19 20.69 19.75 20 19.75H18.67C18.79 19.6 18.9 19.42 18.97 19.22C19.12 18.84 19.18 18.41 19.17 17.92C19.17 17.7 19.15 17.49 19.1 17.3C19.06 17.11 19 16.93 18.92 16.77C18.84 16.61 18.74 16.47 18.62 16.35C18.51 16.22 18.37 16.12 18.21 16.04C18.44 15.89 18.63 15.67 18.78 15.38C18.94 15.09 19.02 14.71 19.03 14.26C19.03 13.81 18.97 13.43 18.82 13.11C18.67 12.78 18.45 12.53 18.14 12.36C17.84 12.19 17.46 12.1 17 12.1C16.54 12.1 16.17 12.19 15.86 12.36C15.55 12.53 15.32 12.78 15.17 13.11C15.02 13.43 14.94 13.81 14.95 14.26C14.95 14.71 15.04 15.08 15.2 15.37C15.37 15.66 15.56 15.88 15.78 16.04C15.62 16.12 15.48 16.22 15.36 16.35C15.25 16.47 15.15 16.61 15.07 16.77C14.99 16.93 14.93 17.11 14.89 17.3C14.85 17.49 14.83 17.7 14.83 17.92C14.83 18.41 14.9 18.84 15.03 19.22C15.1 19.42 15.21 19.6 15.33 19.75H14C13.31 19.75 12.75 19.19 12.75 18.5V6.5C12.75 5.81 13.31 5.25 14 5.25H14.77C14.79 5.53 14.83 5.8 14.9 6.05C15.01 6.42 15.2 6.71 15.46 6.93C15.72 7.14 16.07 7.25 16.5 7.24C16.73 7.24 16.94 7.19 17.12 7.11C17.3 7.03 17.44 6.92 17.53 6.77V7.6C17.53 8.01 17.51 8.33 17.48 8.57C17.45 8.81 17.39 8.98 17.3 9.08C17.21 9.18 17.09 9.23 16.93 9.23C16.67 9.23 16.5 9.15 16.43 8.98C16.36 8.81 16.33 8.56 16.33 8.22H14.87V8.34C14.87 8.79 14.94 9.17 15.07 9.48C15.2 9.79 15.42 10.02 15.72 10.18C16.02 10.33 16.42 10.41 16.92 10.41C17.5 10.41 17.95 10.29 18.26 10.05C18.57 9.81 18.79 9.48 18.91 9.06C19.03 8.64 19.09 8.17 19.09 7.64V5.25H19.99C20.68 5.25 21.24 5.81 21.24 6.5V18.5H21.25Z" />
</svg>
';

        return [
            'id'              => uniqid(),
            'type'            => self::$type,
            'name'            => __( 'Countdown (support for Google SMTP)', 'yaymail' ),
            'icon'            => self::$icon,
            'group'           => 'basic',
            'available'       => false,
            'disabled_reason' => [
                'html' => __( 'This element is available in YayMail Pro', 'yaymail' ),
            ],
            'position'        => 145,
            'children'        => isset( $attributes['children'] ) ? $attributes['children'] : [],
            'status_info'     => [
                'text' => __( 'New', 'yaymail' ),
            ],
            'data'            => [],
        ];
    }
}
