<?php
namespace YayWholesaleB2B\Engine;

use YayWholesaleB2B\Helpers\SettingsHelper;

/**
 * Activate and deactive method of the plugin and relates.
 */
class ActDeact {

    public static function install_yaywholesaleb2b_admin_notice() {
        /* translators: %s: Woocommerce link */
        echo '<div class="error"><p><strong>' . sprintf( esc_html__( 'YayWholesale is enabled but not effective. It requires %s in order to work', 'yay-wholesale-b2b' ), '<a href="' . esc_url( admin_url( 'plugin-install.php?s=woocommerce&tab=search&type=term' ) ) . '">WooCommerce</a>' ) . '</strong></p></div>';
        return false;
    }

    public static function before_woocommerce_init() {
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', YAYWHOLESALEB2B_FILE, true );
        }
    }

    public static function activate() {

        if ( ! function_exists( 'WC' ) ) {
            return;
        }

        $setting = SettingsHelper::get_settings();
        if ( empty( $setting['general']['default_role'] ) ) {
            $role_slugs = array_column( get_option( 'yaywholesaleb2b_roles', [] ), 'slug' );
            if ( count( $role_slugs ) > 0 ) {
                $setting['general']['default_role'] = $role_slugs[0];
            } else {
                $default_slug      = 'ywhs_default_role';
                $default_role_name = __( 'YayWholesale Role', 'yay-wholesale-b2b' );
                $default_role      = [
                    'id'               => 1,
                    'name'             => $default_role_name,
                    'description'      => __( 'This is a default role generated by YayWholesale.', 'yay-wholesale-b2b' ),
                    'discount'         => 0,
                    'minOrderQuantity' => 0,
                    'minOrderAmount'   => 0,
                    'applyToSalePrice' => false,
                    'status'           => true,
                    'slug'             => $default_slug,
                ];

                add_role( $default_slug, $default_role_name, [ 'read' => true ] );

                update_option( 'yaywholesaleb2b_roles', [ $default_role ] );
                $setting['general']['default_role'] = $default_slug;
            }//end if
            update_option( 'yaywholesaleb2b_settings', $setting );
        }//end if
    }

    public static function deactivate() {

        if ( ! function_exists( 'WC' ) ) {
            return;
        }
    }
}
