<?php
/**
 * Server-side rendering for XTND TABLE_OF_CONTENT block.
 *
 * @package XTND_TABLE_OF_CONTENT
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'XTND_TABLE_OF_CONTENT' ) ) {
	return '';
}

$attributes            = isset( $attributes ) ? $attributes : array();
$toc_title             = ( ! isset( $attributes['title'] ) || 'Table of Contents' === $attributes['title'] ) ? __( 'Table of Contents', 'xtnd-table-of-content' ) : $attributes['title'];
$selected_heading_tags = isset( $attributes['headingTags'] ) ? $attributes['headingTags'] : array( 'h2' );
$block_id              = 'xtnd-toc-' . uniqid();

global $post;
if ( ! $post instanceof WP_Post ) {
	return;
}

$blocks   = parse_blocks( $post->post_content );
$instance = XTND_TABLE_OF_CONTENT::get_instance();
$headings = $instance->extract_headings_by_tags( $blocks, $selected_heading_tags );

$task       = $instance->asset_url( 'image', 'task.svg' );
$arrow_down = $instance->asset_url( 'image', 'arrow-down.svg' );
$arrow_left = $instance->asset_url( 'image', 'arrow-left.svg' );

if ( empty( $headings ) ) {
	return;
}
?>
<div class="xtnd-toc-block xtnd-toc-block-style xtnd-toc-block-wrapper xtnd-toc-block-container" id="<?php echo esc_attr( $block_id ); ?>">
	<?php if ( $toc_title ) : ?>
		<h4
			role="button"
			tabindex="0"
			class="xtnd-toc-toggle"
			data-block-id="<?php echo esc_attr( $block_id ); ?>"
			aria-expanded="false">
			<img id="<?php echo esc_attr( $block_id ); ?>-task" src="<?php echo esc_url( $task ); ?>" class="xtnd-toc-icon" alt="Task Icon" />
			<span class="xtnd-toc-text"><?php echo esc_html( $toc_title ); ?></span>
			<img id="<?php echo esc_attr( $block_id ); ?>-arrow" src="<?php echo esc_url( $arrow_down ); ?>" class="xtnd-toc-arrow" alt="Arrow Icon" />
		</h4>
	<?php endif; ?>
	<div
		id="<?php echo esc_attr( $block_id ); ?>-content"
		class="xtnd-toc-content"
	>
		<ul class="xtnd-toc-list">
			<?php foreach ( $headings as $index => $heading ) : ?>
				<li class="xtnd-toc-item">
					<img id="<?php echo esc_attr( $block_id . '-arrow-' . $index ); ?>" src="<?php echo esc_url( $arrow_left ); ?>" class="xtnd-toc-icon" alt="Arrow Icon" />
					<a class="xtnd-toc-link" href="#<?php echo esc_attr( sanitize_title( $heading ) ); ?>"><?php echo esc_html( $heading ); ?></a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
</div>

