<?php
/**
 * Template 2 View — Modern Glassmorphism (with Background Mode + Color Pickers wired)
 *
 * @package MDXCSP_Coming_Soon_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$template_key = 'template-2';

/**
 * Enqueue template CSS + dynamic inline CSS
 */
function xpertcodes_enqueue_frontend_assets_template_2() {

	wp_register_style(
		'xpertcodes-template-2',
		plugin_dir_url( __FILE__ ) . 'assets/template-2.css',
		array(),
		'1.0.0'
	);
	wp_enqueue_style( 'xpertcodes-template-2' );

	// Load dynamic colors from options.
	$all_settings = get_option( 'mdxcsp_template_settings', array() );
	$opts         = isset( $all_settings['template-2'] ) && is_array( $all_settings['template-2'] ) ? $all_settings['template-2'] : array();

	$hex = static function( $c ): string {
		$c = (string) $c;
		if ( '' === trim( $c ) ) {
			return '';
		}
		if ( function_exists( 'sanitize_hex_color' ) ) {
			$san = sanitize_hex_color( $c );
			return $san ? $san : '';
		}
		return preg_match( '/^#([A-Fa-f0-9]{3}){1,2}$/', $c ) ? $c : '';
	};

	$title_color             = isset( $opts['title_color'] ) ? $hex( $opts['title_color'] ) : '#ffffff';
	$subtitle_color          = isset( $opts['subtitle_color'] ) ? $hex( $opts['subtitle_color'] ) : '#E5E7EB';
	$countdown_color         = isset( $opts['countdown_color'] ) ? $hex( $opts['countdown_color'] ) : '#ffffff';
	$copyright_color         = isset( $opts['copyright_color'] ) ? $hex( $opts['copyright_color'] ) : '#9CA3AF';
	$nav_color               = isset( $opts['nav_color'] ) ? $hex( $opts['nav_color'] ) : '#ffffff';
	$menu_toggle_label_color = isset( $opts['menu_toggle_label_color'] ) ? $hex( $opts['menu_toggle_label_color'] ) : $nav_color;

	$custom_css = "
		body.mdxcsp-coming-soon.template-2 .mdxcsp-title,
		body.mdxcsp-coming-soon.template-2 .mdxcsp-title .accent,
		.dynamic-title-color { color: {$title_color} !important; }

		body.mdxcsp-coming-soon.template-2 .mdxcsp-subtitle,
		.dynamic-subtitle-color { color: {$subtitle_color} !important; }

		body.mdxcsp-coming-soon.template-2 .mdxcsp-counter,
		body.mdxcsp-coming-soon.template-2 .mdxcsp-counter .num,
		body.mdxcsp-coming-soon.template-2 .mdxcsp-counter .lbl,
		.dynamic-countdown-color { color: {$countdown_color} !important; }

		body.mdxcsp-coming-soon.template-2 .mdxcsp-header,
		body.mdxcsp-coming-soon.template-2 .mdxcsp-header a,
		.dynamic-nav-color { color: {$nav_color} !important; }

		body.mdxcsp-coming-soon.template-2 .mdxcsp-menu-toggle,
		.dynamic-menu-toggle-color { color: {$menu_toggle_label_color} !important; }

		body.mdxcsp-coming-soon.template-2 .mdxcsp-footer-left,
		.dynamic-copyright-color { color: {$copyright_color} !important; }
	";

	wp_add_inline_style( 'xpertcodes-template-2', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'xpertcodes_enqueue_frontend_assets_template_2' );

// Get template-specific settings again (safe for HTML section)
$all_settings = get_option( 'mdxcsp_template_settings', array() );
$opts         = isset( $all_settings[ $template_key ] ) && is_array( $all_settings[ $template_key ] ) ? $all_settings[ $template_key ] : array();

// Helper
$hex = static function( $c ): string {
	$c = (string) $c;
	if ( '' === trim( $c ) ) {
		return '';
	}
	if ( function_exists( 'sanitize_hex_color' ) ) {
		$san = sanitize_hex_color( $c );
		return $san ? $san : '';
	}
	return preg_match( '/^#([A-Fa-f0-9]{3}){1,2}$/', $c ) ? $c : '';
};

// IDs, colors, media, etc.
$logo_id   = isset( $opts['logo_id'] ) ? absint( $opts['logo_id'] ) : 0;
$bg_id     = isset( $opts['bg_id'] ) ? absint( $opts['bg_id'] ) : 0;
$bg_mode   = isset( $opts['bg_mode'] ) && 'color' === $opts['bg_mode'] ? 'color' : 'image';
$bg_color  = isset( $opts['bg_color'] ) ? (string) $opts['bg_color'] : '';
$title     = isset( $opts['title'] ) ? (string) $opts['title'] : '';
$subtitle  = isset( $opts['subtitle'] ) ? (string) $opts['subtitle'] : '';

$title_color             = isset( $opts['title_color'] ) ? $hex( $opts['title_color'] ) : '#ffffff';
$subtitle_color          = isset( $opts['subtitle_color'] ) ? $hex( $opts['subtitle_color'] ) : '#E5E7EB';
$countdown_color         = isset( $opts['countdown_color'] ) ? $hex( $opts['countdown_color'] ) : '#ffffff';
$copyright_color         = isset( $opts['copyright_color'] ) ? $hex( $opts['copyright_color'] ) : '#9CA3AF';
$nav_color               = isset( $opts['nav_color'] ) ? $hex( $opts['nav_color'] ) : '#ffffff';
$menu_toggle_label_color = isset( $opts['menu_toggle_label_color'] ) ? $hex( $opts['menu_toggle_label_color'] ) : $nav_color;

$menu_1_color = isset( $opts['menu_1_color'] ) ? $hex( $opts['menu_1_color'] ) : $nav_color;
$menu_2_color = isset( $opts['menu_2_color'] ) ? $hex( $opts['menu_2_color'] ) : $nav_color;
$menu_3_color = isset( $opts['menu_3_color'] ) ? $hex( $opts['menu_3_color'] ) : $nav_color;

$menu_items = array(
	array(
		'label' => $opts['menu_1_label'] ?? '',
		'url'   => $opts['menu_1_url'] ?? '#',
		'color' => $menu_1_color,
	),
	array(
		'label' => $opts['menu_2_label'] ?? '',
		'url'   => $opts['menu_2_url'] ?? '#',
		'color' => $menu_2_color,
	),
	array(
		'label' => $opts['menu_3_label'] ?? '',
		'url'   => $opts['menu_3_url'] ?? '#',
		'color' => $menu_3_color,
	),
);

$menu_toggle_icon_id = isset( $opts['menu_toggle_icon_id'] ) ? absint( $opts['menu_toggle_icon_id'] ) : 0;
$menu_toggle_label   = isset( $opts['menu_toggle_label'] ) ? (string) $opts['menu_toggle_label'] : '';
$menu_toggle_icon    = $menu_toggle_icon_id ? wp_get_attachment_image_url( $menu_toggle_icon_id, 'full' ) : '';

$logo_url = $logo_id ? wp_get_attachment_image_url( $logo_id, 'full' ) : '';
$bg_url   = $bg_id ? wp_get_attachment_image_url( $bg_id, 'full' ) : '';

$asset_logo = MDXCSP_PLUGIN_URL . 'assets/images/logo.png';
$asset_bg   = MDXCSP_PLUGIN_URL . 'assets/images/bg-1.png';
$asset_tog  = MDXCSP_PLUGIN_URL . 'assets/images/toggle.png';
$asset_s1   = MDXCSP_PLUGIN_URL . 'assets/images/social-1.png';
$asset_s2   = MDXCSP_PLUGIN_URL . 'assets/images/social-2.png';

if ( ! $logo_url ) {
	$logo_url = $asset_logo;
}
if ( 'image' === $bg_mode && ! $bg_url ) {
	$bg_url = $asset_bg;
}
if ( '' === trim( $menu_toggle_label ) && '' === (string) $menu_toggle_icon ) {
	$menu_toggle_label = '☰ ' . __( 'Menu', 'xpertcodes-coming-soon-maintenance' );
	$menu_toggle_icon  = $asset_tog;
}

$social_1_id  = isset( $opts['social_1_id'] ) ? absint( $opts['social_1_id'] ) : 0;
$social_1_url = isset( $opts['social_1_url'] ) ? (string) $opts['social_1_url'] : '#social';
$social_1_img = $social_1_id ? wp_get_attachment_image_url( $social_1_id, 'full' ) : $asset_s1;

$social_2_id  = isset( $opts['social_2_id'] ) ? absint( $opts['social_2_id'] ) : 0;
$social_2_url = isset( $opts['social_2_url'] ) ? (string) $opts['social_2_url'] : '#social-2';
$social_2_img = $social_2_id ? wp_get_attachment_image_url( $social_2_id, 'full' ) : $asset_s2;

$page_title = $title ?: __( 'Coming Soon', 'xpertcodes-coming-soon-maintenance' );

$inline_style = '';
if ( 'color' === $bg_mode && $bg_color ) {
	$inline_style = 'background:' . esc_attr( $bg_color ) . ';';
} elseif ( 'image' === $bg_mode ) {
	$inline_style = "background:url('" . esc_url( $bg_url ) . "') no-repeat center center / cover;";
}

if ( '' === trim( $title ) ) {
	$title = __( 'We\'re launching soon', 'xpertcodes-coming-soon-maintenance' );
}
if ( '' === trim( $subtitle ) ) {
	$subtitle = __( 'Our site is getting ready. Stay tuned for something amazing!', 'xpertcodes-coming-soon-maintenance' );
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="robots" content="noindex, nofollow, noarchive">
	<title><?php echo esc_html( $page_title ); ?></title>
	<?php wp_head(); ?>
</head>

<body <?php body_class( 'mdxcsp-coming-soon template-2' ); ?><?php echo $inline_style ? ' style="' . wp_kses( $inline_style, array() ) . '"' : ''; ?>>
<?php if ( function_exists( 'wp_body_open' ) ) wp_body_open(); ?>

<div class="mdxcsp-bg">
	<span class="blob blob-1"></span>
	<span class="blob blob-2"></span>
	<span class="blob blob-3"></span>
	<div class="grain"></div>
</div>

<header class="mdxcsp-header dynamic-nav-color">
	<?php if ( $logo_url ) : ?>
		<a class="mdxcsp-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
			<img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php esc_attr_e( 'Logo', 'xpertcodes-coming-soon-maintenance' ); ?>">
		</a>
	<?php endif; ?>

	<?php if ( ! empty( array_filter( wp_list_pluck( $menu_items, 'label' ) ) ) ) : ?>
		<div class="mdxcsp-nav">
			<button type="button"
				class="mdxcsp-menu-toggle dynamic-menu-toggle-color"
				aria-label="<?php esc_attr_e( 'Toggle Menu', 'xpertcodes-coming-soon-maintenance' ); ?>"
				aria-expanded="false"
				aria-controls="mdxcsp-dropdown-menu">
				<?php if ( $menu_toggle_icon ) : ?>
					<img src="<?php echo esc_url( $menu_toggle_icon ); ?>" alt="<?php esc_attr_e( 'Menu', 'xpertcodes-coming-soon-maintenance' ); ?>">
				<?php endif; ?>
				<span><?php echo esc_html( $menu_toggle_label ); ?></span>
			</button>

			<nav id="mdxcsp-dropdown-menu" class="mdxcsp-dropdown" aria-hidden="true">
				<ul>
					<?php foreach ( $menu_items as $i => $item ) :
						$label = trim( (string) $item['label'] );
						if ( '' === $label ) {
							continue;
						}
						$cls = 'dynamic-link-color-' . ( $i + 1 );
						?>
						<li><a href="<?php echo esc_url( $item['url'] ); ?>" class="<?php echo esc_attr( $cls ); ?>"><?php echo esc_html( $label ); ?></a></li>
					<?php endforeach; ?>
				</ul>
			</nav>
		</div>
	<?php endif; ?>
</header>

<main class="mdxcsp-main">
	<section class="mdxcsp-hero">
		<?php if ( $title ) : ?>
			<h1 class="mdxcsp-title dynamic-title-color"><span class="accent"><?php echo esc_html( $title ); ?></span></h1>
		<?php endif; ?>

		<div class="mdxcsp-counter dynamic-countdown-color" data-target-date="<?php echo esc_attr( gmdate( 'c', time() + 30 * DAY_IN_SECONDS ) ); ?>">
			<div class="mdxcsp-time"><span class="num days">00</span><span class="lbl"><?php esc_html_e( 'Days', 'xpertcodes-coming-soon-maintenance' ); ?></span></div>
			<div class="mdxcsp-time"><span class="num hours">00</span><span class="lbl"><?php esc_html_e( 'Hours', 'xpertcodes-coming-soon-maintenance' ); ?></span></div>
			<div class="mdxcsp-time"><span class="num minutes">00</span><span class="lbl"><?php esc_html_e( 'Minutes', 'xpertcodes-coming-soon-maintenance' ); ?></span></div>
			<div class="mdxcsp-time"><span class="num seconds">00</span><span class="lbl"><?php esc_html_e( 'Seconds', 'xpertcodes-coming-soon-maintenance' ); ?></span></div>
		</div>

		<?php if ( $subtitle ) : ?>
			<p class="mdxcsp-subtitle dynamic-subtitle-color"><?php echo esc_html( $subtitle ); ?></p>
		<?php endif; ?>

		<noscript><p class="mdxcsp-noscript"><?php esc_html_e( 'JavaScript is required for the countdown timer.', 'xpertcodes-coming-soon-maintenance' ); ?></p></noscript>
	</section>
</main>

<footer class="mdxcsp-footer dynamic-copyright-color">
	<div class="mdxcsp-footer-left">
		<?php
		$copy_txt = isset( $opts['copyright_text'] ) ? (string) $opts['copyright_text'] : __( 'Your Company. All rights reserved.', 'xpertcodes-coming-soon-maintenance' );
		echo esc_html( sprintf( __( '© %1$s %2$s', 'xpertcodes-coming-soon-maintenance' ), date_i18n( 'Y' ), $copy_txt ) );
		?>
	</div>
	<div class="mdxcsp-footer-right">
		<a href="<?php echo esc_url( $social_1_url ); ?>" class="social"><img src="<?php echo esc_url( $social_1_img ); ?>" alt="<?php esc_attr_e( 'Social link 1', 'xpertcodes-coming-soon-maintenance' ); ?>"></a>
		<a href="<?php echo esc_url( $social_2_url ); ?>" class="social"><img src="<?php echo esc_url( $social_2_img ); ?>" alt="<?php esc_attr_e( 'Social link 2', 'xpertcodes-coming-soon-maintenance' ); ?>"></a>
	</div>
</footer>

<?php wp_footer(); ?>
</body>
</html>
