<?php
/**
 * News Sitemap settings page
 *
 * @package XML Sitemap & Google News
 */

?>
<style type="text/css">
<?php require XMLSF_DIR . '/assets/admin.css'; ?>
</style>
<div class="wrap">

	<h1><?php esc_html_e( 'Google News Sitemap', 'xml-sitemap-feed' ); ?></h1>

	<p>
		<?php printf( /* translators: Writing Settings URL */ esc_html__( 'These settings control the Google News Sitemap generated by the %s plugin.', 'xml-sitemap-feed' ), esc_html__( 'XML Sitemap & Google News', 'xml-sitemap-feed' ) ); ?>
	</p>

	<nav class="nav-tab-wrapper">
		<a class="nav-tab<?php echo 'general' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf_news&tab=general'; ?>"><?php echo esc_html( translate( 'General' ) ); // phpcs:ignore WordPress.WP.I18n.LowLevelTranslationFunction ?></a>
		<a class="nav-tab <?php echo 'advanced' === $active_tab ? 'nav-tab-active' : '" href="?page=xmlsf_news&tab=advanced'; ?>"><?php echo esc_html( translate( 'Advanced' ) ); // phpcs:ignore WordPress.WP.I18n.LowLevelTranslationFunction ?></a>
		<?php do_action( 'xmlsf_news_nav_tabs', $active_tab ); ?>
	</nav>

	<div class="main">
		<form id="xmlsf-settings-form" method="post" action="options.php">

			<?php do_action( 'xmlsf_news_settings_before', $active_tab ); ?>

			<?php settings_fields( 'xmlsf_news_' . $active_tab ); ?>

			<?php do_settings_sections( 'xmlsf_news_' . $active_tab ); ?>

			<?php do_action( 'xmlsf_news_settings_after', $active_tab ); ?>

			<?php submit_button(); ?>

		</form>
	</div>

	<div class="sidebar">
		<?php
		if ( ! XMLSF\Admin\Sitemap_News::compatible_with_advanced() ) {
			echo '<div style="background:rgb(252, 229, 231); margin-left: -14px; padding: 5px 10px; border: 4px solid rgb(214, 73, 54); border-radius: 3px; margin-bottom: 20px; font-weight: bold;">';
			include XMLSF_DIR . '/views/admin/section-advanced-news-compat-message.php';
			echo '</div>';
		}
		?>

		<h3><span class="dashicons dashicons-welcome-view-site"></span> <?php echo esc_html( translate( 'View' ) ); // phpcs:ignore WordPress.WP.I18n.LowLevelTranslationFunction ?></h3>
		<p>
			<?php
			printf(
				/* translators: Sitemap name with URL */
				esc_html__( 'Open your %s', 'xml-sitemap-feed' ),
				'<strong><a href="' . esc_url( xmlsf()->sitemap_news->get_sitemap_url() ) . '" target="_blank">' . esc_html__( 'Google News Sitemap', 'xml-sitemap-feed' ) . '</a></strong><span class="dashicons dashicons-external"></span>'
			);
			?>
		</p>

		<?php do_action( 'xmlsf_admin_sidebar', 'news' ); ?>

	</div>

</div>
<script>
<?php require XMLSF_DIR . '/assets/admin.js'; ?>
</script>
