<?php
/**
 * Robots.txt field
 *
 * @package XML Sitemap & Google News
 */

?>
<fieldset>
	<legend class="screen-reader-text"><?php esc_html_e( 'Additional robots.txt rules', 'xml-sitemap-feed' ); ?></legend>

<?php if ( ! xmlsf()->using_permalinks() ) { ?>
	<p class="description">
		<?php printf( /* Translators: Permalinks */ esc_html__( 'Not available because of this site\'s %s settings.', 'xml-sitemap-feed' ), '<a href="' . esc_url( admin_url( 'options-permalink.php' ) ) . '">' . esc_html( translate( 'Permalinks' ) ) . '</a>' ); ?>
		<?php esc_html_e( 'Either switch to another Permalink structure or create a static robots.txt file in the site root and place your rules there.', 'xml-sitemap-feed' ); ?>
	</p>
	<?php } elseif ( ! isset( $rules['robots\.txt$'] ) ) { ?>
	<p class="description">
		<?php esc_html_e( 'No rewrite rule for robots.txt was found. Please verify your Permalink settings.', 'xml-sitemap-feed' ); ?>
	</p>
	<?php } elseif ( $static ) { ?>
	<p class="description">
		<?php esc_html_e( 'A static robots.txt file has been found. To manage your robots.txt from here, please copy its content and delete the file.', 'xml-sitemap-feed' ); ?>
	</p>
	<?php } else { ?>
	<label for="xmlsf_robots">
		<?php
		printf( /* translators: robots.txt, linked. */
			esc_html__( 'Rules that will be appended to the %s generated by WordPress:', 'xml-sitemap-feed' ),
			'<a href="' . esc_attr( trailingslashit( get_bloginfo( 'url' ) ) ) . 'robots.txt" target="_blank">robots.txt</a>'
		);
		?>
	</label>
	<br/>
	<textarea name="xmlsf_robots" id="xmlsf_robots" class="large-text" cols="50" rows="6"><?php echo esc_textarea( trim( get_option( 'xmlsf_robots', '' ) ) ); ?></textarea>
<?php } ?>

</fieldset>
