<?php
/**
 * Plugin Name: xfive Plato - Reliable Sync Watcher for ACF
 * Description: Monitors ACF’s acf-json for unsynced field groups and warns you of potential database conflicts during development.
 * Requires at least: 6.1
 * Requires PHP: 7.4
 * Version: 1.0.1
 * Author: Xfive
 * Author URI: https://xfive.co
 * License: GPL v2 or later
 * Copyright: Xfive
 * Text Domain: xfive-sync-watcher-for-acf
 * Domain Path: /languages
 *
 * @package Xfive\ACF_Sync
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'ACF_Admin_Internal_Post_Type_List' ) ) {
	add_action(
		'admin_notices',
		function () {
			printf(
				'<div class="notice notice-error is-dismissible"><p><strong>%s</strong></p></div>',
				esc_html__( 'ACF plugin (at least 6.1) needs to be active for ACF Sync to work.', 'xfive-sync-watcher-for-acf' )
			);
		}
	);
	return;
}

/**
 * Plugin version.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_ACF_SYNC_VERSION' ) ) {
	define( 'XFIVE_ACF_SYNC_VERSION', '1.0.1' );
}

/**
 * Plugin slug.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_ACF_SYNC_SLUG' ) ) {
	define( 'XFIVE_ACF_SYNC_SLUG', 'xfive-sync-watcher-for-acf' );
}

/**
 * Plugin file.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_ACF_SYNC_FILE' ) ) {
	define( 'XFIVE_ACF_SYNC_FILE', __FILE__ );
}

/**
 * Plugin directory.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_ACF_SYNC_DIR' ) ) {
	define( 'XFIVE_ACF_SYNC_DIR', plugin_dir_path( __FILE__ ) );
}

/**
 * Plugin url.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_ACF_SYNC_URL' ) ) {
	define( 'XFIVE_ACF_SYNC_URL', plugin_dir_url( __FILE__ ) );
}

require_once __DIR__ . '/classes/Plugin.php';
