/* global xfiveAcfSyncData, acf */

class XfiveACFSync {
  constructor() {
    this.modal = document.querySelector('.js-xfive-acf-sync-modal');

    this.data = xfiveAcfSyncData;

    this.clssnames = {
      open: 'is-open',
    };

    this.modalCloseButton = document.querySelector('.js-xfive-acf-sync-modal-close');

    this.modalCloseHandler();
    this.reviewChangesHandler();
  }

  modalCloseHandler() {
    if (!this.modal) {
      return;
    }

    this.modalCloseButton.addEventListener('click', () => {
      this.modal.classList.remove(this.clssnames.open);
    });
  }

  reviewChangesHandler() {
    if (typeof acf === 'undefined') {
      return;
    }

    const { review } = this.data.get;

    if (!review) {
      return;
    }

    acf.addAction('ready', () => {
      const reviewLink = document.querySelector(
        `.acf-json a[data-event="review-sync"][data-id="${review}"]`,
      );

      if (reviewLink) {
        reviewLink.click();
      }
    });
  }
}

// eslint-disable-next-line no-new
new XfiveACFSync();
