<?php
/**
 * Plugin Name: xfive Aristotle - Monitor Site Errors with Sentry
 * Description: Integrates WordPress with Sentry to track PHP and JavaScript errors in real time, complete with detailed context for faster debugging.
 * Version: 1.2.1
 * Author: Xfive
 * Author URI: https://xfive.co
 * Copyright: Xfive
 * Text Domain: xfive-sentry-integration
 * Domain Path: /languages
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package Xfive\Sentry
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'XFIVE_SENTRY_NAMESPACE', 'XfiveSentry\\' );

/**
 * Plugin version.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_SENTRY_VERSION' ) ) {
	define( 'XFIVE_SENTRY_VERSION', '1.2.1' );
}

/**
 * Plugin slug.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_SENTRY_SLUG' ) ) {
	define( 'XFIVE_SENTRY_SLUG', 'xfive-sentry-integration' );
}

/**
 * Plugin file.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_SENTRY_FILE' ) ) {
	define( 'XFIVE_SENTRY_FILE', __FILE__ );
}

/**
 * Plugin directory.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_SENTRY_DIR' ) ) {
	define( 'XFIVE_SENTRY_DIR', plugin_dir_path( __FILE__ ) );
}

/**
 * Plugin url.
 *
 * @var string
 */
if ( ! defined( 'XFIVE_SENTRY_URL' ) ) {
	define( 'XFIVE_SENTRY_URL', plugin_dir_url( __FILE__ ) );
}

spl_autoload_register(
	function ( $class_name ) {
		$base_directory = XFIVE_SENTRY_DIR . 'inc/';

		$namespace_prefix_length = strlen( XFIVE_SENTRY_NAMESPACE );

		if ( strncmp( XFIVE_SENTRY_NAMESPACE, $class_name, $namespace_prefix_length ) !== 0 ) {
			return;
		}

		$relative_class_name = substr( $class_name, $namespace_prefix_length );

		$class_filename = $base_directory . str_replace( '\\', '/', $relative_class_name ) . '.php';

		if ( file_exists( $class_filename ) ) {
			require $class_filename;
		}
	}
);

\XfiveSentry\WP\Plugin::get_instance();
