/* global xfiveSentryIntegrationData */

import * as SentryBrowser from '@sentry/browser';

class Sentry {

  constructor() {
    this.data = xfiveSentryIntegrationData;

    if (this.data.isLocalhost) {
      return;
    }

    console.log(this.data)

    this.init();
  }

  init() {
    SentryBrowser.onLoad(() => {
      if (this.data.config?.tracesSampleRate) {
        this.data.config = {
          integrations: [SentryBrowser.browserTracingIntegration()],
          ...this.data.config,
        };
      }

      let shouldStop = false;

      const args = {
        ...this.data.config,
        beforeSend: (event) => {
          console.error('here3', event);

          if (this.data.ignorePlugins === 'yes') {
            if (event?.exception?.values?.length) {
              event.exception.values.forEach((value) => {
                const stacktraceFrames = value?.stacktrace?.frames;

                if (stacktraceFrames?.length) {
                  stacktraceFrames.some((frame) => {
                    const filename = frame?.filename;

                    if (filename && filename.includes('/wp-content/plugins/')) {
                      shouldStop = true;
                      return true;
                    }
                  });
                }
              });
            }
          }

          if ( shouldStop ) {
            return null;
          }

          return event;
        },
      };

      if (this.data?.denyUrls?.length) {
        args.denyUrls = this.data.denyUrls;
      }

      if (this.data?.allowUrls?.length) {
        args.allowUrls = this.data.allowUrls;
      }

      if (this.data?.ignoreErrors?.length) {
        args.ignoreErrors = this.data.ignoreErrors;
      }

      SentryBrowser.init( args );
    });
  }
}

new Sentry();
