<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$field_id = $args['label_for'];
$value    = sanitize_text_field( $args['value'] );

$field_data = $args['data'];

$classnames  = isset( $field_data['field_class'] ) ? $field_data['field_class'] : '';
$classnames .= ' regular-text';

$description = isset( $field_data['description'] ) ? $field_data['description'] : '';
$placeholder = isset( $field_data['placeholder'] ) ? $field_data['placeholder'] : '';
?>
<div>
	<input
		id="<?php echo esc_attr( $field_id ); ?>"
		type="text"
		name="<?php echo esc_attr( $field_id ); ?>"
		class="<?php echo esc_attr( $classnames ); ?>"
		value="<?php echo esc_attr( $value ); ?>"
		placeholder="<?php echo esc_attr( $placeholder ); ?>"
	>

	<?php if ( $description ) : ?>
		<p class="description"><?php echo wp_kses_post( $description ); ?></p>
	<?php endif; ?>
</div>
