<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$field_id = $args['label_for'];
$value    = sanitize_text_field( $args['value'] );

$field_data = $args['data'];

$classnames  = isset( $field_data['field_class'] ) ? $field_data['field_class'] : '';
$classnames .= ' regular-text';

$options     = $field_data['options'];
$description = isset( $field_data['description'] ) ? $field_data['description'] : '';
$placeholder = isset( $field_data['placeholder'] ) ? $field_data['placeholder'] : '';
?>
<div>
	<select
		id="<?php echo esc_attr( $field_id ); ?>"
		type="text"
		name="<?php echo esc_attr( $field_id ); ?>"
		class="<?php echo esc_attr( $classnames ); ?>"
	>
		<?php if ( $options ) : ?>
			<?php foreach ( $options as $key => $val ) : ?>
					<?php
					$selected = $key === $value;
					?>
					<option <?php echo $selected ? 'selected' : ''; ?> value="<?php echo esc_attr( $key ); ?>"><?php echo esc_attr( $val ); ?></option>
			<?php endforeach; ?>
		<?php endif; ?>
	</select>

	<?php if ( $description ) : ?>
		<p class="description"><?php echo wp_kses_post( $description ); ?></p>
	<?php endif; ?>
</div>
