<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$field_id = $args['label_for'];
$value    = sanitize_text_field( $args['value'] );

$field_data = $args['data'];

$classnames  = isset( $field_data['field_class'] ) ? $field_data['field_class'] : '';
$classnames .= ' regular-text';

$description = isset( $field_data['description'] ) ? $field_data['description'] : '';
$placeholder = isset( $field_data['placeholder'] ) ? $field_data['placeholder'] : '';

$min  = isset( $field_data['min'] ) ? $field_data['min'] : '';
$max  = isset( $field_data['max'] ) ? $field_data['max'] : '';
$step = isset( $field_data['step'] ) ? $field_data['step'] : 1;
?>
<div>
	<input
		id="<?php echo esc_attr( $field_id ); ?>"
		type="number"
		name="<?php echo esc_attr( $field_id ); ?>"
		class="<?php echo esc_attr( $classnames ); ?>"
		value="<?php echo esc_attr( $value ); ?>"
		placeholder="<?php echo esc_attr( $placeholder ); ?>"
		min="<?php echo esc_attr( $min ); ?>"
		max="<?php echo esc_attr( $max ); ?>"
		step="<?php echo esc_attr( $step ); ?>"
	>

	<?php if ( $description ) : ?>
		<p class="description"><?php echo wp_kses_post( $description ); ?></p>
	<?php endif; ?>
</div>
