<?php

namespace XfiveSentry\Trait;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait Singleton {
	/**
	 * Instance of the class.
	 *
	 * @var self
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 */
	public static function get_instance() {
		if ( ! ( self::$instance instanceof self ) ) {
				self::$instance = new self();
		}

		return self::$instance;
	}
}
