<?php
namespace XFactorApp\Krunity\Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Krunity\Krunity;

if ( ! defined( 'ABSPATH' ) ) exit;

class Krunity_Blocks extends AbstractPaymentMethodType {
    protected $name = 'krunity'; // EXACT id-ul gateway-ului tău

    public function initialize() {
        $this->settings = get_option( 'woocommerce_krunity_settings', [] );
    }

    public function is_active() {
        return ( $this->settings['enabled'] ?? 'no' ) === 'yes';
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            'krunity-blocks',
            plugins_url( '../../assets/js/blocks/krunity-v3.js', __FILE__ ),
            [ 'wc-blocks-registry', 'wc-settings', 'wp-element' ],
            filemtime( plugin_dir_path(dirname(__DIR__ ) ) . 'assets/js/blocks/krunity-v3.js' ),
            true
        );
        return [ 'krunity-blocks' ];
    }

    public function get_payment_method_data() {
        return [
            'label'       => $this->settings['title'] ?? 'Credit Online Smart by BT Direct',
            'title'       => $this->settings['title'] ?? 'Credit Online Smart by BT Direct',
//            'description' => Krunity::PLUGIN_DESCRIPTION,
            'icon'        => plugins_url( '../assets/img/logo.png', dirname( __DIR__ ) . '/xfactorapp-krunity-credit-smart-bt-direct.php' ),
            'enabled'     => $this->settings['enabled'] ?? 'no',
            'min_total'   => (float)($this->settings['min_amount'] ?? 0),
            'max_total'   => (float)($this->settings['max_total'] ?? 0),
            'currency'    => get_woocommerce_currency(),
        ];
    }
}
