class btDirectWidget extends HTMLElement {
    constructor() {
        super();
        // Attach a shadow root to the element.
        this.attachShadow({ mode: 'open' });

        this.getDialog = () => {
            return this.dataset.dialog == 'true';
        };

        this.getPrice = () => {
            return this.dataset.price ? Number(this.dataset.price) : 0;
        };

        this.getPeriodMin = () => {
            return this.dataset.periodMin ? Number(this.dataset.periodMin) : false;
        };

        this.getPeriodMax = () => {
            return this.dataset.periodMax ? Number(this.dataset.periodMax) : false;
        };

        this.getPeriod = () => {
            return this.shadowRoot.querySelector('[type=range]') ?
                Number(this.shadowRoot.querySelector('[type=range]').value) :
                Number(this.dataset.period);

        };

        this.getInterest = () => {
            return this.dataset.interest
                ? Number(this.dataset.interest) / 100
                : 34.92 / 100; // fallback default
        };

        this.getPeriodDefault = () => {
            return this.dataset.period ? Number(this.dataset.period) : this.getPeriodMin();
        };

        this.getActionText = () => {
            return this.dataset.actionText || 'Adaugă în coș';
        };

        this.calculate = () => {
            /*
            formula de calcul preluata din widget-ul anterior
            */

            let dobanda = this.getInterest() / 100;
            let comision = 30; // Comisionul de emitere card
            let sf = 6.5; // Comisionul lunar de administrare
            let suma = this.getPrice();
            let perioada = this.getPeriod();

            let dobanda_new = dobanda / 12;
            let t_a = suma * dobanda_new * perioada;
            let t_b = 1 - 1 / (Math.pow((1 + dobanda_new), perioada));
            let t_c = 1 / perioada;
            let t_d = sf;
            let rata = t_a / t_b * t_c + t_d;

            /*
            DOM updates
            */
            this.shadowRoot.querySelectorAll('[type="range"]').forEach(element => {
                element.style.setProperty('--progress', `calc(${
                    ((Number(element.value) / this.getPeriodMax()) * 100).toFixed(2)
                }% - 16px)`);
            });

            this.shadowRoot.querySelectorAll('[for="btDirectWidgetMonthlyRate"]').forEach(element => {
                element.innerText = rata.toFixed(2);
            });

            this.shadowRoot.querySelectorAll('[for="btDirectWidgetTotal"]').forEach(element => {
                element.innerText = ((rata * perioada) + comision).toFixed(2);
            });
        }
    }

    // Lifecycle callbacks
    connectedCallback() {
        // MARK: logo
        const logoSVG = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 140 48" enable-background="new 0 0 140 48" xml:space="preserve"><title>Sigla Smart by BT Direct</title><path fill="#FFF0BD" d="M22,47.6c-2.2-0.9-4.3-2.1-6.4-3.5c-2.1-1.5-4-3.2-5.8-5.2C6.1,35,3.2,30.3,1.4,25.4 c2.3-7.9,2.4-14.2,0.2-21.1c3-1.2,6.2-2.2,9.6-2.8c3.5-0.7,7.2-1,10.8-1s7.3,0.3,10.8,1c3.3,0.7,6.5,1.6,9.6,2.9 c-2.1,6.9-2,13.2,0.2,21.1c-1.8,4.9-4.7,9.6-8.4,13.5c-1.8,2-3.8,3.7-5.8,5.2C26.3,45.5,24.2,46.7,22,47.6z"/><path fill="#ED1C24" d="M28.4,44.5C34.8,40,40.1,33.1,43,25.4c-1.9-6.5-2.3-11.9-1.2-17.6l-0.2-0.7l-4.4-1.5L36.7,6 c-1,5.6-0.7,11.1,0.9,17.5C33.5,33.2,26.3,39,21.1,41.3l0,0.8l6,2.7L28.4,44.5z"/><path fill="#0072BC" d="M22,0C15.2,0,8.8,1.2,3.1,3.3L2.9,3.7c1.3,3.8,1.8,6.6,2,9.5c0.2,3.4-0.1,6.9-1.2,11.1v0.1l0,0.1 c0.5,1.2,1.2,2.3,1.8,3.4C6.2,29,6.9,30,7.7,31c0.8,1,1.6,2,2.6,2.9c0.9,0.9,1.9,1.8,2.9,2.7c1,0.8,2.1,1.6,3.3,2.4 c1.2,0.8,2.3,1.5,3.6,2.2c0.2,0.1,0.4,0.2,0.7,0.3h0.3v-0.2c0.3-0.1,0.5-0.2,0.8-0.4c-5.1-2.5-11.8-8.2-15.7-17.4 c1.7-6.4,2-11.9,0.9-17.5c4.6-1.4,9.6-2.1,14.8-2.1c7.2,0,13.9,1.4,19.8,4c0.2-1.3,0.6-2.5,1-3.8C36.5,1.5,29.5,0,22,0z"/><path fill="#FFC20E" d="M28.4,44.5C16.8,40.2,8.3,33.6,4,24.4c2.2-8.7,1.3-14.1-0.9-21.1C2.4,3.6,1.8,3.8,1.2,4 C3.4,11.1,3.3,17.5,1,25.4C4.8,35.6,12.8,44.4,22,48C24.2,47.1,26.4,45.9,28.4,44.5z"/><path d="M51.5,24.5c1,0,1.3-0.3,1.3-1.4v-8.8c0-1.1-0.3-1.4-1.3-1.4V12h6.2c2.7,0,4.5,1.1,4.5,3.5c0,1.8-1.1,2.7-2.8,3v0.1 c2.3,0.2,3.3,1.5,3.3,3.3c0,2.3-1.5,3.5-4.5,3.5h-6.7L51.5,24.5L51.5,24.5z M57,17.9c1.5,0,2-0.5,2-2.2c0-1.7-0.6-2.3-2.1-2.3h-1.1 v4.5H57z M57.3,24.1c1.6,0,2.2-0.5,2.2-2.4c0-1.7-0.6-2.4-2.2-2.4h-1.5v4.8H57.3z M74.1,12l0.2,3.6h-1.4c-0.4-1.6-0.5-2.2-1.7-2.2 h-0.8v9.7c0,1.1,0.3,1.4,1.5,1.4v0.9h-6v-0.9c1.2,0,1.5-0.2,1.5-1.4v-9.7h-0.8c-1.3,0-1.4,0.6-1.7,2.2h-1.5l0.2-3.6H74.1z M79.5,24.5c1,0,1.3-0.3,1.3-1.4v-8.8c0-1.1-0.3-1.4-1.3-1.4V12h5.5c3.9,0,6.3,1.9,6.3,6.7c0,4.3-2.1,6.6-6.4,6.6h-5.5V24.5z M84.8,24.1c2.4,0,3.4-0.9,3.4-5.2c0-4.4-1-5.5-3.3-5.5h-1v10.7H84.8z M92.7,25.4v-0.9c1,0,1.2-0.2,1.2-1.3v-4.6 c0-1.4-0.2-1.6-1.2-1.6v-0.8l3.6-0.7h0.4v7.7c0,1.1,0.2,1.3,1.2,1.3v0.9H92.7z M95.2,14.6c-0.9,0-1.7-0.7-1.7-1.7 c0-0.9,0.8-1.7,1.7-1.7s1.7,0.7,1.7,1.7C96.9,13.8,96.2,14.6,95.2,14.6z M105.5,15.3c0.3,0,0.6,0.1,0.7,0.1l-0.5,2.9 c-0.3-0.1-0.6-0.1-1-0.1c-1.5,0-1.8,0.5-1.8,2v3c0,1.1,0.2,1.3,1.5,1.3v0.9h-5.5v-0.9c1,0,1.2-0.2,1.2-1.3v-4.6 c0-1.4-0.2-1.6-1.2-1.6v-0.8l3.1-0.8h0.3c0.1,0.2,0.6,1.2,0.6,2.4C103.2,16.2,104.5,15.3,105.5,15.3z M115,23.3l0.5,0.8 c-1,1-2.3,1.5-4,1.5c-3,0-4.7-1.9-4.7-5.1s1.9-5.1,4.7-5.1c3,0,4.3,1.8,4.3,4.7v0.8h-5.9c0.1,2.2,0.8,3,2.7,3 C113.3,24,114.2,23.7,115,23.3z M109.9,19.6h3c0-2.3-0.4-3-1.4-3C110.4,16.5,110,17.3,109.9,19.6z M125,18.2h-2.1 c-0.1-1.2-0.2-1.7-1-1.7c-0.9,0-2,0.7-2,3.6c0,2.9,1.2,3.8,2.6,3.8c0.9,0,1.5-0.2,2.3-0.7l0.5,0.7c-0.9,1-2.2,1.6-3.6,1.6 c-2.6,0-4.7-1.6-4.7-5c0-3.5,2.3-5.3,4.9-5.3c1.5,0,2.5,0.3,3.1,0.8V18.2z M132,17.1h-2v5.2c0,1.4,0.1,2,1.1,2 c0.3,0,0.7-0.1,1.1-0.2l0.3,1c-0.7,0.5-1.6,0.7-2.6,0.7c-1.7,0-2.7-0.7-2.7-2.8v-5.8H126v-1l1.3-0.5c0.1-0.9,0.4-1.8,0.9-2.5l2-0.2 c-0.1,0.7-0.2,1.8-0.2,2.8h2.3L132,17.1z M133,13.7c0-1.8,1.3-3,3-3s3,1.2,3,3c0,1.8-1.3,3-3,3C134.3,16.7,133,15.5,133,13.7z M138.6,13.7c0-1.7-1.2-2.7-2.6-2.7s-2.6,1-2.6,2.7c0,1.6,1.2,2.7,2.6,2.7S138.6,15.3,138.6,13.7z M136,15.4h-1.5v-0.2 c0.4,0,0.5-0.1,0.5-0.5v-2.1c0-0.4,0-0.5-0.5-0.5v-0.2h1.4c0.8,0,1.3,0.2,1.3,0.9c0,0.7-0.4,0.9-1,0.9v0c0.2,0.1,0.5,0.3,0.7,0.6 c0.1,0.1,0.1,0.3,0.3,0.5c0.1,0.3,0.2,0.3,0.5,0.3v0.2h-0.9c-0.1-0.3-0.3-0.7-0.5-0.9c-0.3-0.6-0.4-0.7-0.8-0.7v0.9 c0,0.4,0.1,0.5,0.5,0.5L136,15.4L136,15.4z M135.7,12.2h-0.3v1.4h0.4c0.6,0,0.8-0.2,0.8-0.7C136.6,12.3,136.4,12.2,135.7,12.2z M18.4,18.7L18.4,18.7c1.7-0.3,3-1.1,3-3.1c0-2.5-2-3.6-4.4-3.6h-6.7v1.4c0.9,0,1.2,0.2,1.2,1.3v9.8c0,0.4,0.3,0.8,0.8,0.8h5.1 c3.3,0,4.5-1.3,4.5-3.4C21.8,20,20.7,18.9,18.4,18.7z M14.9,13.5h0.8c1.4,0,1.9,0.6,1.9,2.2c0,1.8-0.5,2.2-1.8,2.2h-0.8V13.5z M16.1,23.9h-1.1v-4.5h1.3c1.3,0,1.9,0.7,1.9,2.3C18.1,23.5,17.4,23.9,16.1,23.9z M33.8,12.7l0.2,3.1h-1.7c-0.4-1.6-0.5-2.2-1.8-2.2 h-0.6v11.8h-3.5V13.5h-0.6c-1.3,0-1.4,0.6-1.8,2.2h-1.7l0.2-3.1c0-0.4,0.3-0.7,0.8-0.7H33C33.4,12,33.8,12.3,33.8,12.7z"/></svg>';
        // styling
        const style = document.createElement('style');
        style.textContent = `
        :host,
        :host * {
            min-width: 0;
            box-sizing: border-box;
        }

        :host {
            --widget-max-width: 327px;
            --widget-max-padding: 24px;
            width: 100%;
            max-width: 502px;
        }

        ::slotted(h4) {
            color: #000;
            font-size: 24px;
            font-style: normal;
            font-weight: 700;
            line-height: 1.16;
            letter-spacing: -0.48px;
        }

        ::slotted(h4):not(:last-child) {
            margin-bottom: 8px;
        }

        ::slotted(a) {
            color: #0090FF;
            text-decoration: none;
        }

        dialog {
            --widget-max-width: 600px;
            background-color: transparent;
            width: 100%;
            max-width: 100%;
            min-width: 100%;
            height: 100%;
            max-height: 100%;
            min-height: 100%;
            padding: 12px;
            border: 0;
            overflow: auto;
            overscroll-behavior: contain;
            scrollbar-width: none;

            &::-webkit-scrollbar {
                display: none;
            }

            &:popover-open,
            &[open] {
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .backdrop {
                position: fixed;
                inset: 0;
                margin: 0;
                padding: 0;
                border: 0;
                z-index: 1;
            }

            section {
                margin: auto;
            }
        }

        @media (max-width: 991px) {
            dialog {
                --widget-max-padding: 24px;

                &::backdrop,
                .backdrop {
                    background-color: #000;
                    opacity: 1;
                }
            }
        }

        @media (min-width: 992px) {
            dialog {
                --widget-max-padding: 48px;

                ::backdrop,
                .backdrop {
                    background-color: rgba(0, 0, 0, .6);
                }
            }
        }

        .toggle {
            position: relative;
            background-color: #EFEFF1;
            color: #000;
            width: 100%;
            max-width: 502px;
            line-height: 1.44;
            margin: 0;
            padding: 16px 24px;
            border-radius: 12px;
            border: 0;
            display: flex;
            align-items: center;
            gap: 24px;
            text-decoration: none;
            font-family: 'Inter', sans-serif;
            font-size: 14px;
            font-style: normal;
            font-weight: 500;
            letter-spacing: -0.09px;
            text-align: left;
            cursor: pointer;
            z-index: 1;

            svg {
                width: 98px;
                height: 34px;
                flex-shrink: 0;
            }

            img {
                width: 96px;
                height: 36px;
                flex-shrink: 0;
            }

            .text {
                flex: 1;
                text-align: left;

                mark {
                    background-color: #1A76FF;
                    color: #fff;
                    padding: 3px;
                    border-radius: 2px;
                    display: inline-block;
                }
            }

            .label {
                background-color: #1A76FF;
                color: #fff;
                padding: 8px 16px;
                border-radius: 8px;
                flex-shrink: 0;
                display: block;
                font-size: 12px;
                font-style: normal;
                font-weight: 500;
                letter-spacing: -0.09px;
            }
        }

        @media (max-width: 991px) {
            .toggle {
                justify-content: space-between;
                display: grid;
            }
        }

        section {
            position: relative;
            background-color: #fff;
            color: #737382;
            width: 100%;
            max-width: var(--widget-max-width);
            padding:var(--widget-max-padding);
            border-radius: 16px;
            display: flex;
            flex-flow: column;
            align-items: stretch;
            gap: 24px;
            box-sizing: border-box;
            text-decoration: none;
            font-family: 'Inter', sans-serif;
            font-style: normal;
            letter-spacing: -0.09px;
            z-index: 2;

            @media (max-width: 991px) {
                font-size: 12px;
            }

            @media (min-width: 992px) {
                font-size: 14px;
            }

            figure {
                margin: 0;
                padding: 0;
                display: flex;
                align-items: start;
                justify-content: space-between;

                svg {
                    width: 140px;
                    max-height: 48px;
                    display: block;
                }

                button {
                    position: relative;
                    background-color: transparent;
                    width: 24px;
                    height: 24px;
                    margin: 0;
                    padding: 0;
                    border: 0;
                    z-index: 1;

                    &::before,
                    &::after {
                        content: "";
                        position: absolute;
                        top: 50%;
                        left: 50%;
                        background-color: #0090FF;
                        width: calc(100% + 14px);
                        height: 2px;
                        display: block;
                    }

                    &::before {
                        transform: translate(-50%, -50%) rotate(45deg);
                    }

                    &::after {
                        transform: translate(-50%, -50%) rotate(-45deg);
                    }
                }

                .text {
                    margin: 0!important;
                }
            }

            @media (max-width: 991px) {
                figure button {
                    width: 18px;
                    height: 18px;
                }
            }

            @media (min-width: 992px) {
                figure button {
                    width: 24px;
                    height: 24px;
                }
            }

            .period {
                background: rgba(250, 250, 250, 0.98);
                width: 100%;
                min-width: auto;
                padding: 24px;
                border-radius: 8px;

                label {
                    display: block;
                }

                label:not(:last-child) {
                    margin-bottom: 8px;
                }

                .field {
                    display: flex;
                    align-items: center;
                    gap: 14px;

                    input[type="number"] {
                        background-color: #fff;
                        color: #000;
                        width: auto;
                        height: 48px;
                        line-height: 1.32;
                        padding: 0 24px;
                        flex: 1;
                        border: 1px solid #D4D4D8;
                        border-radius: 7px;
                        text-align: center;
                        font-size: 19px;
                        font-weight: 600;
                        letter-spacing: -0.3px;
                    }

                    input::-webkit-inner-spin-button,
                    input::-webkit-outer-spin-button {
                        -webkit-appearance: none;
                        appearance: none;
                    }

                    span {
                        flex-shrink: 0;
                    }
                }

                .field:not(:last-child) {
                    margin-bottom: 24px;
                }
            }

            .text:not(:last-child) {
                margin-bottom: 24px;
            }

            menu {
                width: 100%;
                margin: 0;
                padding: 0;
                display: grid;
                gap: 8px;
                list-style: none;

                li {
                    width: 100%;
                    min-width: 0;
                    display: flex;
                    align-items: center;
                    justify-content: space-between;
                    gap: 16px;

                    &:first-child {
                        padding-top: 16px;
                        border-top: 1px solid #EAEAEC;
                    }

                    &:not(:last-child) {
                        padding-bottom: 16px;
                        border-bottom: 1px solid #EAEAEC;
                    }

                    strong {
                        color: #000;
                        font-weight: 600;
                    }
                }
            }

            input[type=range] {
                --progress: 80%;
                -webkit-appearance: none;
                appearance: none;
                background-color: transparent;
                width: 100%;
                height: 12px;
                cursor: pointer;
            }

            input[type=range]::-webkit-slider-runnable-track {
                background: linear-gradient(0.25turn, #0090FF var(--progress), #D4D4D8 var(--progress));
                height: 6px;
                border-radius: 3px;
            }

            input[type=range]::-moz-range-track {
                background: linear-gradient(0.25turn, #0090FF var(--progress), #D4D4D8 var(--progress));
                height: 6px;
                border-radius: 3px;
            }

            input[type=range]::-webkit-slider-thumb {
                -webkit-appearance: none;
                appearance: none;
                background-color: #fff;
                width: 16px;
                height: 16px;
                border: 3px solid #0090FF;
                border-radius: 50%;
                transform: translateY(calc(-50% + 3px));
            }

            input[type=range]::-moz-range-thumb {
                background-color: #fff;
                width: 16px;
                height: 16px;
                border: 3px solid #131315;
                border-radius: 50%;
            }

            input[type=range]:not(:last-child) {
                margin-bottom: 4px;
            }

            .limits {
                color: #737382;
                width: 100%;
                line-height: 1.44;
                display: flex;
                justify-content: space-between;
                align-items: center;
                font-size: 14px;
                font-weight: 600;
                letter-spacing: 0.042px;
                white-space: nowrap;
            }

            output {
                min-width: 46px;
                display: inline-block;
                text-align: right;
            }

            .action {
                background-color: #0090FF;
                color: #fff;
                height: 52px;
                line-height: 20px;
                padding: 16px 32px;
                border: 0;
                border-radius: 8px;
                display: block;
                text-align: center;
                font-size: 14px;
                font-weight: 600;
                text-decoration: none;
                cursor: pointer;

                &:hover {
                    background-color: #f4f4f5;
                    color: #000;
                }
            }
        }
        `;
        this.shadowRoot.append(style);

        // MARK: widget
        const widget = document.createElement('section');

        const dialog = document.createElement('dialog');
        dialog.setAttribute('popover', '');
        dialog.setAttribute('id', 'btDirectWidget');

        if (this.getDialog()) {
            this.shadowRoot.append(dialog);
            dialog.append(widget);

            const backdrop = document.createElement('button');
            backdrop.setAttribute('type', 'button');
            backdrop.setAttribute('popovertarget', 'btDirectWidget');
            backdrop.setAttribute('popovertargetaction', 'hide');
            backdrop.setAttribute('tabindex', '-1');
            backdrop.classList.add('backdrop');
            dialog.append(backdrop);

            const toggle = document.createElement('button');
            toggle.setAttribute('type', 'button');
            toggle.setAttribute('popovertarget', 'btDirectWidget');
            toggle.setAttribute('popovertargetaction', 'show');
            toggle.classList.add('toggle');
            toggle.innerHTML = logoSVG;

            const span = document.createElement('span');
            span.innerHTML = 'Finanțare prin Credit Online <mark>smart</mark> by BT Direct.';
            span.classList.add('text');
            toggle.append(span);

            const label = document.createElement('span');
            label.innerHTML = 'Calculează rata';
            label.classList.add('label');
            toggle.append(label);

            this.shadowRoot.append(toggle);
        } else {
            this.shadowRoot.append(widget);
        }

        // logo
        const logo = document.createElement('figure');
        logo.innerHTML = logoSVG;

        if (this.getDialog()) {
            const button = document.createElement('button');
            button.setAttribute('type', 'button');
            button.setAttribute('popovertarget', 'btDirectWidget');
            button.setAttribute('popovertargetaction', 'hide');
            button.setAttribute('tabindex', '-1');
            logo.append(button);
        }

        widget.append(logo);


        // text
        const text = document.createElement('div');
        text.classList.add('text');
        text.style.setProperty('margin', 0);
        widget.append(text);
        const textSlot = document.createElement('slot');
        text.append(textSlot);

        if (this.getPeriodMin() && this.getPeriodMax()) {
            // period
            const period = document.createElement('div');
            period.classList.add('period');
            widget.append(period);

            // period label
            const periodLabel = document.createElement('label');
            periodLabel.innerText = 'Perioada';
            period.append(periodLabel);

            //period field
            const periodField = document.createElement('field');
            periodField.classList.add('field');
            period.append(periodField);

            //period input
            const periodInput = document.createElement('input');
            periodInput.setAttribute('type', 'number');
            periodInput.inputMode = 'numeric';
            periodInput.value = this.getPeriodDefault();
            periodField.append(periodInput);

            const periodUnit = document.createElement('span');
            periodUnit.textContent = 'luni';
            periodField.append(periodUnit);

            // period range
            const periodRange = document.createElement('input');
            periodRange.setAttribute('type', 'range');
            periodRange.value = this.getPeriodDefault();
            periodRange.setAttribute('min', this.getPeriodMin());
            periodRange.setAttribute('max', this.getPeriodMax());
            periodRange.setAttribute('step', 1);
            period.append(periodRange);

            // limits
            const periodLimits = document.createElement('div');
            periodLimits.classList.add('limits');
            period.append(periodLimits);

            const min = document.createElement('span');
            min.textContent = `${this.getPeriodMin()} luni`;
            periodLimits.append(min);

            const max = document.createElement('span');
            max.textContent = `${this.getPeriodMax()} luni`;
            periodLimits.append(max);
        }

        // menu
        const menu = document.createElement('menu');
        widget.append(menu);

        // menu items
        // menu item period
        if (!(this.getPeriodMin() && this.getPeriodMax())) {
            const period = document.createElement('li');
            menu.append(period);
            const periodLabel = document.createElement('span');
            periodLabel.innerText = 'Perioada:';
            period.append(periodLabel);
            const periodValue = document.createElement('strong');
            periodValue.innerText = this.getPeriodDefault() + ' luni';
            period.append(periodValue);
        }

        // menu item price
        const price = document.createElement('li');
        menu.append(price);
        const priceLabel = document.createElement('span');
        priceLabel.innerText = 'Total:';
        price.append(priceLabel);
        const priceValue = document.createElement('strong');
        priceValue.innerText = this.getPrice() + ' lei';
        price.append(priceValue);

        // monthly rate
        const monthlyRate = document.createElement('li');
        menu.append(monthlyRate);

        const monthlyRateLabel = document.createElement('span');
        monthlyRateLabel.innerText = 'Rata:';
        monthlyRate.append(monthlyRateLabel);

        const monthlyRateValue = document.createElement('strong');
        monthlyRate.append(monthlyRateValue);
        const monthlyRateOutput = document.createElement('output');
        monthlyRateOutput.setAttribute('for', 'btDirectWidgetMonthlyRate');
        monthlyRateValue.append(monthlyRateOutput);

        monthlyRateValue.innerHTML += ' lei';

        // total
        const total = document.createElement('li');
        menu.append(total);

        const totalLabel = document.createElement('span');
        totalLabel.innerText = 'Total de plată:';
        total.append(totalLabel);

        const totalValue = document.createElement('strong');
        total.append(totalValue);
        const totalOutput = document.createElement('output');
        totalOutput.setAttribute('for', 'btDirectWidgetTotal');
        totalValue.append(totalOutput);

        totalValue.innerHTML += ' lei';

        // action event
        const actionEvent = new CustomEvent('action', {
            bubbles: true,
        });

        // action
        if (!this.dataset.actionButton || this.dataset.actionButton === 'true') {
            const action = document.createElement('button');
            action.classList.add('action');
            action.type = 'button';
            action.innerText = this.getActionText();
            widget.append(action);

            action.addEventListener('click', () => {
                this.dispatchEvent(actionEvent);
            });
        }

        // calculate on mount
        this.calculate();

        // events
        widget.addEventListener('input', event => {
            widget.querySelectorAll(`input`).forEach(input => {
                if (input != event.target) {
                    input.value = event.target.value;
                }
            });

            this.calculate();
        });
    }
}

customElements.define('bt-direct-widget', btDirectWidget);
