(function () {
    const registry   = window.wc && window.wc.wcBlocksRegistry;
    const settingsApi= window.wc && window.wc.wcSettings;
    const elLib      = window.wp && window.wp.element;
    if (!registry || !settingsApi || !elLib) return;

    const settings = settingsApi.getSetting('krunity_data', {}) || {};
    const el = elLib.createElement;

    const Label = () =>
        el('div', { className: 'wc-block-components-payment-method-label', style: { display: 'flex' } },
            settings.icon ? el('img', { src: settings.icon, alt: '', style: { height: 50, marginRight: 16 } }) : null,
            el('span', null, settings.title || 'Credit Online Smart by BT Direct')
        );

    // const Content = () => el('div', { style: {marginRight: 110} }, settings.description || '', settings.icon ? el('img', { src: settings.icon, alt: '', style: { height: 30, marginRight: 8,float: 'right',top: 15,position: 'absolute',right: 5 } }) : null,);
    const Content = () => el('div', { style: {} }, null);

    const canMakePayment = ({ cartTotals } = {}) => {
        let total = 0;
        if (cartTotals && typeof cartTotals.total_price === 'number') {
            total = cartTotals.total_price / 100;
        }
        if (settings.min_total && total && total < Number(settings.min_total)) return false;
        if (settings.max_total && total && total > Number(settings.max_total)) return false;
        return settings.enabled === 'yes';
    };

    registry.registerPaymentMethod({
        name: 'krunity',
        label: Label(),
        ariaLabel: settings.title || 'Credit Online Smart by BT Direct',
        content: Content(),
        edit: Content(),
        supports: { features: ['products'] },
        canMakePayment
    });
})();