=== Credit Online Smart by BT Direct ===

Contributors:      XFactorApp
Requires at least: 6.2
Requires PHP:      7.2
Tested up to:      6.8
Stable tag:        1.0.22
License:           GNU General Public License v3.0
License URI:       http://www.gnu.org/licenses/gpl-3.0.html
Tags:              banca transilvania, woocommerce, online loan, smart credit, bt direct

Add BT Direct (Credit SMART) financing to WooCommerce checkout, with automatic callbacks and order status updates.

== Description ==

This plugin integrates **Banca Transilvania – BT Direct (Credit SMART)** as a financing option at WooCommerce checkout. Shoppers select Credit SMART, complete the credit application with BT Direct, and—on decision—your order updates automatically.

**BT DIRECT IFN SA**, a non-banking financial institution from Romania and part of the Banca Transilvania financial group, offers flexible financing solutions for individuals and specializes in credit products that ensure fast access to loans designed to meet customers’ specific needs.

**BT DIRECT IFN SA** also focuses on innovation and digitalization, offering customers a fully online lending platform — **Credit online SMART by BT Direct**. This platform enables users to access financing quickly and easily, without the need to visit a bank. With a customer-centric approach, BT Direct IFN SA aims to become a leader in financing solutions.

##### Benefits of Smart by BT Direct: 100% digital, 100% smart
- Simple usage flow: intuitive process, online identification, electronic signature; 
- No analysis fee; 
- Approval in 10 minutes; 
- The product purchase process takes place entirely online.

**What you get**
- Credit SMART payment method at checkout (WooCommerce Payments section).
- Automatic **callback/return handling** and order status updates.
- Configurable **minimum order totals** for eligibility.
- Built-in **logging** for easier troubleshooting.

**Who it’s for**
- WooCommerce stores selling to Romania (RON).
- Merchants who want to offer installment financing via BT Direct.

> Note: You must have a BT Direct merchant account. The plugin does not create one for you.

== Features ==
- Credit SMART gateway visible alongside other WooCommerce payment methods.
- Redirect to BT Direct application flow, then back to your store.
- Updates order status to “processing/completed/failed/cancelled” based on BT callbacks.
- Enable debug logs, and set eligibility thresholds.

== Requirements ==
- WordPress **6.2+** (tested up to **6.8**)
- WooCommerce **7.9+** (tested up to **9.x**)
- PHP **7.2+**
- HTTPS enabled (SSL)
- Store currency **RON** (recommended)
- BT Direct merchant credentials

== Screenshots ==
1. Module listed on plugins page
2. Module activated and listed on Woocommerce Payments methods
3. Configuration form
4. Payment method listed on checkout page

== Installation ==

1. Make sure **WooCommerce** is installed and active.
2. Upload the plugin ZIP via **Plugins → Add New → Upload Plugin** or install it from your distribution source.
3. Activate **Credit Online Smart by BT Direct**.
4. Go to **WooCommerce → Settings → Payments**.
5. Locate **Credit Online Smart by BT Direct** and click **Manage**.

== Configuration ==

1. Check **Enable/Disable**
2. Enter your BT Direct credentials
3. BaseUrl will be transmitted by BT Direct, default is: https://api-onlinecredit.btdirect.ro/api
4. SubmitUrl will be transmitted by BT Direct, default is: https://onlinecredit.btdirect.ro/wf/shoppingcart?wfId=25
5. ReturnUrl must be completed if ReturnUrl Type is Static Url. Default is: http://DOMAIN/index.php?fc=module&module=krunity&controller=finish
6. Hostname will be transmitted by BT Direct
7. Set **Minimum Order Amount**
8. Choose shipping methods that can apply or leave it blank in "Enable for shipping methods" field
9. (Optional) Enable **Debug** for testing.
10. Click on "Test Connection" to check if you receive any response from BT Direct
11. Save changes.

== Usage / Order Flow ==

1. Customer chooses **Credit SMART (BT Direct)** at checkout and places the order.
2. They are redirected to BT Direct to complete the application.
3. BT Direct redirects back and/or pings your **callback URL** with the decision.
4. The plugin updates the WooCommerce order status accordingly.
5. You fulfill the order as usual after approval/processing.

== Webhooks / Callback ==

- Use the **Callback URL** displayed in the plugin settings.
- Make sure your hosting/firewall allows BT Direct to reach that endpoint.
- If order statuses don’t update, verify the callback is configured correctly on the BT Direct side and that logs show a successful hit.
- Also, you can use the "Test Connection" to verify if there is any response from BTD (BT Direct)

== Privacy ==
This plugin sends order/customer data necessary for financing to BT Direct (Banca Transilvania). Logs may include request/response metadata for debugging. Review your privacy policy and data processing agreements accordingly.

== Troubleshooting ==

- **Gateway not visible**: Ensure WooCommerce is active, currency is RON, and the gateway is enabled. Also, ensure the Checkout Page is not a static page -- in this case payment methods are not displayed dynamically.
- **Order not updating**: Confirm the **callback URL** is set in BT Direct and reachable. Check plugin logs under WooCommerce → Status → Logs or in order form.
- **Amount not eligible**: Adjust min order thresholds in settings.

== Frequently Asked Questions ==

= Do I need a BT Direct merchant account? =
Yes. This plugin only connects your store to BT Direct. It does not create or onboard a merchant account.

= Where do I find the callback/return URLs? =
In the plugin settings. Copy the **Callback URL** from there and give it to BT Direct. If you use a **Static ReturnUrl**, set it explicitly as instructed in the settings.

= Why isn’t the gateway visible at checkout? =
Confirm WooCommerce is active, the gateway is enabled, the amount meets **Minimum Order Amount**, and the Checkout page isn’t a hard-coded/static page (payment methods must load dynamically). Also check you didn’t restrict shipping methods in a way that hides the gateway.

= The order status never updates. What now? =
Make sure the **Callback URL** is set at BT Direct and publicly reachable. Check logs in WooCommerce → Status → Logs (or the order notes) for a hit from BT Direct. If nothing hits, it’s almost always a misconfigured callback or a blocked request.
ng happens at BT Direct. WooCommerce refunds don’t propagate back to BT Direct.

== Upgrade Notice ==

= 1.0.19 =
Option `Use third party JWT authentication` can be used to let dedicated plugins handle the request authentification. For example, if you plan to use `JWT Authentication for WP REST API` plugin, you will need to enable this option.

= 1.0.17 =
Krunity order logs are now displayed under order items table.

= 1.0.15 =
Recommended update: improves callback parsing/validation, hardens error handling, and clarifies “Test Connection” responses. Re-save gateway settings after updating.

= 1.0.14 =
Minor stability fixes and clearer error messages during failed handshakes with BT Direct.

== Changelog ==

= 1.0.22 =
* Fixing frontend widget for WC theme

= 1.0.21 =
* Frontend widget with rate calculator. New design for backend settings form, with separated tabs and subtabs.

= 1.0.20 =
* Security updates.

= 1.0.19 =
* Added third_party_auth option for handling requests with dedicated plugins. Solved warnings reported.

= 1.0.18 =
* Solved WooCommerce Firebase class conflict

= 1.0.17 =
* Implemented WooCommerce Blocks and changed Krunity Order logs in a new custom dedicated section

= 1.0.16 =
* Assets and plugin description changed

= 1.0.15 =
* Minor fixes and improvements.

= 1.0.14 =
* Minor fixes and improvements.
