<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MediaContentRatingFrance File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* MediaContentRatingFrance class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MediaContentRatingFrance extends Entity
{
    /**
     * Gets the movieRating
     * Movies rating selected for France. Possible values are: allAllowed, allBlocked, agesAbove10, agesAbove12, agesAbove16, agesAbove18.
     *
     * @return RatingFranceMoviesType|null The movieRating
     */
    public function getMovieRating()
    {
        if (array_key_exists("movieRating", $this->_propDict)) {
            if (is_a($this->_propDict["movieRating"], "XCloner\\Microsoft\\Graph\\Model\\RatingFranceMoviesType") || is_null($this->_propDict["movieRating"])) {
                return $this->_propDict["movieRating"];
            } else {
                $this->_propDict["movieRating"] = new RatingFranceMoviesType($this->_propDict["movieRating"]);
                return $this->_propDict["movieRating"];
            }
        }
        return null;
    }
    /**
     * Sets the movieRating
     * Movies rating selected for France. Possible values are: allAllowed, allBlocked, agesAbove10, agesAbove12, agesAbove16, agesAbove18.
     *
     * @param RatingFranceMoviesType $val The value to assign to the movieRating
     *
     * @return MediaContentRatingFrance The MediaContentRatingFrance
     */
    public function setMovieRating($val)
    {
        $this->_propDict["movieRating"] = $val;
        return $this;
    }
    /**
     * Gets the tvRating
     * TV rating selected for France. Possible values are: allAllowed, allBlocked, agesAbove10, agesAbove12, agesAbove16, agesAbove18.
     *
     * @return RatingFranceTelevisionType|null The tvRating
     */
    public function getTvRating()
    {
        if (array_key_exists("tvRating", $this->_propDict)) {
            if (is_a($this->_propDict["tvRating"], "XCloner\\Microsoft\\Graph\\Model\\RatingFranceTelevisionType") || is_null($this->_propDict["tvRating"])) {
                return $this->_propDict["tvRating"];
            } else {
                $this->_propDict["tvRating"] = new RatingFranceTelevisionType($this->_propDict["tvRating"]);
                return $this->_propDict["tvRating"];
            }
        }
        return null;
    }
    /**
     * Sets the tvRating
     * TV rating selected for France. Possible values are: allAllowed, allBlocked, agesAbove10, agesAbove12, agesAbove16, agesAbove18.
     *
     * @param RatingFranceTelevisionType $val The value to assign to the tvRating
     *
     * @return MediaContentRatingFrance The MediaContentRatingFrance
     */
    public function setTvRating($val)
    {
        $this->_propDict["tvRating"] = $val;
        return $this;
    }
}
