<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* LocalizedName File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\TermStore\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* LocalizedName class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class LocalizedName extends \XCloner\Beta\Microsoft\Graph\Model\Entity
{
    /**
     * Gets the languageTag
     * The language tag for the label.
     *
     * @return string|null The languageTag
     */
    public function getLanguageTag()
    {
        if (array_key_exists("languageTag", $this->_propDict)) {
            return $this->_propDict["languageTag"];
        } else {
            return null;
        }
    }
    /**
     * Sets the languageTag
     * The language tag for the label.
     *
     * @param string $val The value of the languageTag
     *
     * @return LocalizedName
     */
    public function setLanguageTag($val)
    {
        $this->_propDict["languageTag"] = $val;
        return $this;
    }
    /**
     * Gets the name
     * The name in the localized language.
     *
     * @return string|null The name
     */
    public function getName()
    {
        if (array_key_exists("name", $this->_propDict)) {
            return $this->_propDict["name"];
        } else {
            return null;
        }
    }
    /**
     * Sets the name
     * The name in the localized language.
     *
     * @param string $val The value of the name
     *
     * @return LocalizedName
     */
    public function setName($val)
    {
        $this->_propDict["name"] = $val;
        return $this;
    }
}
