<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* TeamInfo File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* TeamInfo class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class TeamInfo extends Entity
{
    /**
     * Gets the displayName
     * The name of the team.
     *
     * @return string|null The displayName
     */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the displayName
     * The name of the team.
     *
     * @param string $val The displayName
     *
     * @return TeamInfo
     */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    /**
     * Gets the tenantId
     * The ID of the Azure Active Directory tenant.
     *
     * @return string|null The tenantId
     */
    public function getTenantId()
    {
        if (array_key_exists("tenantId", $this->_propDict)) {
            return $this->_propDict["tenantId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the tenantId
     * The ID of the Azure Active Directory tenant.
     *
     * @param string $val The tenantId
     *
     * @return TeamInfo
     */
    public function setTenantId($val)
    {
        $this->_propDict["tenantId"] = $val;
        return $this;
    }
    /**
     * Gets the team
     *
     * @return Team|null The team
     */
    public function getTeam()
    {
        if (array_key_exists("team", $this->_propDict)) {
            if (is_a($this->_propDict["team"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\Team") || is_null($this->_propDict["team"])) {
                return $this->_propDict["team"];
            } else {
                $this->_propDict["team"] = new Team($this->_propDict["team"]);
                return $this->_propDict["team"];
            }
        }
        return null;
    }
    /**
     * Sets the team
     *
     * @param Team $val The team
     *
     * @return TeamInfo
     */
    public function setTeam($val)
    {
        $this->_propDict["team"] = $val;
        return $this;
    }
}
