<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* OnPremisesExtensionAttributes File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* OnPremisesExtensionAttributes class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class OnPremisesExtensionAttributes extends Entity
{
    /**
     * Gets the extensionAttribute1
     * First customizable extension attribute.
     *
     * @return string|null The extensionAttribute1
     */
    public function getExtensionAttribute1()
    {
        if (array_key_exists("extensionAttribute1", $this->_propDict)) {
            return $this->_propDict["extensionAttribute1"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute1
     * First customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute1
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute1($val)
    {
        $this->_propDict["extensionAttribute1"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute10
     * Tenth customizable extension attribute.
     *
     * @return string|null The extensionAttribute10
     */
    public function getExtensionAttribute10()
    {
        if (array_key_exists("extensionAttribute10", $this->_propDict)) {
            return $this->_propDict["extensionAttribute10"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute10
     * Tenth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute10
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute10($val)
    {
        $this->_propDict["extensionAttribute10"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute11
     * Eleventh customizable extension attribute.
     *
     * @return string|null The extensionAttribute11
     */
    public function getExtensionAttribute11()
    {
        if (array_key_exists("extensionAttribute11", $this->_propDict)) {
            return $this->_propDict["extensionAttribute11"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute11
     * Eleventh customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute11
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute11($val)
    {
        $this->_propDict["extensionAttribute11"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute12
     * Twelfth customizable extension attribute.
     *
     * @return string|null The extensionAttribute12
     */
    public function getExtensionAttribute12()
    {
        if (array_key_exists("extensionAttribute12", $this->_propDict)) {
            return $this->_propDict["extensionAttribute12"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute12
     * Twelfth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute12
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute12($val)
    {
        $this->_propDict["extensionAttribute12"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute13
     * Thirteenth customizable extension attribute.
     *
     * @return string|null The extensionAttribute13
     */
    public function getExtensionAttribute13()
    {
        if (array_key_exists("extensionAttribute13", $this->_propDict)) {
            return $this->_propDict["extensionAttribute13"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute13
     * Thirteenth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute13
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute13($val)
    {
        $this->_propDict["extensionAttribute13"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute14
     * Fourteenth customizable extension attribute.
     *
     * @return string|null The extensionAttribute14
     */
    public function getExtensionAttribute14()
    {
        if (array_key_exists("extensionAttribute14", $this->_propDict)) {
            return $this->_propDict["extensionAttribute14"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute14
     * Fourteenth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute14
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute14($val)
    {
        $this->_propDict["extensionAttribute14"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute15
     * Fifteenth customizable extension attribute.
     *
     * @return string|null The extensionAttribute15
     */
    public function getExtensionAttribute15()
    {
        if (array_key_exists("extensionAttribute15", $this->_propDict)) {
            return $this->_propDict["extensionAttribute15"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute15
     * Fifteenth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute15
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute15($val)
    {
        $this->_propDict["extensionAttribute15"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute2
     * Second customizable extension attribute.
     *
     * @return string|null The extensionAttribute2
     */
    public function getExtensionAttribute2()
    {
        if (array_key_exists("extensionAttribute2", $this->_propDict)) {
            return $this->_propDict["extensionAttribute2"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute2
     * Second customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute2
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute2($val)
    {
        $this->_propDict["extensionAttribute2"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute3
     * Third customizable extension attribute.
     *
     * @return string|null The extensionAttribute3
     */
    public function getExtensionAttribute3()
    {
        if (array_key_exists("extensionAttribute3", $this->_propDict)) {
            return $this->_propDict["extensionAttribute3"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute3
     * Third customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute3
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute3($val)
    {
        $this->_propDict["extensionAttribute3"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute4
     * Fourth customizable extension attribute.
     *
     * @return string|null The extensionAttribute4
     */
    public function getExtensionAttribute4()
    {
        if (array_key_exists("extensionAttribute4", $this->_propDict)) {
            return $this->_propDict["extensionAttribute4"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute4
     * Fourth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute4
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute4($val)
    {
        $this->_propDict["extensionAttribute4"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute5
     * Fifth customizable extension attribute.
     *
     * @return string|null The extensionAttribute5
     */
    public function getExtensionAttribute5()
    {
        if (array_key_exists("extensionAttribute5", $this->_propDict)) {
            return $this->_propDict["extensionAttribute5"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute5
     * Fifth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute5
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute5($val)
    {
        $this->_propDict["extensionAttribute5"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute6
     * Sixth customizable extension attribute.
     *
     * @return string|null The extensionAttribute6
     */
    public function getExtensionAttribute6()
    {
        if (array_key_exists("extensionAttribute6", $this->_propDict)) {
            return $this->_propDict["extensionAttribute6"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute6
     * Sixth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute6
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute6($val)
    {
        $this->_propDict["extensionAttribute6"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute7
     * Seventh customizable extension attribute.
     *
     * @return string|null The extensionAttribute7
     */
    public function getExtensionAttribute7()
    {
        if (array_key_exists("extensionAttribute7", $this->_propDict)) {
            return $this->_propDict["extensionAttribute7"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute7
     * Seventh customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute7
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute7($val)
    {
        $this->_propDict["extensionAttribute7"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute8
     * Eighth customizable extension attribute.
     *
     * @return string|null The extensionAttribute8
     */
    public function getExtensionAttribute8()
    {
        if (array_key_exists("extensionAttribute8", $this->_propDict)) {
            return $this->_propDict["extensionAttribute8"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute8
     * Eighth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute8
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute8($val)
    {
        $this->_propDict["extensionAttribute8"] = $val;
        return $this;
    }
    /**
     * Gets the extensionAttribute9
     * Ninth customizable extension attribute.
     *
     * @return string|null The extensionAttribute9
     */
    public function getExtensionAttribute9()
    {
        if (array_key_exists("extensionAttribute9", $this->_propDict)) {
            return $this->_propDict["extensionAttribute9"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensionAttribute9
     * Ninth customizable extension attribute.
     *
     * @param string $val The value of the extensionAttribute9
     *
     * @return OnPremisesExtensionAttributes
     */
    public function setExtensionAttribute9($val)
    {
        $this->_propDict["extensionAttribute9"] = $val;
        return $this;
    }
}
