<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MediaContentRatingJapan File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* MediaContentRatingJapan class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MediaContentRatingJapan extends Entity
{
    /**
     * Gets the movieRating
     * Movies rating selected for Japan. Possible values are: allAllowed, allBlocked, general, parentalGuidance, agesAbove15, agesAbove18.
     *
     * @return RatingJapanMoviesType|null The movieRating
     */
    public function getMovieRating()
    {
        if (array_key_exists("movieRating", $this->_propDict)) {
            if (is_a($this->_propDict["movieRating"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\RatingJapanMoviesType") || is_null($this->_propDict["movieRating"])) {
                return $this->_propDict["movieRating"];
            } else {
                $this->_propDict["movieRating"] = new RatingJapanMoviesType($this->_propDict["movieRating"]);
                return $this->_propDict["movieRating"];
            }
        }
        return null;
    }
    /**
     * Sets the movieRating
     * Movies rating selected for Japan. Possible values are: allAllowed, allBlocked, general, parentalGuidance, agesAbove15, agesAbove18.
     *
     * @param RatingJapanMoviesType $val The value to assign to the movieRating
     *
     * @return MediaContentRatingJapan The MediaContentRatingJapan
     */
    public function setMovieRating($val)
    {
        $this->_propDict["movieRating"] = $val;
        return $this;
    }
    /**
     * Gets the tvRating
     * TV rating selected for Japan. Possible values are: allAllowed, allBlocked, explicitAllowed.
     *
     * @return RatingJapanTelevisionType|null The tvRating
     */
    public function getTvRating()
    {
        if (array_key_exists("tvRating", $this->_propDict)) {
            if (is_a($this->_propDict["tvRating"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\RatingJapanTelevisionType") || is_null($this->_propDict["tvRating"])) {
                return $this->_propDict["tvRating"];
            } else {
                $this->_propDict["tvRating"] = new RatingJapanTelevisionType($this->_propDict["tvRating"]);
                return $this->_propDict["tvRating"];
            }
        }
        return null;
    }
    /**
     * Sets the tvRating
     * TV rating selected for Japan. Possible values are: allAllowed, allBlocked, explicitAllowed.
     *
     * @param RatingJapanTelevisionType $val The value to assign to the tvRating
     *
     * @return MediaContentRatingJapan The MediaContentRatingJapan
     */
    public function setTvRating($val)
    {
        $this->_propDict["tvRating"] = $val;
        return $this;
    }
}
