<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* IosLobAppProvisioningConfiguration File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* IosLobAppProvisioningConfiguration class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class IosLobAppProvisioningConfiguration extends Entity
{
    /**
     * Gets the createdDateTime
     * DateTime the object was created.
     *
     * @return \DateTime|null The createdDateTime
     */
    public function getCreatedDateTime()
    {
        if (array_key_exists("createdDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["createdDateTime"], "\\DateTime") || is_null($this->_propDict["createdDateTime"])) {
                return $this->_propDict["createdDateTime"];
            } else {
                $this->_propDict["createdDateTime"] = new \DateTime($this->_propDict["createdDateTime"]);
                return $this->_propDict["createdDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the createdDateTime
     * DateTime the object was created.
     *
     * @param \DateTime $val The createdDateTime
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setCreatedDateTime($val)
    {
        $this->_propDict["createdDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the description
     * Admin provided description of the Device Configuration.
     *
     * @return string|null The description
     */
    public function getDescription()
    {
        if (array_key_exists("description", $this->_propDict)) {
            return $this->_propDict["description"];
        } else {
            return null;
        }
    }
    /**
     * Sets the description
     * Admin provided description of the Device Configuration.
     *
     * @param string $val The description
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setDescription($val)
    {
        $this->_propDict["description"] = $val;
        return $this;
    }
    /**
     * Gets the displayName
     * Admin provided name of the device configuration.
     *
     * @return string|null The displayName
     */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the displayName
     * Admin provided name of the device configuration.
     *
     * @param string $val The displayName
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    /**
     * Gets the expirationDateTime
     * Optional profile expiration date and time.
     *
     * @return \DateTime|null The expirationDateTime
     */
    public function getExpirationDateTime()
    {
        if (array_key_exists("expirationDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["expirationDateTime"], "\\DateTime") || is_null($this->_propDict["expirationDateTime"])) {
                return $this->_propDict["expirationDateTime"];
            } else {
                $this->_propDict["expirationDateTime"] = new \DateTime($this->_propDict["expirationDateTime"]);
                return $this->_propDict["expirationDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the expirationDateTime
     * Optional profile expiration date and time.
     *
     * @param \DateTime $val The expirationDateTime
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setExpirationDateTime($val)
    {
        $this->_propDict["expirationDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the lastModifiedDateTime
     * DateTime the object was last modified.
     *
     * @return \DateTime|null The lastModifiedDateTime
     */
    public function getLastModifiedDateTime()
    {
        if (array_key_exists("lastModifiedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastModifiedDateTime"], "\\DateTime") || is_null($this->_propDict["lastModifiedDateTime"])) {
                return $this->_propDict["lastModifiedDateTime"];
            } else {
                $this->_propDict["lastModifiedDateTime"] = new \DateTime($this->_propDict["lastModifiedDateTime"]);
                return $this->_propDict["lastModifiedDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the lastModifiedDateTime
     * DateTime the object was last modified.
     *
     * @param \DateTime $val The lastModifiedDateTime
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setLastModifiedDateTime($val)
    {
        $this->_propDict["lastModifiedDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the payload
     * Payload. (UTF8 encoded byte array)
     *
     * @return \GuzzleHttp\Psr7\Stream|null The payload
     */
    public function getPayload()
    {
        if (array_key_exists("payload", $this->_propDict)) {
            if (is_a($this->_propDict["payload"], "XCloner\\GuzzleHttp\\Psr7\\Stream") || is_null($this->_propDict["payload"])) {
                return $this->_propDict["payload"];
            } else {
                $this->_propDict["payload"] = \XCloner\GuzzleHttp\Psr7\Utils::streamFor($this->_propDict["payload"]);
                return $this->_propDict["payload"];
            }
        }
        return null;
    }
    /**
     * Sets the payload
     * Payload. (UTF8 encoded byte array)
     *
     * @param \GuzzleHttp\Psr7\Stream $val The payload
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setPayload($val)
    {
        $this->_propDict["payload"] = $val;
        return $this;
    }
    /**
     * Gets the payloadFileName
     * Payload file name (.mobileprovision
     *
     * @return string|null The payloadFileName
     */
    public function getPayloadFileName()
    {
        if (array_key_exists("payloadFileName", $this->_propDict)) {
            return $this->_propDict["payloadFileName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the payloadFileName
     * Payload file name (.mobileprovision
     *
     * @param string $val The payloadFileName
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setPayloadFileName($val)
    {
        $this->_propDict["payloadFileName"] = $val;
        return $this;
    }
    /**
     * Gets the roleScopeTagIds
     * List of Scope Tags for this iOS LOB app provisioning configuration entity.
     *
     * @return array|null The roleScopeTagIds
     */
    public function getRoleScopeTagIds()
    {
        if (array_key_exists("roleScopeTagIds", $this->_propDict)) {
            return $this->_propDict["roleScopeTagIds"];
        } else {
            return null;
        }
    }
    /**
     * Sets the roleScopeTagIds
     * List of Scope Tags for this iOS LOB app provisioning configuration entity.
     *
     * @param string[] $val The roleScopeTagIds
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setRoleScopeTagIds($val)
    {
        $this->_propDict["roleScopeTagIds"] = $val;
        return $this;
    }
    /**
     * Gets the version
     * Version of the device configuration.
     *
     * @return int|null The version
     */
    public function getVersion()
    {
        if (array_key_exists("version", $this->_propDict)) {
            return $this->_propDict["version"];
        } else {
            return null;
        }
    }
    /**
     * Sets the version
     * Version of the device configuration.
     *
     * @param int $val The version
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setVersion($val)
    {
        $this->_propDict["version"] = intval($val);
        return $this;
    }
    /**
     * Gets the assignments
     * The associated group assignments for IosLobAppProvisioningConfiguration.
     *
     * @return array|null The assignments
     */
    public function getAssignments()
    {
        if (array_key_exists("assignments", $this->_propDict)) {
            return $this->_propDict["assignments"];
        } else {
            return null;
        }
    }
    /**
     * Sets the assignments
     * The associated group assignments for IosLobAppProvisioningConfiguration.
     *
     * @param IosLobAppProvisioningConfigurationAssignment[] $val The assignments
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setAssignments($val)
    {
        $this->_propDict["assignments"] = $val;
        return $this;
    }
    /**
     * Gets the deviceStatuses
     * The list of device installation states for this mobile app configuration.
     *
     * @return array|null The deviceStatuses
     */
    public function getDeviceStatuses()
    {
        if (array_key_exists("deviceStatuses", $this->_propDict)) {
            return $this->_propDict["deviceStatuses"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceStatuses
     * The list of device installation states for this mobile app configuration.
     *
     * @param ManagedDeviceMobileAppConfigurationDeviceStatus[] $val The deviceStatuses
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setDeviceStatuses($val)
    {
        $this->_propDict["deviceStatuses"] = $val;
        return $this;
    }
    /**
     * Gets the groupAssignments
     * The associated group assignments.
     *
     * @return array|null The groupAssignments
     */
    public function getGroupAssignments()
    {
        if (array_key_exists("groupAssignments", $this->_propDict)) {
            return $this->_propDict["groupAssignments"];
        } else {
            return null;
        }
    }
    /**
     * Sets the groupAssignments
     * The associated group assignments.
     *
     * @param MobileAppProvisioningConfigGroupAssignment[] $val The groupAssignments
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setGroupAssignments($val)
    {
        $this->_propDict["groupAssignments"] = $val;
        return $this;
    }
    /**
     * Gets the userStatuses
     * The list of user installation states for this mobile app configuration.
     *
     * @return array|null The userStatuses
     */
    public function getUserStatuses()
    {
        if (array_key_exists("userStatuses", $this->_propDict)) {
            return $this->_propDict["userStatuses"];
        } else {
            return null;
        }
    }
    /**
     * Sets the userStatuses
     * The list of user installation states for this mobile app configuration.
     *
     * @param ManagedDeviceMobileAppConfigurationUserStatus[] $val The userStatuses
     *
     * @return IosLobAppProvisioningConfiguration
     */
    public function setUserStatuses($val)
    {
        $this->_propDict["userStatuses"] = $val;
        return $this;
    }
}
