<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* FileSecurityProfile File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* FileSecurityProfile class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class FileSecurityProfile extends Entity
{
    /**
     * Gets the activityGroupNames
     *
     * @return array|null The activityGroupNames
     */
    public function getActivityGroupNames()
    {
        if (array_key_exists("activityGroupNames", $this->_propDict)) {
            return $this->_propDict["activityGroupNames"];
        } else {
            return null;
        }
    }
    /**
     * Sets the activityGroupNames
     *
     * @param string[] $val The activityGroupNames
     *
     * @return FileSecurityProfile
     */
    public function setActivityGroupNames($val)
    {
        $this->_propDict["activityGroupNames"] = $val;
        return $this;
    }
    /**
     * Gets the azureSubscriptionId
     *
     * @return string|null The azureSubscriptionId
     */
    public function getAzureSubscriptionId()
    {
        if (array_key_exists("azureSubscriptionId", $this->_propDict)) {
            return $this->_propDict["azureSubscriptionId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the azureSubscriptionId
     *
     * @param string $val The azureSubscriptionId
     *
     * @return FileSecurityProfile
     */
    public function setAzureSubscriptionId($val)
    {
        $this->_propDict["azureSubscriptionId"] = $val;
        return $this;
    }
    /**
     * Gets the azureTenantId
     *
     * @return string|null The azureTenantId
     */
    public function getAzureTenantId()
    {
        if (array_key_exists("azureTenantId", $this->_propDict)) {
            return $this->_propDict["azureTenantId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the azureTenantId
     *
     * @param string $val The azureTenantId
     *
     * @return FileSecurityProfile
     */
    public function setAzureTenantId($val)
    {
        $this->_propDict["azureTenantId"] = $val;
        return $this;
    }
    /**
     * Gets the certificateThumbprint
     *
     * @return string|null The certificateThumbprint
     */
    public function getCertificateThumbprint()
    {
        if (array_key_exists("certificateThumbprint", $this->_propDict)) {
            return $this->_propDict["certificateThumbprint"];
        } else {
            return null;
        }
    }
    /**
     * Sets the certificateThumbprint
     *
     * @param string $val The certificateThumbprint
     *
     * @return FileSecurityProfile
     */
    public function setCertificateThumbprint($val)
    {
        $this->_propDict["certificateThumbprint"] = $val;
        return $this;
    }
    /**
     * Gets the extensions
     *
     * @return array|null The extensions
     */
    public function getExtensions()
    {
        if (array_key_exists("extensions", $this->_propDict)) {
            return $this->_propDict["extensions"];
        } else {
            return null;
        }
    }
    /**
     * Sets the extensions
     *
     * @param string[] $val The extensions
     *
     * @return FileSecurityProfile
     */
    public function setExtensions($val)
    {
        $this->_propDict["extensions"] = $val;
        return $this;
    }
    /**
     * Gets the fileType
     *
     * @return string|null The fileType
     */
    public function getFileType()
    {
        if (array_key_exists("fileType", $this->_propDict)) {
            return $this->_propDict["fileType"];
        } else {
            return null;
        }
    }
    /**
     * Sets the fileType
     *
     * @param string $val The fileType
     *
     * @return FileSecurityProfile
     */
    public function setFileType($val)
    {
        $this->_propDict["fileType"] = $val;
        return $this;
    }
    /**
     * Gets the firstSeenDateTime
     *
     * @return \DateTime|null The firstSeenDateTime
     */
    public function getFirstSeenDateTime()
    {
        if (array_key_exists("firstSeenDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["firstSeenDateTime"], "\\DateTime") || is_null($this->_propDict["firstSeenDateTime"])) {
                return $this->_propDict["firstSeenDateTime"];
            } else {
                $this->_propDict["firstSeenDateTime"] = new \DateTime($this->_propDict["firstSeenDateTime"]);
                return $this->_propDict["firstSeenDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the firstSeenDateTime
     *
     * @param \DateTime $val The firstSeenDateTime
     *
     * @return FileSecurityProfile
     */
    public function setFirstSeenDateTime($val)
    {
        $this->_propDict["firstSeenDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the hashes
     *
     * @return array|null The hashes
     */
    public function getHashes()
    {
        if (array_key_exists("hashes", $this->_propDict)) {
            return $this->_propDict["hashes"];
        } else {
            return null;
        }
    }
    /**
     * Sets the hashes
     *
     * @param FileHash[] $val The hashes
     *
     * @return FileSecurityProfile
     */
    public function setHashes($val)
    {
        $this->_propDict["hashes"] = $val;
        return $this;
    }
    /**
     * Gets the lastSeenDateTime
     *
     * @return \DateTime|null The lastSeenDateTime
     */
    public function getLastSeenDateTime()
    {
        if (array_key_exists("lastSeenDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastSeenDateTime"], "\\DateTime") || is_null($this->_propDict["lastSeenDateTime"])) {
                return $this->_propDict["lastSeenDateTime"];
            } else {
                $this->_propDict["lastSeenDateTime"] = new \DateTime($this->_propDict["lastSeenDateTime"]);
                return $this->_propDict["lastSeenDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the lastSeenDateTime
     *
     * @param \DateTime $val The lastSeenDateTime
     *
     * @return FileSecurityProfile
     */
    public function setLastSeenDateTime($val)
    {
        $this->_propDict["lastSeenDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the malwareStates
     *
     * @return array|null The malwareStates
     */
    public function getMalwareStates()
    {
        if (array_key_exists("malwareStates", $this->_propDict)) {
            return $this->_propDict["malwareStates"];
        } else {
            return null;
        }
    }
    /**
     * Sets the malwareStates
     *
     * @param MalwareState[] $val The malwareStates
     *
     * @return FileSecurityProfile
     */
    public function setMalwareStates($val)
    {
        $this->_propDict["malwareStates"] = $val;
        return $this;
    }
    /**
     * Gets the names
     *
     * @return array|null The names
     */
    public function getNames()
    {
        if (array_key_exists("names", $this->_propDict)) {
            return $this->_propDict["names"];
        } else {
            return null;
        }
    }
    /**
     * Sets the names
     *
     * @param string[] $val The names
     *
     * @return FileSecurityProfile
     */
    public function setNames($val)
    {
        $this->_propDict["names"] = $val;
        return $this;
    }
    /**
     * Gets the riskScore
     *
     * @return string|null The riskScore
     */
    public function getRiskScore()
    {
        if (array_key_exists("riskScore", $this->_propDict)) {
            return $this->_propDict["riskScore"];
        } else {
            return null;
        }
    }
    /**
     * Sets the riskScore
     *
     * @param string $val The riskScore
     *
     * @return FileSecurityProfile
     */
    public function setRiskScore($val)
    {
        $this->_propDict["riskScore"] = $val;
        return $this;
    }
    /**
     * Gets the size
     *
     * @return int|null The size
     */
    public function getSize()
    {
        if (array_key_exists("size", $this->_propDict)) {
            return $this->_propDict["size"];
        } else {
            return null;
        }
    }
    /**
     * Sets the size
     *
     * @param int $val The size
     *
     * @return FileSecurityProfile
     */
    public function setSize($val)
    {
        $this->_propDict["size"] = intval($val);
        return $this;
    }
    /**
     * Gets the tags
     *
     * @return array|null The tags
     */
    public function getTags()
    {
        if (array_key_exists("tags", $this->_propDict)) {
            return $this->_propDict["tags"];
        } else {
            return null;
        }
    }
    /**
     * Sets the tags
     *
     * @param string[] $val The tags
     *
     * @return FileSecurityProfile
     */
    public function setTags($val)
    {
        $this->_propDict["tags"] = $val;
        return $this;
    }
    /**
     * Gets the vendorInformation
     *
     * @return SecurityVendorInformation|null The vendorInformation
     */
    public function getVendorInformation()
    {
        if (array_key_exists("vendorInformation", $this->_propDict)) {
            if (is_a($this->_propDict["vendorInformation"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\SecurityVendorInformation") || is_null($this->_propDict["vendorInformation"])) {
                return $this->_propDict["vendorInformation"];
            } else {
                $this->_propDict["vendorInformation"] = new SecurityVendorInformation($this->_propDict["vendorInformation"]);
                return $this->_propDict["vendorInformation"];
            }
        }
        return null;
    }
    /**
     * Sets the vendorInformation
     *
     * @param SecurityVendorInformation $val The vendorInformation
     *
     * @return FileSecurityProfile
     */
    public function setVendorInformation($val)
    {
        $this->_propDict["vendorInformation"] = $val;
        return $this;
    }
    /**
     * Gets the vulnerabilityStates
     *
     * @return array|null The vulnerabilityStates
     */
    public function getVulnerabilityStates()
    {
        if (array_key_exists("vulnerabilityStates", $this->_propDict)) {
            return $this->_propDict["vulnerabilityStates"];
        } else {
            return null;
        }
    }
    /**
     * Sets the vulnerabilityStates
     *
     * @param VulnerabilityState[] $val The vulnerabilityStates
     *
     * @return FileSecurityProfile
     */
    public function setVulnerabilityStates($val)
    {
        $this->_propDict["vulnerabilityStates"] = $val;
        return $this;
    }
}
