<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* CloudPcAuditResource File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* CloudPcAuditResource class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class CloudPcAuditResource extends Entity
{
    /**
     * Gets the displayName
     * The resource entity display name.
     *
     * @return string|null The displayName
     */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the displayName
     * The resource entity display name.
     *
     * @param string $val The value of the displayName
     *
     * @return CloudPcAuditResource
     */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    /**
     * Gets the modifiedProperties
     * A list of modified properties.
     *
     * @return CloudPcAuditProperty|null The modifiedProperties
     */
    public function getModifiedProperties()
    {
        if (array_key_exists("modifiedProperties", $this->_propDict)) {
            if (is_a($this->_propDict["modifiedProperties"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\CloudPcAuditProperty") || is_null($this->_propDict["modifiedProperties"])) {
                return $this->_propDict["modifiedProperties"];
            } else {
                $this->_propDict["modifiedProperties"] = new CloudPcAuditProperty($this->_propDict["modifiedProperties"]);
                return $this->_propDict["modifiedProperties"];
            }
        }
        return null;
    }
    /**
     * Sets the modifiedProperties
     * A list of modified properties.
     *
     * @param CloudPcAuditProperty $val The value to assign to the modifiedProperties
     *
     * @return CloudPcAuditResource The CloudPcAuditResource
     */
    public function setModifiedProperties($val)
    {
        $this->_propDict["modifiedProperties"] = $val;
        return $this;
    }
    /**
     * Gets the resourceId
     * The ID of the audit resource.
     *
     * @return string|null The resourceId
     */
    public function getResourceId()
    {
        if (array_key_exists("resourceId", $this->_propDict)) {
            return $this->_propDict["resourceId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the resourceId
     * The ID of the audit resource.
     *
     * @param string $val The value of the resourceId
     *
     * @return CloudPcAuditResource
     */
    public function setResourceId($val)
    {
        $this->_propDict["resourceId"] = $val;
        return $this;
    }
    /**
     * Gets the type
     * The type of the audit resource.
     *
     * @return string|null The type
     */
    public function getType()
    {
        if (array_key_exists("type", $this->_propDict)) {
            return $this->_propDict["type"];
        } else {
            return null;
        }
    }
    /**
     * Sets the type
     * The type of the audit resource.
     *
     * @param string $val The value of the type
     *
     * @return CloudPcAuditResource
     */
    public function setType($val)
    {
        $this->_propDict["type"] = $val;
        return $this;
    }
}
