<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ChannelIdentity File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* ChannelIdentity class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ChannelIdentity extends Entity
{
    /**
     * Gets the channelId
     * The identity of the channel in which the message was posted.
     *
     * @return string|null The channelId
     */
    public function getChannelId()
    {
        if (array_key_exists("channelId", $this->_propDict)) {
            return $this->_propDict["channelId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the channelId
     * The identity of the channel in which the message was posted.
     *
     * @param string $val The value of the channelId
     *
     * @return ChannelIdentity
     */
    public function setChannelId($val)
    {
        $this->_propDict["channelId"] = $val;
        return $this;
    }
    /**
     * Gets the teamId
     * The identity of the team in which the message was posted.
     *
     * @return string|null The teamId
     */
    public function getTeamId()
    {
        if (array_key_exists("teamId", $this->_propDict)) {
            return $this->_propDict["teamId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the teamId
     * The identity of the team in which the message was posted.
     *
     * @param string $val The value of the teamId
     *
     * @return ChannelIdentity
     */
    public function setTeamId($val)
    {
        $this->_propDict["teamId"] = $val;
        return $this;
    }
}
