<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AgreementFileLocalization File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* AgreementFileLocalization class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AgreementFileLocalization extends AgreementFileProperties
{
    /**
     * Gets the versions
     * Read-only. Customized versions of the terms of use agreement in the Azure AD tenant.
     *
     * @return array|null The versions
     */
    public function getVersions()
    {
        if (array_key_exists("versions", $this->_propDict)) {
            return $this->_propDict["versions"];
        } else {
            return null;
        }
    }
    /**
     * Sets the versions
     * Read-only. Customized versions of the terms of use agreement in the Azure AD tenant.
     *
     * @param AgreementFileVersion[] $val The versions
     *
     * @return AgreementFileLocalization
     */
    public function setVersions($val)
    {
        $this->_propDict["versions"] = $val;
        return $this;
    }
}
