<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* TenantTag File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\ManagedTenants\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* TenantTag class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class TenantTag extends \XCloner\Beta\Microsoft\Graph\Model\Entity
{
    /**
     * Gets the createdByUserId
     * The identifier for the account that created the tenant tag. Required. Read-only.
     *
     * @return string|null The createdByUserId
     */
    public function getCreatedByUserId()
    {
        if (array_key_exists("createdByUserId", $this->_propDict)) {
            return $this->_propDict["createdByUserId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the createdByUserId
     * The identifier for the account that created the tenant tag. Required. Read-only.
     *
     * @param string $val The createdByUserId
     *
     * @return TenantTag
     */
    public function setCreatedByUserId($val)
    {
        $this->_propDict["createdByUserId"] = $val;
        return $this;
    }
    /**
     * Gets the createdDateTime
     * The date and time when the tenant tag was created. Required. Read-only.
     *
     * @return \DateTime|null The createdDateTime
     */
    public function getCreatedDateTime()
    {
        if (array_key_exists("createdDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["createdDateTime"], "\\DateTime") || is_null($this->_propDict["createdDateTime"])) {
                return $this->_propDict["createdDateTime"];
            } else {
                $this->_propDict["createdDateTime"] = new \DateTime($this->_propDict["createdDateTime"]);
                return $this->_propDict["createdDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the createdDateTime
     * The date and time when the tenant tag was created. Required. Read-only.
     *
     * @param \DateTime $val The createdDateTime
     *
     * @return TenantTag
     */
    public function setCreatedDateTime($val)
    {
        $this->_propDict["createdDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the deletedDateTime
     * The date and time when the tenant tag was deleted. Required. Read-only.
     *
     * @return \DateTime|null The deletedDateTime
     */
    public function getDeletedDateTime()
    {
        if (array_key_exists("deletedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["deletedDateTime"], "\\DateTime") || is_null($this->_propDict["deletedDateTime"])) {
                return $this->_propDict["deletedDateTime"];
            } else {
                $this->_propDict["deletedDateTime"] = new \DateTime($this->_propDict["deletedDateTime"]);
                return $this->_propDict["deletedDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the deletedDateTime
     * The date and time when the tenant tag was deleted. Required. Read-only.
     *
     * @param \DateTime $val The deletedDateTime
     *
     * @return TenantTag
     */
    public function setDeletedDateTime($val)
    {
        $this->_propDict["deletedDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the description
     * The description for the tenant tag. Optional. Read-only.
     *
     * @return string|null The description
     */
    public function getDescription()
    {
        if (array_key_exists("description", $this->_propDict)) {
            return $this->_propDict["description"];
        } else {
            return null;
        }
    }
    /**
     * Sets the description
     * The description for the tenant tag. Optional. Read-only.
     *
     * @param string $val The description
     *
     * @return TenantTag
     */
    public function setDescription($val)
    {
        $this->_propDict["description"] = $val;
        return $this;
    }
    /**
     * Gets the displayName
     * The display name for the tenant tag. Required. Read-only.
     *
     * @return string|null The displayName
     */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the displayName
     * The display name for the tenant tag. Required. Read-only.
     *
     * @param string $val The displayName
     *
     * @return TenantTag
     */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    /**
     * Gets the lastActionByUserId
     * The identifier for the account that lasted on the tenant tag. Optional. Read-only.
     *
     * @return string|null The lastActionByUserId
     */
    public function getLastActionByUserId()
    {
        if (array_key_exists("lastActionByUserId", $this->_propDict)) {
            return $this->_propDict["lastActionByUserId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the lastActionByUserId
     * The identifier for the account that lasted on the tenant tag. Optional. Read-only.
     *
     * @param string $val The lastActionByUserId
     *
     * @return TenantTag
     */
    public function setLastActionByUserId($val)
    {
        $this->_propDict["lastActionByUserId"] = $val;
        return $this;
    }
    /**
     * Gets the lastActionDateTime
     * The date and time the last action was performed against the tenant tag. Optional. Read-only.
     *
     * @return \DateTime|null The lastActionDateTime
     */
    public function getLastActionDateTime()
    {
        if (array_key_exists("lastActionDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastActionDateTime"], "\\DateTime") || is_null($this->_propDict["lastActionDateTime"])) {
                return $this->_propDict["lastActionDateTime"];
            } else {
                $this->_propDict["lastActionDateTime"] = new \DateTime($this->_propDict["lastActionDateTime"]);
                return $this->_propDict["lastActionDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the lastActionDateTime
     * The date and time the last action was performed against the tenant tag. Optional. Read-only.
     *
     * @param \DateTime $val The lastActionDateTime
     *
     * @return TenantTag
     */
    public function setLastActionDateTime($val)
    {
        $this->_propDict["lastActionDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the tenants
     * The collection of managed tenants associated with the tenant tag. Optional.
     *
     * @return array|null The tenants
     */
    public function getTenants()
    {
        if (array_key_exists("tenants", $this->_propDict)) {
            return $this->_propDict["tenants"];
        } else {
            return null;
        }
    }
    /**
     * Sets the tenants
     * The collection of managed tenants associated with the tenant tag. Optional.
     *
     * @param TenantInfo[] $val The tenants
     *
     * @return TenantTag
     */
    public function setTenants($val)
    {
        $this->_propDict["tenants"] = $val;
        return $this;
    }
}
