<?php

	/**
	 * WS Form LITE - Drag & Drop Contact Form Builder
	 *
	 * @link              https://wsform.com/
	 * @since             1.0.0
	 * @package           WS_Form
	 *
	 * @wordpress-plugin
	 * Plugin Name:       WS Form LITE - Drag & Drop Contact Form Builder
	 * Plugin URI:        https://wsform.com/
	 * Description:       Smart. Fast. Forms.
	 * Version:           1.10.73
	 * Requires at least: 5.4
	 * Requires PHP:      7.2
	 * Author:            WS Form
	 * Author URI:        https://wsform.com/
	 * License:           GPL-3.0+
	 * License URI:       http://www.gnu.org/licenses/gpl-3.0.txt
	 * Text Domain:       ws-form
	 * Domain Path:       /languages
	 */

	// If this file is called directly, abort.
	if(!defined('WPINC')) {

		die;
	}

	// Load plugin.php
	if(!function_exists('is_plugin_active')) {

		include_once(ABSPATH . 'wp-admin/includes/plugin.php');
	}

	if(!is_plugin_active('ws-form-pro/ws-form.php')) {
		// Constants
		define('WS_FORM_NAME', 'ws-form');
		define('WS_FORM_VERSION', '1.10.73');
		define('WS_FORM_NAME_GENERIC', 'WS Form');
		define('WS_FORM_NAME_PRESENTABLE', 'WS Form LITE');
		define('WS_FORM_EDITION', 'basic');
		define('WS_FORM_PLUGIN_FOLDER', 'ws-form');
		define('WS_FORM_URL_HOME', 'https://wordpress.org/plugins/ws-form/');
		define('WS_FORM_URL_DOWNLOAD', 'https://downloads.wordpress.org/plugin/ws-form.zip');
		define('WS_FORM_UPLOAD_DIR', 'ws-form');
		define('WS_FORM_IDENTIFIER', 'ws_form');
		define('WS_FORM_DB_TABLE_PREFIX', 'wsf_');
		define('WS_FORM_OPTION_NAME', 'ws_form');
		define('WS_FORM_OPTION_SEPARATE_ACTION', false);
		define('WS_FORM_OPTION_SEPARATE_CSS', true);
		define('WS_FORM_SHORTCODE', 'ws_form');
		define('WS_FORM_WIDGET', 'ws_form_widget');
		define('WS_FORM_CAPABILITY_PREFIX', 'wsf_');
		define('WS_FORM_USER_REQUEST_IDENTIFIER', 'ws-form');
		define('WS_FORM_AUTHOR', 'Westguard Solutions');

		// Paths
		define('WS_FORM_PLUGIN_ROOT_FILE', __FILE__);
		define('WS_FORM_PLUGIN_DIR_PATH', plugin_dir_path(__FILE__));
		define('WS_FORM_PLUGIN_DIR_URL', plugin_dir_url(__FILE__));
		define('WS_FORM_PLUGIN_BASENAME', plugin_basename(__FILE__));

		// NONCE
		define('WS_FORM_POST_NONCE_FIELD_NAME', 'wsf_nonce');
		define('WS_FORM_POST_NONCE_ACTION_NAME', 'wsf_post');

		// REST API
		define('WS_FORM_RESTFUL_NAMESPACE', 'ws-form/v1');

		// Framework
		define('WS_FORM_DEFAULT_FRAMEWORK', 'ws-form');

		// caniuse.com
		define('WS_FORM_COMPATIBILITY_NAME', 'caniuse.com');
		define('WS_FORM_COMPATIBILITY_URL', 'https://caniuse.com');
		define('WS_FORM_COMPATIBILITY_MASK', 'https://caniuse.com/#feat=#compatibility_id');

		// Modes
		define('WS_FORM_MODES', 'basic,advanced');
		define('WS_FORM_DEFAULT_MODE', 'basic');

		// Captchas / Spam
		define('WS_FORM_RECAPTCHA_ENDPOINT', 'https://www.google.com/recaptcha/api/siteverify');
		define('WS_FORM_RECAPTCHA_QUERY_VAR', 'g-recaptcha-response');
		define('WS_FORM_HCAPTCHA_ENDPOINT', 'https://hcaptcha.com/siteverify');
		define('WS_FORM_HCAPTCHA_QUERY_VAR', 'h-captcha-response');
		define('WS_FORM_TURNSTILE_ENDPOINT', 'https://challenges.cloudflare.com/turnstile/v0/siteverify');
		define('WS_FORM_TURNSTILE_QUERY_VAR', 'cf-turnstile-response');
		define('WS_FORM_SPAM_LEVEL_MAX', 100);		// 0 = Not spam, 100 = Spam

		// Labels
		define('WS_FORM_LABEL_MAX_LENGTH', 1024);

		// Sections
		define('WS_FORM_SECTION_REPEATABLE_DELIMITER_SECTION', ',');
		define('WS_FORM_SECTION_REPEATABLE_DELIMITER_ROW', ';');
		define('WS_FORM_SECTION_REPEATABLE_DELIMITER_SUBMIT', '<br />');

		// Fields
		define('WS_FORM_FIELD_PREFIX', 'field_');
		define('WS_FORM_FIELD_PREFIX_PUBLIC_', 'wsf_field_');

		// Settings - Email
		define('WS_FORM_SETTINGS_IMAGE_PREVIEW_SIZE', 'full');

		// Settings - System
		define('WS_FORM_MIN_VERSION_WORDPRESS', '5.4');
		define('WS_FORM_MIN_VERSION_PHP', '7.2');
		define('WS_FORM_MIN_VERSION_MYSQL', '5.6');
		define('WS_FORM_MIN_INPUT_VARS', 100);
		define('WS_FORM_MAX_MYSQL_ALLOWED_PACKET', 4194304);

		// wp_remote_* settings
		define('WS_FORM_API_CALL_TIMEOUT', 15);
		define('WS_FORM_API_CALL_SSL_VERIFY', true);

		// Review nag
		define('WS_FORM_REVIEW_NAG_DURATION', 14);

		// Data sources
		define('WS_FORM_DATA_SOURCE_SCHEDULE_ID_PREFIX', 'wsf_');
		define('WS_FORM_DATA_SOURCE_SCHEDULE_HOOK', 'ws_form_wp_cron_data_source');

		// Reports
		define('WS_FORM_REPORT_SCHEDULE_HOOK', 'ws_form_wp_cron_report');
		define('WS_FORM_REPORT_ID_FORM_STATISTICS', 'ws_form_form_statistics');

		// CSV imports for data grids
		define('WS_FORM_UTF32_BIG_ENDIAN_BOM'   , chr(0x00) . chr(0x00) . chr(0xFE) . chr(0xFF));
		define('WS_FORM_UTF32_LITTLE_ENDIAN_BOM', chr(0xFF) . chr(0xFE) . chr(0x00) . chr(0x00));
		define('WS_FORM_UTF16_BIG_ENDIAN_BOM'   , chr(0xFE) . chr(0xFF));
		define('WS_FORM_UTF16_LITTLE_ENDIAN_BOM', chr(0xFF) . chr(0xFE));
		define('WS_FORM_UTF8_BOM'               , chr(0xEF) . chr(0xBB) . chr(0xBF));

		// Templates
		define('WS_FORM_TEMPLATE_SVG_WIDTH_FORM', 140);
		define('WS_FORM_TEMPLATE_SVG_HEIGHT_FORM', 180);
		define('WS_FORM_TEMPLATE_SVG_WIDTH_SECTION', 140);
		define('WS_FORM_TEMPLATE_SVG_HEIGHT_SECTION', 85);
		define('WS_FORM_TEMPLATE_CHECKSUM_REPAIR', false);

		// Submission exports
		define('WS_FORM_SUBMIT_EXPORT_PAGE_SIZE', 200);
		define('WS_FORM_SUBMIT_EXPORT_FILE_SIZE_ZIP', 524288);
		define('WS_FORM_SUBMIT_EXPORT_TMP_DIR', 'submit/export/tmp');

		// File uploads
		define('WS_FORM_DROPZONEJS_IMAGE_SIZE', 'thumbnail');

		// Styler / CSS
		define('WS_FORM_STYLER', true);
		define('WS_FORM_CSS_CACHE_DURATION_DEFAULT', 31536000);
		define('WS_FORM_CSS_FILE_PATH', 'css/public');
		define('WS_FORM_CSS_SKIN_DEFAULT', 'ws_form');

		// AI
		define('WS_FORM_ABILITY_API', true);
		define('WS_FORM_ABILITY_API_NAMESPACE', 'ws-form/');
		define('WS_FORM_MCP_ADAPTER', true);
		define('WS_FORM_ANGIE', true);

		// Resizable sidebar
		define('WS_FORM_SIDEBAR_WIDTH_MIN', 340);
		define('WS_FORM_SIDEBAR_WIDTH_MAX', 1000);
		define('WS_FORM_SIDEBAR_WIDTH_DEFAULT', WS_FORM_SIDEBAR_WIDTH_MIN);
	}

	function ws_form_activate() {

		if(is_plugin_active('ws-form-pro/ws-form.php')) {

			deactivate_plugins('ws-form-pro/ws-form.php');
		}

		require_once WS_FORM_PLUGIN_DIR_PATH . 'includes/class-ws-form-activator.php';
		WS_Form_Activator::activate();
	}

	// Deactivate
	function ws_form_deactivate() {

		require_once WS_FORM_PLUGIN_DIR_PATH . 'includes/class-ws-form-deactivator.php';
		WS_Form_Deactivator::deactivate();
	}

	// Uninstall
	function ws_form_uninstall() {

		require_once WS_FORM_PLUGIN_DIR_PATH . 'includes/class-ws-form-uninstaller.php';
		WS_Form_Uninstaller::uninstall();
	}

	// Register hooks for plugin activation, deactivation and uninstall
	register_activation_hook(__FILE__, 'ws_form_activate');
	register_deactivation_hook(__FILE__, 'ws_form_deactivate');
	register_uninstall_hook(__FILE__, 'ws_form_uninstall');

	if(!is_plugin_active('ws-form-pro/ws-form.php')) {

		require WS_FORM_PLUGIN_DIR_PATH . 'includes/class-ws-form.php';

		function ws_form_run() {

			$plugin = new WS_Form();
			$plugin->run();
		}
		ws_form_run();
	}
