<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

// Function to get a list of users with their roles, email, avatar, biography, and nickname
function writerx_get_users() {
  // Get all users who can publish posts
  $users = get_users(array(
    'capability__in' => array('publish_posts'), // Filter users with the capability to publish posts
  ));

  $formatted_users = array();

  foreach ($users as $user) {
    // Retrieve custom avatar URL if available
    $avatar_id = get_user_meta($user->ID, 'custom_avatar', true);
    $avatar_url = $avatar_id ? wp_get_attachment_url($avatar_id) : null;

    // Retrieve user biography and nickname
    $bio = get_user_meta($user->ID, 'description', true);
    $nickname = get_user_meta($user->ID, 'nickname', true);

    // Get the user roles (WordPress stores roles as an array)
    $roles = $user->roles;
    $role_name = !empty($roles) ? $roles[0] : null; // Use the first role if available

    $formatted_user = array(
      'ID'       => $user->ID,
      'username' => $user->user_login,
      'nickname' => $nickname,   // Return the user's nickname
      'email'    => $user->user_email,
      'avatar'   => $avatar_url, // Return custom avatar URL or null
      'bio'      => $bio,        // Return the user's biography
      'role'     => $role_name,  // Return the user's role
    );

    $formatted_users[] = $formatted_user;
  }

  return $formatted_users;
}
