<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

// Function to get the site timezone
function writerx_get_site_timezone() {
  $offset = get_option('gmt_offset');
  $hours = (int) $offset;
  $minutes = abs( $offset - $hours ) * 60;

  // Format timezone as "UTC+HH:MM" or "UTC-HH:MM"
  $timezone = sprintf( 'UTC%+03d:%02d', $hours, $minutes );

  return rest_ensure_response($timezone);
}
