<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

// Function to check if a user exists by email via API
function writerx_check_user_by_email( $request ) {
  $parameters = $request->get_json_params();

  // Validate required parameter
  if ( ! isset( $parameters['email'] ) ) {
    return new WP_Error(
      'missing_parameters',
      'Missing required parameter: email.',
      array( 'status' => 400 )
    );
  }

  $email = sanitize_email( $parameters['email'] );

  // Validate email format
  if ( ! is_email( $email ) ) {
    return new WP_Error(
      'invalid_email',
      'Invalid email address.',
      array( 'status' => 400 )
    );
  }

  // Check if user exists by email
  $user = get_user_by( 'email', $email );

  // Return true or false directly
  return $user ? true : false;
}
