<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://wptrivo.com/
 * @since             1.0.0
 * @package           Wptrivo_Gift_Cards_Lite
 *
 * @wordpress-plugin
 * Plugin Name:       WPTrivo Gift Cards Lite
 * Plugin URI:        https://wptrivo.com/plugins/gift-cards-lite
 * Description:       This plugin allows you to create and sell gift card products.
 * Version:           1.0.1
 * Author:            wptrivo
 * Author URI:        https://wptrivo.com//
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wptrivo-gift-cards-lite
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'WPTGCL_WPTRIVO_GIFT_CARDS_LITE_VERSION', '1.0.1' );

if ( ! defined( 'WPTGCL_PLUGIN_DIR_PATH' ) ) {
	define( 'WPTGCL_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'WPTGCL_PLUGIN_DIR_URL' ) ) {
	define( 'WPTGCL_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'WPTGCL_ADMIN_HOME_URL' ) ) {
	define( 'WPTGCL_ADMIN_HOME_URL', admin_url() );
}

add_action( 'before_woocommerce_init', 'wptgcl_hpos_compatibility' );

function wptgcl_hpos_compatibility() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
}
/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wptrivo-gift-cards-lite-activator.php
 */
function activate_wptrivo_gift_cards_lite() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wptrivo-gift-cards-lite-activator.php';
	Wptgcl_Wptrivo_Gift_Cards_Lite_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wptrivo-gift-cards-lite-deactivator.php
 */
function deactivate_wptrivo_gift_cards_lite() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wptrivo-gift-cards-lite-deactivator.php';
	Wptgcl_Wptrivo_Gift_Cards_Lite_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wptrivo_gift_cards_lite' );
register_deactivation_hook( __FILE__, 'deactivate_wptrivo_gift_cards_lite' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wptrivo-gift-cards-lite.php';
add_action( 'plugins_loaded', 'wptgcl_register_product_class' );

/**
 * Register Gift Card Product Type
 */
function wptgcl_register_product_class() {
	if ( ! class_exists( 'Wptgcl_Product_WC_Gift_Card' ) ) {
		
		class Wptgcl_Product_WC_Gift_Card extends WC_Product {
			
			/**
			 * Constructor for Gift Card Product.
			 *
			 * @param mixed $product
			 */
			public function __construct( $product ) {
				$product_type = 'wptgcl_gift_card';
				isset( $this->product_type ) ? $this->product_type : $product_type;
				parent::__construct( $product );
			}

			/**
			 * Returns product type
			 */
			public function get_type() {
				return 'wptgcl_gift_card';
			}

			// Make the product purchasable
			public function is_purchasable() {
				return true;
			}

			// Enable add to cart functionality
			public function add_to_cart_url() {
				$url = $this->is_purchasable() && $this->is_in_stock() ? remove_query_arg('added-to-cart', add_query_arg('add-to-cart', $this->id)) : get_permalink($this->id);
				return apply_filters('woocommerce_product_add_to_cart_url', $url, $this);
			}

				// Set add to cart text
			public function add_to_cart_text() {
				$text = $this->is_purchasable() && $this->is_in_stock() && !$this->is_sold_individually() ? __('Add to cart','wptrivo-gift-cards-lite') : __('Read more','wptrivo-gift-cards-lite');
				return apply_filters('woocommerce_product_add_to_cart_text', $text, $this);
			}

			// Make sure the product can be added to cart
			public function is_sold_individually() {
				return apply_filters('woocommerce_is_sold_individually', false, $this);
			}

			// Set the product as virtual by default (since it's a gift card)
			public function is_virtual() {
				return true;
			}
		}
	}
}


/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wptrivo_gift_cards_lite() {

	$plugin = new Wptgcl_Wptrivo_Gift_Cards_Lite();
	$plugin->run();

}
run_wptrivo_gift_cards_lite();
