(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	
	const { __ } = wp.i18n;
	jQuery(document).ready(function($) {
		// Preview functionality
		$('#wptgcl_preview_gift_card').on('click', function() {
			let selected_temp_id = $('#wptgcl_selected_temp').val();
			let product_id = $('.single_add_to_cart_button').val();
			if( !selected_temp_id){
				alert( __("Please select a template for preview.", "wptrivo-gift-cards-lite"));
				return false;
			}
			var formData = {
				'action': 'wptgcl_preview_gift_card',
				'product_id': product_id,
				'template_id': selected_temp_id,
				'message': $('#wptgcl_message').val(),
				'from_name': $('#wptgcl_from_name').val(),
				'to_name': $('#wptgcl_to_name_optional').val(),
				'price': $('#wptgcl_price').val() || $('#wptgcl_variable_price').val(),
				'nonce': wptgcl_public_ajax_obj.nonce
			};
			$.post(wptgcl_public_ajax_obj.ajax_url, formData, function(response) {
				if (response.success) {
					// Open preview in modal or new window
					var previewWindow = window.open('', '_blank', 'width=800,height=600');
					previewWindow.document.write(response.data.html);
					previewWindow.document.close();
				}
			});
		});


		// Validate form before submission
		$('.single_add_to_cart_button').on('click', function(e) {
			var selected_temp_ids = $('#wptgcl_selected_temp');
			var pricingType =  $('#wptgcl_price_type_frm').val();
			var sender = $('#wptgcl_from_name');
			var recipient = $('#wptgcl_to_email');
			
			// Check price for custom/range pricing
			if ((pricingType === 'range' || pricingType === 'custom') && $('#wptgcl_price').val() === '') {
				e.preventDefault();
				alert( __("Please enter a price.", "wptrivo-gift-cards-lite"));
				return false;
			}

			// for the min and max..

			if (pricingType === 'range') {
				let $input = $('#wptgcl_price');
				let value  = parseFloat($input.val());
				let min    = parseFloat($input.attr('min'));
				let max    = parseFloat($input.attr('max'));

				if (isNaN(value) || value < min || value > max) {
					e.preventDefault();
					alert(
						__("Please enter a price between ", "wptrivo-gift-cards-lite") 
						+ min + " and " + max + "."
					);
					$input.focus();
					return false;
				}
			}
			
			// check sender name
			if (sender.val() === '') {
				e.preventDefault();
				alert( __("Sender name is required.", "wptrivo-gift-cards-lite"));
				sender.focus();
				return false;
			}

			// check recipient mail.
			if ($('input[name="wptgcl_send_giftcard"]:checked').val() === 'Mail to recipient' && recipient.val() === '') {
				e.preventDefault();
				alert( __("Recipient email is required.", "wptrivo-gift-cards-lite"));
				recipient.focus();
				return false;
			}

			if( selected_temp_ids.val()=== ''){
				e.preventDefault();
				alert( __("Please select a template.", "wptrivo-gift-cards-lite"));
				selected_temp_ids.focus();
				return false;
			}

			if (pricingType === 'variable' && $('#wptgcl_variable_price').val() === '') {
				e.preventDefault();
				alert( __("Please select a price.", "wptrivo-gift-cards-lite"));
				return false;
			}
			
		});
		

			// Template selection
		$(document).on('click', '.wptgcl_template_img', function() {
			$('.wptgcl_template_img').removeClass('wptgcl_selected');
			$(this).addClass('wptgcl_selected');
			$('#wptgcl_selected_temp').val($(this).data('template-id'));
		});

		// Show/hide email fields based on delivery method
		$('input[name="wptgcl_send_giftcard"]').change(function() {
			if ($(this).val() === 'Mail to recipient') {
				$('.wptgcl_delivery_via_email').show();
				$('#wptgcl_to_email').attr('required', true);
			} else {
				$('.wptgcl_delivery_via_email').hide();
				$('#wptgcl_to_email').attr('required', false);
			}
		});

		// Character counter for message
		$('#wptgcl_message').on('keyup', function() {
			var length = $(this).val().length;
			$('#wptgcl_char').text(length);
			
			if (length > 100) {
				$(this).val($(this).val().substring(0, 100));
				$('#wptgcl_char').text(100);
			}
		});
		
		// Initialize datepicker
		$('#wptgcl_send_date').datepicker({
			dateFormat: 'yy-mm-dd',
			minDate: 0, // Today or future dates only
			changeMonth: true,
			changeYear: true
		});
	});

})( jQuery );
