<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://wptrivo.com/
 * @since      1.0.0
 *
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/includes
 */

/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/includes
 * @author     wptrivo <dev@wptrivo.com>
 */
class Wptgcl_Wptrivo_Gift_Cards_Lite {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Wptgcl_Wptrivo_Gift_Cards_Lite_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'WPTGCL_WPTRIVO_GIFT_CARDS_LITE_VERSION' ) ) {
			$this->version = WPTGCL_WPTRIVO_GIFT_CARDS_LITE_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'wptrivo-gift-cards-lite';

		$this->load_dependencies();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Wptgcl_Wptrivo_Gift_Cards_Lite_Loader. Orchestrates the hooks of the plugin.
	 * - Wptgcl_Wptrivo_Gift_Cards_Lite_i18n. Defines internationalization functionality.
	 * - Wptgcl_Wptrivo_Gift_Cards_Lite_Admin. Defines all hooks for the admin area.
	 * - Wptgcl_Wptrivo_Gift_Cards_Lite_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wptrivo-gift-cards-lite-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wptrivo-gift-cards-lite-i18n.php';

		// for the general functions..
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/wptrivo-gift-cards-lite-general-functions.php';
		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */ 
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-wptrivo-gift-cards-lite-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-wptrivo-gift-cards-lite-public.php';

		$this->loader = new Wptgcl_Wptrivo_Gift_Cards_Lite_Loader();

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Wptgcl_Wptrivo_Gift_Cards_Lite_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );

		$this->loader->add_action( 'admin_menu', $plugin_admin, 'wpgcwl_add_admin_menu' );
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'wpgcwl_restrinction_to_add_cpt' );
		$this->loader->add_filter( 'wp_insert_post_data', $plugin_admin, 'wptgcl_brk_tmplt_acnts',10, 2 );
		$this->loader->add_action( 'admin_init', $plugin_admin, 'wptgcL_register_settings' );
		$this->loader->add_filter( 'product_type_selector', $plugin_admin, 'wptgcl_add_gift_card_type_selector' );
		$this->loader->add_action( 'woocommerce_product_options_general_product_data', $plugin_admin, 'add_gift_card_nonce_field' );

		$this->loader->add_filter( 'woocommerce_product_class',$plugin_admin, 'wptgcl_woocommerce_product_class', 10, 2 ); 
		$this->loader->add_action( 'woocommerce_product_options_general_product_data', $plugin_admin, 'wptgcl_add_gift_card_custom_fields');
		$this->loader->add_action( 'save_post_product', $plugin_admin, 'wptgcl_set_product_type');

		$this->loader->add_action( 'woocommerce_admin_process_product_object', $plugin_admin, 'wptgcl_save_product_data');
		// $this->loader->add_action( 'admin_footer', $plugin_admin, 'wptgcl_show_price_fields');

		$this->loader->add_action('init', $plugin_admin, 'wptgcl_register_template_post_type');
		$this->loader->add_action( 'woocommerce_product_query', $plugin_admin, 'wptgcl_include_gift_cards_in_shop' );

	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Wptgcl_Wptrivo_Gift_Cards_Lite_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

		$this->loader->add_filter( 'woocommerce_get_item_data', $plugin_public, 'wptgcl_display_gift_card_data_in_cart',10,2);
		$this->loader->add_filter( 'woocommerce_is_purchasable', $plugin_public, 'wptgcl_set_gift_card_prdct_purchasable',10,2);
		$this->loader->add_filter( 'woocommerce_get_price_html', $plugin_public, 'wptgcl_set_gift_card_prdct_price',10,2);
		$this->loader->add_filter( 'woocommerce_product_supports', $plugin_public, 'gift_card_product_supports',10,3);
		$this->loader->add_action('woocommerce_wptgcl_gift_card_add_to_cart',$plugin_public, 'wptgcl_gift_card_add_to_cart_template');

		$this->loader->add_action('woocommerce_before_add_to_cart_button',$plugin_public, 'wptgcl_add_gift_card_frontend_fields');

		$this->loader->add_filter('woocommerce_add_cart_item_data', $plugin_public, 'wptgcl_add_gift_card_data_to_cart', 10, 3);

		$this->loader->add_action('woocommerce_before_calculate_totals', $plugin_public, 'wptgcl_update_gift_card_price_cart');

		$this->loader->add_action('wp_ajax_wptgcl_preview_gift_card', $plugin_public, 'wptgcl_handle_preview_gift_card');
		$this->loader->add_action('wp_ajax_nopriv_wptgcl_preview_gift_card', $plugin_public, 'wptgcl_handle_preview_gift_card');

		$this->loader->add_action('woocommerce_checkout_create_order_line_item', $plugin_public, 'wptgcl_save_gift_card_data_to_order', 10, 4);

		$this->loader->add_action('woocommerce_order_status_completed', $plugin_public, 'wptgcl_create_gift_card_on_order_complete');
		$this->loader->add_action('wptgcl_send_gift_card_email', $plugin_public, 'wptgcl_send_scheduled_gift_card_emails_cb');

		$this->loader->add_action('woocommerce_applied_coupon', $plugin_public, 'wptgcl_track_gift_card_usage');

		$this->loader->add_action( 'woocommerce_new_order', $plugin_public, 'wptgcl_process_gift_card_usage', 10, 1 );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Wptgcl_Wptrivo_Gift_Cards_Lite_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
