<?php

/**
 * Fired during plugin activation
 *
 * @link       https://wptrivo.com/
 * @since      1.0.0
 *
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/includes
 */

/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/includes
 * @author     wptrivo <dev@wptrivo.com>
 */
class Wptgcl_Wptrivo_Gift_Cards_Lite_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		$Wptgcl_default_options = array(
			'enable_gift_crds_settng'           => 1,
			'enable_shp_pg_listing_settng'      => 1,
			'enable_gift_crds_indivdul'         => 1,
			'exclude_sale_itms'                 => 0,
			'gift_card_code_len'                => 7,
			'gift_card_pre'                     => 'wptgcl',
			'gift_card_free_shipping'           => 0,
			'wptgcl_gift_crds_exp_dys'           => 0,
			'gift_card_min_spnd'                => '',
			'gift_card_max_spnd'                => '',
			'gift_crd_email_sub'                => 'Your Gift Card is Ready!',
			'gift_card_usage_limit'             => 1,
			'gift_card_usage_limit_per_user'    => 1,
			'gift_card_limit_usage_x_items'     => '',
		);

		// Get existing options (if any)
		$Wptgcl_existing_options = get_option( 'wptgcl_general_settings_opt' );

		if ( false === $Wptgcl_existing_options ) {
			add_option( 'wptgcl_general_settings_opt', $Wptgcl_default_options );
		} else {
			$merged = wp_parse_args( $Wptgcl_existing_options, $Wptgcl_default_options );
			update_option( 'wptgcl_general_settings_opt', $merged );
		}

		// Create default templates if they don't exist
		$wptgcl_templates = get_posts(array(
			'post_type' => 'wptgcl_template',
			'posts_per_page' => 1
		));
		
		if (empty($wptgcl_templates)) {
			wptgcl_create_default_templates();
		}
		
		// Flush rewrite rules
		flush_rewrite_rules();

	}

}
