<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wptrivo.com/
 * @since      1.0.0
 *
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/admin/partials
 */

/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->

 <?php
 $wptgcl_general_settings = '';
  $wptgcl_shortcodes = '';

 $wptgcl_tab = isset( $_GET['wptgcl_tab'] )? $_GET['wptgcl_tab']: 'wptgcl_general_settings';  // phpcs:ignore
 if ( isset( $wptgcl_tab ) ) 
{
    if ( $wptgcl_tab == "wptgcl_general_settings") 
	{
		$wptgcl_general_settings = "nav-tab-active";
	}
	if ( $wptgcl_tab == "wptgcl_shortcodes") 
	{
		$wptgcl_shortcodes = "nav-tab-active";
	}
}
 ?>

<div class="main-wrapper">
	<div class="wptgcl_admin_wrapper">
		<h2 class="wpt-main-heading">
			<span><?php echo esc_html__('Wptrivo Gift Cards for Woocommerce Lite','wptrivo-gift-cards-lite');?></span>
		</h2>

		<div class="wptgcl-settings-container">
			<!-- Sidebar Tabs -->
			<nav class="wptgcl-vertical-tabs">
				<a class="wptgcl-tab <?php echo esc_attr( $wptgcl_general_settings );?>" 
				   href="<?php echo esc_url( admin_url('admin.php?page=wptgcl_gift_cards_lite&wptgcl_tab=wptgcl_general_settings') ); ?>">
					<?php echo esc_html__('General Settings','wptrivo-gift-cards-lite');?>
				</a>

				<a class="wptgcl-tab <?php echo esc_attr( $wptgcl_shortcodes );?>" 
				   href="<?php echo esc_url( admin_url('admin.php?page=wptgcl_gift_cards_lite&wptgcl_tab=wptgcl_shortcodes') ); ?>">
					<?php echo esc_html__('Shortcodes','wptrivo-gift-cards-lite');?>
				</a>
			</nav>

			<!-- Content Area -->
			<div class="wptgcl-tab-content">
				<?php
				if ($wptgcl_tab === "wptgcl_general_settings") {
                    ?>
                    <p class="wptgcl-menu-heading"> <?php echo esc_html__('General Settings','wptrivo-gift-cards-lite');?></p>
                    <?php
					include_once(WPTGCL_PLUGIN_DIR_PATH.'/admin/partials/wptgcl_setting_tabs/wptgcl_general_settings.php');
				} elseif ($wptgcl_tab === "wptgcl_shortcodes") {
                    ?>
                    <p class="wptgcl-menu-heading"> <?php echo esc_html__('Shortcodes','wptrivo-gift-cards-lite');?></p>
                    <?php
					include_once(WPTGCL_PLUGIN_DIR_PATH.'/admin/partials/wptgcl_setting_tabs/wptgcl_shortcodes.php');
				} else {
					include_once(WPTGCL_PLUGIN_DIR_PATH.'/admin/partials/wptgcl_setting_tabs/wptgcl_general_settings.php');
				}
				?>
			</div>
		</div>
	</div>
</div>
