<?php

/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if (isset($_POST['resend_email_lite'], $_POST['_wpnonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ) ), 'resend_gift_card_lite_email' ) ) {
        $coupon_id = isset( $_POST['coupon_id'] )? intval($_POST['coupon_id']): '';
        if( $coupon_id ){

            if ( wptgcl_send_gift_card_email($coupon_id) ) {
                echo '<div class="notice notice-success"><p>Email sent successfully!</p></div>';
            } else {
                echo '<div class="notice notice-error"><p>Failed to send email.</p></div>';
            }
        }
        
    }
    
    // Get all gift cards
    $args = array(
        'post_type' => 'shop_coupon',
        'meta_query' => array( // phpcs:ignore
            array(
                'key' => '_wptgcl_is_gift_card',
                'value' => 'yes'
            )
        ),
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'DESC'
    );
    
    $gift_cards = get_posts($args);
   
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Gift Cards List','wptrivo-gift-cards-lite')?></h1>
        
        <table class="wp-list-table widefat fixed striped">
            <thead>
                
                <?php 
                if( !empty($gift_cards ) ){
                    ?>
                <tr>
                    <th><?php esc_html_e( 'Code','wptrivo-gift-cards-lite')?></th>
                    <th> <?php esc_html_e( 'Amount','wptrivo-gift-cards-lite')?></th>
                    <th> <?php esc_html_e( 'Status','wptrivo-gift-cards-lite')?></th>
                    <th> <?php esc_html_e( 'From','wptrivo-gift-cards-lite')?></th>
                    <th> <?php esc_html_e( 'To','wptrivo-gift-cards-lite')?></th>
                    <th> <?php esc_html_e( 'Created','wptrivo-gift-cards-lite')?></th>
                    <th> <?php esc_html_e( 'Actions','wptrivo-gift-cards-lite')?></th>
                </tr>
                <?php
                }else{
                    ?>
                    <p class="no-gift-cards"> <?php esc_html_e( 'Coupons cards are not generated yet.','wptrivo-gift-cards-lite')?></p>
                    <?php
                }
                ?>
            </thead>
            <tbody>
                <?php 
                if( !empty($gift_cards ) ){
                    foreach ($gift_cards as $gift_card) : 
                        $code = get_post_meta($gift_card->ID, '_wptgcl_coupon_code', true);
                        $coupon = new WC_Coupon( $code );
		                $coupon_id = $coupon->get_id();
                        $amount = get_post_meta($gift_card->ID, '_wptgcl_gift_card_amount', true);
                        $remaining = get_post_meta($gift_card->ID, '_wptgcl_remaining_amount', true);
                        $from_name = get_post_meta($gift_card->ID, '_wptgcl_from_name', true);
                        $to_email = get_post_meta($gift_card->ID, '_wptgcl_to_email', true);
                        $email_sent = get_post_meta($gift_card->ID, '_wptgcl_email_sent', true);
                        $current_amount = $remaining ?: $amount;
                        
                        $status = $gift_card->post_status == 'publish' ? 'Active' : 'Used/Expired';
                        if ($remaining && $remaining > 0) {
                            $status .= " ({$remaining} left)";
                        }
                    ?>
                    <tr>
                        <td><strong><?php echo esc_html($code); ?></strong></td>
                        <td><?php echo wc_price($amount); ?><?php if ($remaining && $remaining != $amount) echo '<br><small>Current: ' . wc_price($current_amount) // phpcs:ignore
                        . '</small>'; ?></td> 
                        <td><?php echo esc_html($status); ?></td>
                        <td><?php echo esc_html($from_name); ?></td>
                        <td><?php echo esc_html($to_email); ?></td> 
                        <td><?php echo esc_html( wp_date('Y-m-d H:i', strtotime($gift_card->post_date)) ); ?></td>
                        <td>
                            <form method="post" style="display: inline;">
                                <?php wp_nonce_field('resend_gift_card_lite_email'); ?>
                                <input type="hidden" name="coupon_id" value="<?php echo esc_attr( $gift_card->ID ); ?>">
                                <button type="submit" name="resend_email_lite" class="button button-small"> <?php esc_html_e( 'Resend Email','wptrivo-gift-cards-lite')?></button>
                            </form>
                            <a href="<?php echo esc_url( admin_url('post.php?post=' . $gift_card->ID . '&action=edit') ); ?>" class="button button-small"> <?php esc_html_e( 'Edit','wptrivo-gift-cards-lite')?></a>
                        </td>
                    </tr>
                    <?php endforeach; 
                }
                ?>
            </tbody>
        </table>
    </div>
<?php