<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://www.wptrivo.com
 * @since      1.0.0
 *
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/admin/partials/wptgcl_setting_tabs
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<!-- Gift Card Shortcodes Reference -->
<div class="giftcard-shortcodes-table">
    <table class="wp-list-table widefat fixed striped">
    <thead>
        <tr>
        <th style="width:25%"><?php echo esc_html__( 'Shortcode / Placeholder', 'wptrivo-gift-cards-lite' )?></th>
        <th style="width:45%"> <?php echo esc_html__( 'Description', 'wptrivo-gift-cards-lite' )?></th>
        <th style="width:30%"> <?php echo esc_html__( 'Context', 'wptrivo-gift-cards-lite' )?></th>
        </tr>
    </thead>
    <tbody>
        <!-- Product Listing Shortcode -->
        <tr>
        <td><code> <?php echo esc_html__( '[wptgcl_gift_card_products]', 'wptrivo-gift-cards-lite' )?></code></td>
        <td> <?php echo esc_html__( 'Displays all available gift card products in a grid/list on a page or post.', 'wptrivo-gift-cards-lite' )?></td>
        <td> <?php echo esc_html__( 'Page / Post', 'wptrivo-gift-cards-lite' )?></td>
        </tr>

        <!-- Email Template Placeholders -->
        <tr>
        <td><code> <?php echo esc_html__( '{to_name}', 'wptrivo-gift-cards-lite' )?></code></td>
        <td><?php echo esc_html__( 'Outputs the recipient`s name entered during purchase. ', 'wptrivo-gift-cards-lite' )?></td>
        <td> <?php echo esc_html__( 'Email Template', 'wptrivo-gift-cards-lite' )?></td>
        </tr>
        <tr>
        <td><code> <?php echo esc_html__( '{amount}', 'wptrivo-gift-cards-lite' )?></code></td>
        <td> <?php echo esc_html__( 'Displays the gift card amount with currency formatting.', 'wptrivo-gift-cards-lite' )?></td>
        <td> <?php echo esc_html__( 'Email Template', 'wptrivo-gift-cards-lite' )?></td>
        </tr>
        <tr>
        <td><code> <?php echo esc_html__( '{from_name}', 'wptrivo-gift-cards-lite' )?></code></td>
        <td><?php echo esc_html__( 'Shows the sender’s name as provided during purchase. ', 'wptrivo-gift-cards-lite' )?></td>
        <td><?php echo esc_html__( 'Email Templatev', 'wptrivo-gift-cards-lite' )?></td>
        </tr>
        <tr>
        <td><code> <?php echo esc_html__( '{message}', 'wptrivo-gift-cards-lite' )?></code></td>
        <td> <?php echo esc_html__( 'Personal message written by the buyer for the recipient.', 'wptrivo-gift-cards-lite' )?></td>
        <td> <?php echo esc_html__( 'Email Template', 'wptrivo-gift-cards-lite' )?></td>
        </tr>
        <tr>
        <td><code> <?php echo esc_html__( '{coupon_code}', 'wptrivo-gift-cards-lite' )?></code></td>
        <td> <?php echo esc_html__( 'Renders the actual gift card code that the recipient can redeem.', 'wptrivo-gift-cards-lite' )?></td>
        <td> <?php echo esc_html__( 'Email Template', 'wptrivo-gift-cards-lite' )?></td>
        </tr>
        <tr>
        <td><code> <?php echo esc_html__( '{featured_image}', 'wptrivo-gift-cards-lite' )?></code></td>
        <td> <?php echo esc_html__( 'Displays the selected gift card template image (featured image).', 'wptrivo-gift-cards-lite' )?></td>
        <td> <?php echo esc_html__( 'Email Template', 'wptrivo-gift-cards-lite' )?></td>
        </tr>
        <tr>
        <td><code> <?php echo esc_html__( '{exp_date}', 'wptrivo-gift-cards-lite' )?></code></td>
        <td> <?php echo esc_html__( 'Shows the gift card expiration date, or "Infinite" if no expiry.', 'wptrivo-gift-cards-lite' )?></td>
        <td> <?php echo esc_html__( 'Email Template', 'wptrivo-gift-cards-lite' )?></td>
        </tr>
    </tbody>
    </table>
</div>
