<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://www.wptrivo.com
 * @since      1.0.0
 *
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/admin/partials/wptgcl_setting_tabs
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
$wptgcl_option_name = get_option('wptgcl_general_settings_opt',array() );
?>

<form action="options.php" method="post"> 
    <?php

    settings_errors();
    settings_fields('wptgcl_general_settings_grp');
  ?>
    <table class="wp-list-table form-table wptgcl-table">
        <tbody>
            <tr>
                <th class="descr"><?php esc_html_e( 'Enable Gift Cards', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="checkbox" name="wptgcl_general_settings_opt[enable_gift_crds_settng]" value="1" <?php  if(isset($wptgcl_option_name['enable_gift_crds_settng']) && $wptgcl_option_name['enable_gift_crds_settng']==1){ echo 'checked=checked';} ?>/>
                    <div class="descr"><?php esc_html_e( 'Check it to enable gift cards settings.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>
            <tr>
                <th class="descr"><?php esc_html_e( 'Enable shop page listing', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="checkbox" name="wptgcl_general_settings_opt[enable_shp_pg_listing_settng]" value="1" <?php checked( ! empty($wptgcl_option_name['enable_shp_pg_listing_settng']), 1 ); ?>/>
                    <div class="descr"><?php esc_html_e( 'Check it to enable gift card products listing on the shop page.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>

            <tr>
                <th class="descr"><?php esc_html_e( 'Enable Individual Use', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="checkbox" name="wptgcl_general_settings_opt[enable_gift_crds_indivdul]" value="1" <?php checked( ! empty($wptgcl_option_name['enable_gift_crds_indivdul']), 1 ); ?>/>
                    <div class="descr"><?php esc_html_e( 'Check it to enable individual use of the coupon.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>

            <tr>
                <th class="descr"><?php esc_html_e( 'Exclude Sale items', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="checkbox" name="wptgcl_general_settings_opt[exclude_sale_itms]" value="1" <?php checked( ! empty($wptgcl_option_name['exclude_sale_itms']), 1 ); ?>/>
                    <div class="descr"><?php esc_html_e( 'Check it to disable coupon code if sale item is in the cart.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>
            <tr>
                <th class="descr"><?php esc_html_e( 'Gift card length', 'wptrivo-gift-cards-lite' ); ?></th>
                <?php

                    $gift_card_code_len = isset($wptgcl_option_name['gift_card_code_len']) ? $wptgcl_option_name['gift_card_code_len'] : 7;
                ?>
                <td class="descr_2">
                    <input type="number" name="wptgcl_general_settings_opt[gift_card_code_len]" value="<?php  echo esc_attr( $gift_card_code_len ) ?>"/>
                    <div class="descr"><?php esc_html_e( 'Set length of the gift card code. ', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>
            <tr>
                <th class="descr"><?php esc_html_e( 'Gift card prefix', 'wptrivo-gift-cards-lite' ); ?></th>
                <?php

                    $wptgcl_gift_card_pre = isset($wptgcl_option_name['gift_card_pre']) ? $wptgcl_option_name['gift_card_pre'] : 'wptgcl';
                ?>
                <td class="descr_2">
                    <input type="text" name="wptgcl_general_settings_opt[gift_card_pre]" value="<?php  echo esc_attr($wptgcl_gift_card_pre) ?>"/>
                    <div class="descr"><?php esc_html_e( 'Set prefix for the gift card.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>
            <!-- below is the wpld -->

            <tr>
                <th class="descr"><?php esc_html_e( 'Allow Free Shipping', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="checkbox" name="wptgcl_general_settings_opt[gift_card_free_shipping]" value="1" 
                        <?php if(isset($wptgcl_option_name['gift_card_free_shipping']) && $wptgcl_option_name['gift_card_free_shipping']==1){ echo 'checked=checked'; } ?> />
                    <div class="descr"><?php esc_html_e( 'Check this to allow the coupon to grant free shipping.', 'wptrivo-gift-cards-lite' ); ?></div>
                </td>
            </tr>

            <tr>
                <th class="descr"><?php esc_html_e( 'Gift cards expiry days', 'wptrivo-gift-cards-lite' ); ?></th>
                <?php $wptgcl_gift_crds_exp_dys = isset($wptgcl_option_name['wptgcl_gift_crds_exp_dys'] ) ? $wptgcl_option_name['wptgcl_gift_crds_exp_dys'] : 0 ?>
                <td class="descr_2">
                    <input type="number" name="wptgcl_general_settings_opt[wptgcl_gift_crds_exp_dys]" value="<?php echo esc_attr( $wptgcl_gift_crds_exp_dys ) ?>"  min='0'/>
                    <div class="descr"><?php esc_html_e( 'You can set expiry days for the gift cards.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>
            <!-- extraaa -->

            <tr>
                <th class="descr"><?php esc_html_e( 'Enter Min. and Max. use', 'wptrivo-gift-cards-lite' ); ?></th>
                <?php

                    $gift_card_min_spnd = isset($wptgcl_option_name['gift_card_min_spnd']) ? $wptgcl_option_name['gift_card_min_spnd'] : '';
                    $gift_card_max_spnd = isset($wptgcl_option_name['gift_card_max_spnd']) ? $wptgcl_option_name['gift_card_max_spnd'] : '';
                ?>
                <td class="descr_2">
                    <span id="wptgcl_min_max_inpt">
                        <input type="number" name="wptgcl_general_settings_opt[gift_card_min_spnd]" value="<?php  echo esc_attr( $gift_card_min_spnd ) ?>"/>
                        <input type="number" name="wptgcl_general_settings_opt[gift_card_max_spnd]" value="<?php  echo esc_attr( $gift_card_max_spnd ) ?>"/>
                    </span>
                    <div class="descr"><?php esc_html_e( 'Set Minimum and Maximum spend of the Gift card coupon.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>
            <!-- another extra fields.. -->
            <tr>
                <th class="descr"><?php esc_html_e( 'Email Subject', 'wptrivo-gift-cards-lite' ); ?></th>
                <?php

                    $gift_crd_email_sub = isset($wptgcl_option_name['gift_crd_email_sub']) ? $wptgcl_option_name['gift_crd_email_sub'] : 'Your Gift Card is Ready!';
                ?>
                <td class="descr_2">
                    <input type="text" name="wptgcl_general_settings_opt[gift_crd_email_sub]" value="<?php  echo esc_attr($gift_crd_email_sub) ?>"/>
                    <div class="descr"><?php esc_html_e( 'Set the subject for the gift card email.', 'wptrivo-gift-cards-lite' );?></div>
                </td>
            </tr>
            <tr>
                <th class="descr"><?php esc_html_e( 'Usage Limit', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="number" name="wptgcl_general_settings_opt[gift_card_usage_limit]" 
                        value="<?php echo isset($wptgcl_option_name['gift_card_usage_limit']) ? esc_attr($wptgcl_option_name['gift_card_usage_limit']) : 1; ?>" />
                    <div class="descr"><?php esc_html_e( 'Maximum number of times this coupon can be used in total.', 'wptrivo-gift-cards-lite' ); ?></div>
                </td>
            </tr>

            <tr>
                <th class="descr"><?php esc_html_e( 'Usage Limit Per User', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="number" name="wptgcl_general_settings_opt[gift_card_usage_limit_per_user]" 
                        value="<?php echo isset($wptgcl_option_name['gift_card_usage_limit_per_user']) ? esc_attr($wptgcl_option_name['gift_card_usage_limit_per_user']) : 1; ?>" />
                    <div class="descr"><?php esc_html_e( 'Maximum number of times this coupon can be used by each individual user.', 'wptrivo-gift-cards-lite' ); ?></div>
                </td>
            </tr>

            <tr>
                <th class="descr"><?php esc_html_e( 'Limit Usage to X Items', 'wptrivo-gift-cards-lite' ); ?></th>
                <td class="descr_2">
                    <input type="number" name="wptgcl_general_settings_opt[gift_card_limit_usage_x_items]" 
                        value="<?php echo isset($wptgcl_option_name['gift_card_limit_usage_x_items']) ? esc_attr($wptgcl_option_name['gift_card_limit_usage_x_items']) : ''; ?>" />
                    <div class="descr"><?php esc_html_e( 'The maximum number of items the coupon can be applied to when using product discounts.', 'wptrivo-gift-cards-lite' ); ?></div>
                </td>
            </tr>
        </tbody>
    </table>
    <p class="submit">
            <?php
            submit_button('Save Changes', 'wbd-button');
            ?>
        </p>
</form> 
