(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	jQuery(document).ready(function($){
		$('select[name="_wptgcl_allowed_templates[]"]').select2({
			width: '100%',
			multiple: true
		});
	});

	jQuery(document).ready(function($) {
		function toggleGiftCardFields() {
			var type = $('#_wptgcl_pricing_type').val();

			// Hide all conditional sections first
			$('.show_if_wptgcl_fixed, .show_if_wptgcl_range, .show_if_wptgcl_variable').hide();

			// Show only relevant ones
			if (type === 'fixed') {
				$('.show_if_wptgcl_fixed').show();
			} else if (type === 'range') {
				$('.show_if_wptgcl_range').show();
			} else if (type === 'variable') {
				$('.show_if_wptgcl_variable').show();
			}
		}

		// Listen for select change
		$('#_wptgcl_pricing_type').on('change', toggleGiftCardFields);

		// Trigger on page load
		toggleGiftCardFields();
	});


})( jQuery );
