<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://wptrivo.com/
 * @since      1.0.0
 *
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/admin
 */

/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Wptrivo_Gift_Cards_Lite
 * @subpackage Wptrivo_Gift_Cards_Lite/admin
 * @author     wptrivo <dev@wptrivo.com>
 */
class Wptgcl_Wptrivo_Gift_Cards_Lite_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wptgcl_Wptrivo_Gift_Cards_Lite_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wptgcl_Wptrivo_Gift_Cards_Lite_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/wptrivo-gift-cards-lite-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wptgcl_Wptrivo_Gift_Cards_Lite_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wptgcl_Wptrivo_Gift_Cards_Lite_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( 'wc-select2', WPTGCL_PLUGIN_DIR_URL . 'vendor/wptrivo-gift-cards-lite-select2.js', array(), $this->version,false );
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/wptrivo-gift-cards-lite-admin.js', array( 'jquery', 'wc-select2' ), $this->version, false );

	}


	
	/**
	 * Add menu page of the plugin settings.
	 *
	 * @since    1.0.0
	 */
	public function wpgcwl_add_admin_menu(){
		add_menu_page( 'Wptrivo Gift cards Lite', 'WPTrivo Gift Cards Lite', 'manage_options', 'wptgcl_gift_cards_lite',array( $this, 'wptgcl_admin_menu_cb' ));
		add_submenu_page(
			'wptgcl_gift_cards_lite',
			'Gift Cards Coupon',
			'Gift Cards Coupon',
			'manage_options',
			'wptgcl-gift-cards-coupon',
			array( $this,'wptgcl_gift_card_coupons_cb')
    	);

	}

	/**
	 * Callback method to render the plugin settings.
	 *
	 * @since    1.0.0
	 */
	public function wptgcl_admin_menu_cb(){
		require_once WPTGCL_PLUGIN_DIR_PATH . 'admin/partials/wptrivo-gift-cards-lite-admin-display.php';
	}

	public function wptgcl_gift_card_coupons_cb(){
		require_once WPTGCL_PLUGIN_DIR_PATH . 'admin/partials/wptrivo-gift-cards-lite-admin-display-coupon.php';
	}

	/**
	 * Register settings for the plugin.
	 *
	 * @since    1.0.0
	 */
	public function wptgcL_register_settings(){

		register_setting('wptgcl_general_settings_grp','wptgcl_general_settings_opt',  array(
            'sanitize_callback' => array($this, 'wptgcl_general_settings_callback'),
        ));
	}

	/**
	 * Add custom product type selector.
	 *
	 * @since    1.0.0
	 * @param array $types
	 * @return array
	 */
	public function wptgcl_add_gift_card_type_selector( $types ){

		$wptgcl_gnrl_opt_settings = get_option('wptgcl_general_settings_opt', array());
		if( isset( $wptgcl_gnrl_opt_settings['enable_gift_crds_settng'] ) && empty( $wptgcl_gnrl_opt_settings['enable_gift_crds_settng'] ) ){
			return $types;

		}
		$types['wptgcl_gift_card'] = __( 'Gift Card', 'wptrivo-gift-cards-lite' );
    	return $types;

	}

	public function add_gift_card_nonce_field() {
		wp_nonce_field(
			'wptgcl_set_product_type_action',
			'wptgcl_product_type_nonce'
		);
	}


	/**
	 * Map product type to custom class
	 * @since    1.0.0
	 */
	public function wptgcl_woocommerce_product_class( $wptgcl_classname, $product_type ) {
		if ( $product_type === 'wptgcl_gift_card' ) {
			$wptgcl_classname = 'Wptgcl_Product_WC_Gift_Card';
		}
		return $wptgcl_classname;
	}

	/**
	 * Add custom fields for Gift Card product type
	 * @since    1.0.0
	 */
	public function wptgcl_add_gift_card_custom_fields() {
		global $post;

		$wptgcl_gnrl_opt_settings = get_option('wptgcl_general_settings_opt', array());
		if( isset( $wptgcl_gnrl_opt_settings['enable_gift_crds_settng'] ) && empty( $wptgcl_gnrl_opt_settings['enable_gift_crds_settng'] ) ){
			return;

		}
		// Get available templates
		$templates = get_posts(array(
			'post_type' => 'wptgcl_template',
			'posts_per_page' => -1,
			'meta_query' => array( // phpcs:ignore
				array(
					'key' => '_wptgcl_is_active',
					'value' => 'yes'
				)
			),
			'orderby' => 'title',
			'order' => 'ASC'
		));
		
		$selected_templates = get_post_meta($post->ID, '_wptgcl_allowed_templates', true);
		if (!is_array($selected_templates)) {
			$selected_templates = array();
		}
		echo '<div class="options_group show_if_wptgcl_gift_card" id="wptgcl_gift_card_options">';

		// Gift Card Value
		woocommerce_wp_text_input(
			array(
				'id'          => '_wptgcl_gift_card_value_default',
				'label'       => __( 'Gift Card Value', 'wptrivo-gift-cards-lite' ),
				'placeholder' => 'e.g. 50',
				'desc_tip'    => true,
				'description' => __( 'Enter the value of the gift card.', 'wptrivo-gift-cards-lite' ),
				'type'        => 'number',
				'custom_attributes' => array(
					'step' => 'any',
					'min'  => '0',
				),
			)
		);

		// Pricing Type (fixed, range, custom, variable)
		woocommerce_wp_select( [
			'id'      => '_wptgcl_pricing_type',
			'label'   => __( 'Pricing Type', 'wptrivo-gift-cards-lite' ),
			'options' => [
				// 'fixed'   => __( 'Fixed', 'wptrivo-gift-cards-lite' ),
				'default'   => __( 'Default', 'wptrivo-gift-cards-lite' ),
				'range'   => __( 'Price Range', 'wptrivo-gift-cards-lite' ),
				'custom'  => __( 'Customer Defined', 'wptrivo-gift-cards-lite' ),
				'variable'=> __( 'Variable Options', 'wptrivo-gift-cards-lite' ),
			],
		] );
		// Price Range
		woocommerce_wp_text_input( [
			'id'    => '_wptgcl_min_price',
			'label' => __( 'Minimum Price', 'wptrivo-gift-cards-lite' ),
			'type'  => 'number',
			'custom_attributes' => [ 'step' => 'any', 'min' => '0' ],
			'wrapper_class'     => 'show_if_wptgcl_range',
		] );
		woocommerce_wp_text_input( [
			'id'    => '_wptgcl_max_price',
			'label' => __( 'Maximum Price', 'wptrivo-gift-cards-lite' ),
			'type'  => 'number',
			'custom_attributes' => [ 'step' => 'any', 'min' => '0' ],
			'wrapper_class'     => 'show_if_wptgcl_range',
		] );

		// Variable Options (comma-separated values like 10,25,50,100)
		woocommerce_wp_text_input( [
			'id'    => '_wptgcl_variable_prices',
			'label' => __( 'Variable Prices (comma separated)', 'wptrivo-gift-cards-lite' ),
			'placeholder' => '10,25,50,100',
			'wrapper_class' => 'show_if_wptgcl_variable',
		] );

		// Exclude Sale Items
		woocommerce_wp_checkbox( [
			'id'    => '_wptgcl_exclude_sale',
			'label' => __( 'Exclude Sale Items', 'wptrivo-gift-cards-lite' ),
		] );

		
		?>
			<div class="options_group">
				<p class="form-field">
					<label><?php esc_html_e('Available Templates:', 'wptrivo-gift-cards-lite'); ?></label>
					<select name="_wptgcl_allowed_templates[]" multiple="multiple" style="width: 100%; height: 120px;">
						<?php foreach ($templates as $template) : ?>
							<option value="<?php echo esc_attr( $template->ID ); ?>" <?php selected(in_array($template->ID, $selected_templates)); ?>>
								<?php echo esc_html($template->post_title); ?> (<?php echo esc_html(ucfirst(get_post_meta($template->ID, '_wptgcl_template_type', true))); ?>)
							</option>
						<?php endforeach; ?>
					</select>
					<span class="description"><?php esc_html_e('Select which templates customers can choose from for this gift card product. Hold Ctrl/Cmd to select multiple.', 'wptrivo-gift-cards-lite'); ?></span>
				</p>
				
				<p class="form-field">
					<?php
					woocommerce_wp_checkbox(array(
						'id' => '_wptgcl_use_all_templates',
						'label' => __('Use All Active Templates', 'wptrivo-gift-cards-lite'),
						'description' => __('Allow customers to choose from all active templates.', 'wptrivo-gift-cards-lite'),
					));
					?>
				</p>
			</div>
		<?php

		 wp_nonce_field( 'wptgcl_save_gift_card_meta', 'wptgcl_gift_card_nonce' );

		echo '</div>';
	}

	/**
	 * Make sure product type is saved correctly wptgcl_gift_card
	 * @since    1.0.0
	 */
	public function wptgcl_set_product_type( $post_id ) {

		if ( ! isset( $_POST['wptgcl_product_type_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['wptgcl_product_type_nonce'] ) ), 'wptgcl_set_product_type_action' ) ) {
			return; 
		}
		if ( isset( $_POST['product-type'] ) && $_POST['product-type'] === 'wptgcl_gift_card' ) {
			wp_set_object_terms( $post_id, 'wptgcl_gift_card', 'product_type' );
		}
	}

	/**
	 * Save the Gift card fields data
	 * @since    1.0.0
	 */
	public function wptgcl_save_product_data( $product ) {
		if ( ! isset( $_POST['wptgcl_gift_card_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['wptgcl_gift_card_nonce'] ) ), 'wptgcl_save_gift_card_meta' ) ) {
			return;
		}
		$post_id = $product->get_id();
		if ($product && $product->get_type() == 'wptgcl_gift_card') {
			$product->update_meta_data( '_wptgcl_pricing_type', isset( $_POST['_wptgcl_pricing_type'] ) ? sanitize_text_field( wp_unslash( $_POST['_wptgcl_pricing_type'] ) ) : '');
			$product->update_meta_data( '_wptgcl_fixed_price', isset( $_POST['_wptgcl_fixed_price'] ) ? sanitize_text_field( wp_unslash( $_POST['_wptgcl_fixed_price'] )  ) : '' );
			$product->update_meta_data( '_wptgcl_min_price', isset( $_POST['_wptgcl_min_price'] ) ? sanitize_text_field( wp_unslash( $_POST['_wptgcl_min_price'] ) ) : '' );
			$product->update_meta_data( '_wptgcl_max_price', isset( $_POST['_wptgcl_max_price'] ) ? sanitize_text_field( wp_unslash( $_POST['_wptgcl_max_price'] ) ) : '');
			$product->update_meta_data( '_wptgcl_variable_prices', isset( $_POST['_wptgcl_variable_prices'] ) ? sanitize_text_field( wp_unslash( $_POST['_wptgcl_variable_prices'] )  ) : '' );
			$product->update_meta_data( '_wptgcl_gift_card_value_default', isset( $_POST['_wptgcl_gift_card_value_default'] ) ? sanitize_text_field( wp_unslash( $_POST['_wptgcl_gift_card_value_default'] ) ) : '');
			$product->update_meta_data( '_wptgcl_exclude_sale', isset( $_POST['_wptgcl_exclude_sale'] ) ? 'yes' : 'no' );
			if (isset($_POST['_wptgcl_allowed_templates'])) {
				$product->update_meta_data( '_wptgcl_allowed_templates', array_map('intval', $_POST['_wptgcl_allowed_templates']));
			} else {
				delete_post_meta($post_id, '_wptgcl_allowed_templates');
			}
			
			// Save use all templates option
			$product->update_meta_data( '_wptgcl_use_all_templates', isset($_POST['_wptgcl_use_all_templates']) ? 'yes' : 'no');
		}
	}

	/**
	 *Create custom post type for gift card templates
	 * @since    1.0.0
	 */
	public function wptgcl_register_template_post_type(){

		$labels = array(
			'name'               => 'Gift Card Templates',
			'singular_name'      => 'Gift Card Template',
			'menu_name'          => 'Wptrivo Templates',
			'add_new'            => 'Add New Template',
			'add_new_item'       => 'Add New',
			'edit_item'          => 'Edit',
			'new_item'           => 'New',
			'view_item'          => 'View Template',
			'search_items'       => 'Search Templates',
			'not_found'          => 'No templates found',
			'not_found_in_trash' => 'No templates found in trash'
		);

		$args = array(
			'labels'              => $labels,
			'public'              => true,
			'publicly_queryable'  => false,
			'show_ui'             => true,
			'query_var'           => true,
			'rewrite'             => false,
			'capability_type'     => 'post',
			'has_archive'         => false,
			'hierarchical'        => false,
			'menu_position'       => null,
			'menu_icon'           => 'dashicons-format-image',
			'supports'            => array('title', 'thumbnail', 'editor'),
			'show_in_rest'        => false,
		);

   	 	register_post_type('wptgcl_template', $args);
	}

	/**
	 * Include gift card products in shop/archive if enabled
	 * @since    1.0.0
	 * 
	 */
	public function wptgcl_include_gift_cards_in_shop( $q ) {
		$wptgcl_gnrl_opt = get_option( 'wptgcl_general_settings_opt', array() );

		if ( isset( $wptgcl_gnrl_opt['enable_shp_pg_listing_settng'] ) && empty( $wptgcl_gnrl_opt['enable_shp_pg_listing_settng'] ) ) {
			$tax_query = (array) $q->get( 'tax_query' );

			$tax_query[] = array(
				'taxonomy' => 'product_type',
				'field'    => 'slug',
				'terms'    => array( 'wptgcl_gift_card' ),
				'operator' => 'NOT IN',
			);

			$q->set( 'tax_query', $tax_query );
		}
	}

	/**
	 * Disable add new for cpt.
	 * @since    1.0.0
	 * 
	 */
	public function wpgcwl_restrinction_to_add_cpt(){
		$count = wp_count_posts('wptgcl_template')->publish;

		if ($count >= 3) {
			// Remove "Add New" submenu
			global $submenu;
			if (isset($submenu['edit.php?post_type=wptgcl_template'])) {
				foreach ($submenu['edit.php?post_type=wptgcl_template'] as $k => $item) {
					if (in_array('Add New', $item)) {
						unset($submenu['edit.php?post_type=wptgcl_template'][$k]);
					}
				}
			}
		}
	}

	/**
	 * Sanitize general Settings for Gift Cards for WooCommerce.
	 *
	 * @param array $input Raw input values from form.
	 * @return array Sanitized values.
	 */
	public function wptgcl_general_settings_callback( $input ){
		$sanitized_input = array();

		// Sanitize enable_cart_url_settng checkbox (true or false)
		$sanitized_input['enable_gift_crds_settng'] = isset( $input['enable_gift_crds_settng'] ) ? 1 : '';
		$sanitized_input['enable_gift_crds_indivdul'] = isset( $input['enable_gift_crds_indivdul'] ) ? 1 : '';
		$sanitized_input['apply_gft_crd_shppng_tx'] = isset( $input['apply_gft_crd_shppng_tx'] ) ? 1 : '';
		$sanitized_input['gift_card_free_shipping'] = isset( $input['gift_card_free_shipping'] ) ? 1 : '';
		$sanitized_input['exclude_sale_itms'] = isset( $input['exclude_sale_itms'] ) ? 1 : '';

		// Sanitize enable_save_cart_btn checkbox (true or false)
		$sanitized_input['enable_shp_pg_listing_settng'] = isset($input['enable_shp_pg_listing_settng']) ? 1 : '';
		$sanitized_input['enable_tax_cal_settng'] = isset($input['enable_tax_cal_settng']) ? 1 : '';

		// Sanitize save_end_point text input
		$sanitized_input['gift_card_code_len'] = isset($input['gift_card_code_len']) ? absint($input['gift_card_code_len']) : 7;
		$sanitized_input['gift_card_min_spnd'] = isset($input['gift_card_min_spnd']) ? absint($input['gift_card_min_spnd']) : '';
		$sanitized_input['gift_card_max_spnd'] = isset($input['gift_card_max_spnd']) ? absint($input['gift_card_max_spnd']) : '';
		$sanitized_input['gift_card_usage_limit'] = isset($input['gift_card_usage_limit']) ? absint($input['gift_card_usage_limit']) : 1;
		$sanitized_input['gift_card_usage_limit_per_user'] = isset($input['gift_card_usage_limit_per_user']) ? absint($input['gift_card_usage_limit_per_user']) : 1;
		$sanitized_input['gift_card_limit_usage_x_items'] = isset($input['gift_card_limit_usage_x_items']) ? absint($input['gift_card_limit_usage_x_items']) : '';

		$sanitized_input['gift_card_pre'] = isset($input['gift_card_pre']) ? sanitize_text_field($input['gift_card_pre']) : 'wptgcl';
		$sanitized_input['gift_crd_email_sub'] = isset($input['gift_crd_email_sub']) ? sanitize_text_field($input['gift_crd_email_sub']) : '';
		$sanitized_input['wptgcl_gift_crds_exp_dys'] = isset($input['wptgcl_gift_crds_exp_dys']) ? absint($input['wptgcl_gift_crds_exp_dys']) : 7;

		return $sanitized_input;

	}

	public function wptgcl_brk_tmplt_acnts( $data, $postarr ){

		// Only apply to your custom post type
		if ( $data['post_type'] === 'wptgcl_template' && $data['post_status'] !== 'trash' ) {
			
			// Count existing posts (exclude trashed ones)
			$count_posts = wp_count_posts( 'wptgcl_template' );
			$published   = isset( $count_posts->publish ) ? (int) $count_posts->publish : 0;
			$draft       = isset( $count_posts->draft ) ? (int) $count_posts->draft : 0;
			$pending     = isset( $count_posts->pending ) ? (int) $count_posts->pending : 0;

			$total = $published + $draft + $pending;

			// If user already has 3, prevent new one
			if ( $total >= 5 && empty( $postarr['ID'] ) ) {
				wp_die( esc_html_e( 'You cannot create more than 5 Templates.', 'wptrivo-gift-cards-lite' ) );
			}
		}
			
		return $data;
	}

}
