<?php
/*
 * Plugin Name: WPRunway fro Divi
 * Plugin URI: https://www.wprunway.com
 * Description: Your tool to optimize and enrich your websites under Divi!
 * Version: 1.2.0
 * Author: François Yerg
 * Author URI: https://www.francoisyerg.net
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wprunway-for-divi
 * Domain Path: /languages
 *
 * WPRunway fro Divi is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WPRunway fro Divi is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WPRunway fro Divi. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
define( 'WPFD_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'WPFD_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'WPFD_PLUGIN_VERSION', '1.2.0' );
define( 'WPFD_PLUGIN_WEBSITE', 'https://www.wprunway.com' );
define( 'WPFD_PLUGIN_EMAIL', 'support@wprunway.com' );

require_once WPFD_PLUGIN_PATH . 'includes/functions.php';
require_once WPFD_PLUGIN_PATH . 'includes/ajax.php';
require_once WPFD_PLUGIN_PATH . 'admin/admin.php';

if (! function_exists( 'wpfd_load_textdomain' )) {

	/**
	 * Translation
	 *
	 * @since 1.1.2
	 */
	function wpfd_load_textdomain() {
		load_plugin_textdomain( "wprunway-for-divi", false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}
	add_action( 'init', 'wpfd_load_textdomain' );
}

if (! function_exists( 'wpfd_initialize_extension' )) {

	/**
	 * Creates the extension's main class instance.
	 *
	 * @since 1.0.0
	 */
	function wpfd_initialize_extension() {
		require_once WPFD_PLUGIN_PATH . 'includes/WprunwayForDivi.php';
	}
	add_action( 'divi_extensions_init', 'wpfd_initialize_extension' );
}