<?php

// Sécurité : empêcher un accès direct
if (! defined( 'ABSPATH' )) {
	exit();
}

class WPFD_Rating extends ET_Builder_Module {
	public $icon_path;
	public $slug = 'wpfd_rating';
	public $vb_support = 'on';
	
	protected $module_credits = array(
		'module_uri' => WPFD_PLUGIN_WEBSITE . 'module/rating/',
		'author' => 'François Yerg',
		'author_uri' => 'https://www.francoisyerg.net'
	);

	public function init() {
		$this->name = esc_html__( 'Rating', 'wprunway-for-divi' );
		$this->plural = esc_html__( 'Ratings', 'wprunway-for-divi' );
		$this->icon_path = plugin_dir_path( __FILE__ ) . 'icon.svg';
		$this->main_css_element = '%%order_class%%';
		
		$this->settings_modal_toggles = array(
			'general' => array(
				'toggles' => array(
					'content' => esc_html__( 'Content', 'wprunway-for-divi' )
				)
			)
		);
	}

	public function get_fields() {
		return [
			'title' => [
				'type' => 'text',
				'label' => esc_html__( 'Title', 'wprunway-for-divi' ),
				'description' => esc_html__( 'Your module title.', 'wprunway-for-divi' ),
				'default' => esc_html__( 'What do you think about this content?', 'wprunway-for-divi' )
			],
			'good_btn_text' => [
				'type' => 'text',
				'label' => esc_html__( 'Good button text', 'wprunway-for-divi' ),
				'description' => esc_html__( 'Good button text', 'wprunway-for-divi' ),
				'default' => esc_html__( '👍 Good', 'wprunway-for-divi' )
			],
			'bad_btn_text' => [
				'type' => 'text',
				'label' => esc_html__( 'Bad button text', 'wprunway-for-divi' ),
				'description' => esc_html__( 'Bad button text', 'wprunway-for-divi' ),
				'default' => esc_html__( '👎 Bad', 'wprunway-for-divi' )
			],
			'show_good_votes' => array(
				'label' => esc_html__( 'Show good votes', 'wprunway-for-divi' ),
				'type' => 'yes_no_button',
				'options' => array(
					'on' => esc_html__( 'Display', 'wprunway-for-divi' ),
					'off' => esc_html__( 'Hide', 'wprunway-for-divi' )
				),
				'default' => 'on',
				'description' => esc_html__( 'Choose if you want to display or not the number of good votes.', 'wprunway-for-divi' ),
				'option_category' => 'basic_option',
				'toggle_slug' => 'content'
			),
			'show_bad_votes' => array(
				'label' => esc_html__( 'Show bad votes', 'wprunway-for-divi' ),
				'type' => 'yes_no_button',
				'options' => array(
					'on' => esc_html__( 'Display', 'wprunway-for-divi' ),
					'off' => esc_html__( 'Hide', 'wprunway-for-divi' )
				),
				'default' => 'on',
				'description' => esc_html__( 'Choose if you want to display or not the number of bad votes.', 'wprunway-for-divi' ),
				'option_category' => 'basic_option',
				'toggle_slug' => 'content'
			),
		];
	}

	public function get_advanced_fields_config() {
		return [
			'fonts' => [
				'title' => [
					'label' => esc_html__( 'Title', 'wprunway-for-divi' ),
					'use_all_caps' => true,
					'css' => [
						'main' => "{$this->main_css_element} .wpfd_rating_title"
					],
					'header_level' => [
						'default' => 'h5'
					]
				],
			],
		];
	}

	public function render($attrs, $content = null, $render_slug = null) {
		$title = $this->props['title'];
		$title_level = $this->props['title_level'];
		$good_btn_text = $this->props['good_btn_text'];
		$bad_btn_text = $this->props['bad_btn_text'];
		$show_good_votes = $this->props['show_good_votes'];
		$show_bad_votes = $this->props['show_bad_votes'];
		
		$post_id = get_the_ID();
		
		$good_votes = '';
		if ($show_good_votes === "on") {
			$good_votes = " (<span class='wpfd_rating_good_count'>" . (get_post_meta($post_id, 'wpfd_rating_good_votes', true) ?: 0) . "</span>)";
		}
		
		$bad_votes = '';
		if ($show_bad_votes === "on") {
			$bad_votes = " (<span class='wpfd_rating_bad_count'>" . (get_post_meta($post_id, 'wpfd_rating_bad_votes', true) ?: 0) . "</span>)";
		}
		
		$cookie_name = 'wpfd_rating_voted_' . $post_id;
		$previous_vote = isset($_COOKIE[$cookie_name]) ? sanitize_text_field(wp_unslash($_COOKIE[$cookie_name])) : null;
		
		if (!empty($title)) {
			$title = '<' . esc_attr( $title_level ) . ' class="wpfd_rating_title">' . esc_html($title) . '</' . esc_attr( $title_level ) . '>';
		}
		
		ob_start();
		?>
        <div class="wpfd_rating_module" data-post-id="<?php echo esc_attr($post_id); ?>">
            <?php echo wp_kses($title, 'post'); ?>
            <div class="wpfd_rating_buttons">
                <button class="wpfd_rating_button good<?php echo $previous_vote == 'good' ? ' active' : ''; ?>" data-value="good"><?php echo esc_html("$good_btn_text", 'wprunway-for-divi') . wp_kses_post($good_votes); ?></button>
                <button class="wpfd_rating_button bad<?php echo $previous_vote == 'bad' ? ' active' : ''; ?>" data-value="bad"><?php echo esc_html("$bad_btn_text", 'wprunway-for-divi') . wp_kses_post($bad_votes); ?></button>
            </div>
            <div class="wpfd_rating_message"></div>
        </div>
        <?php
        return ob_get_clean();
	}
}
new WPFD_Rating();