<?php

// Sécurité : empêcher un accès direct
if (! defined( 'ABSPATH' ))
	exit();

/*
 * Liste des modules
 */
function wpfd_get_modules_list() {
	return array(
		'wpfd_alert' => array(
			'name' => __( "Alert", 'wprunway-for-divi' ),
			'description' => __( "Display a customisable alert message on your website.", 'wprunway-for-divi' ),
			'file' => 'modules/Alert/Alert.php',
			'badge' => '',
			'icon' => WPFD_PLUGIN_URL . 'includes/modules/Alert/icon.svg',
			'demo' => WPFD_PLUGIN_WEBSITE . 'module/alert/'
		),
		'wpfd_note' => array(
			'name' => __( "Note", 'wprunway-for-divi' ),
			'description' => __( "Display a note on your website.", 'wprunway-for-divi' ),
			'file' => 'modules/Note/Note.php',
			'badge' => '',
			'icon' => WPFD_PLUGIN_URL . 'includes/modules/Note/icon.svg',
			'demo' => WPFD_PLUGIN_WEBSITE . 'module/note/'
		),
		'wpfd_profile' => array(
			'name' => __( "Profile", 'wprunway-for-divi' ),
			'description' => __( "Show profiles on your website from current user, post author or custom user.", 'wprunway-for-divi' ),
			'file' => 'modules/Profile/Profile.php',
			'badge' => 'new',
			'icon' => WPFD_PLUGIN_URL . 'includes/modules/Profile/icon.svg',
			'demo' => WPFD_PLUGIN_WEBSITE . 'module/profile/'
		),
		'wpfd_rating' => array(
			'name' => __( "Rating", 'wprunway-for-divi' ),
			'description' => __( "Get feedback about your content from your visitors.", 'wprunway-for-divi' ),
			'file' => 'modules/Rating/Rating.php',
			'badge' => 'new',
			'icon' => WPFD_PLUGIN_URL . 'includes/modules/Rating/icon.svg',
			'demo' => WPFD_PLUGIN_WEBSITE . 'module/rating/'
		),
		'wpfd_readingtime' => array(
			'name' => __( "Reading time", 'wprunway-for-divi' ),
			'description' => __( "Display an estimation of the time needed to read a post or page based on the number of words.", 'wprunway-for-divi' ),
			'file' => 'modules/ReadingTime/ReadingTime.php',
			'badge' => '',
			'icon' => WPFD_PLUGIN_URL . 'includes/modules/ReadingTime/icon.svg',
			'demo' => WPFD_PLUGIN_WEBSITE . 'module/reading-time/'
		),
		'wpfd_tag' => array(
			'name' => __( "Tag", 'wprunway-for-divi' ),
			'description' => __( "Display a tag in the begining, middle or end of a sentence.", 'wprunway-for-divi' ),
			'file' => 'modules/Tag/Tag.php',
			'badge' => '',
			'icon' => WPFD_PLUGIN_URL . 'includes/modules/Tag/icon.svg',
			'demo' => WPFD_PLUGIN_WEBSITE . 'module/tag/'
		)
	);
}

/**
 * Compte le nombre total de modules
 */
function wpfd_count_modules() {
	return count( wpfd_get_modules_list() );
}

/**
 * Compte le nombre de modules activés
 */
function wpfd_count_active_modules() {
	$activated = 0;

	foreach ( wpfd_get_modules_list() as $k => $v ) {
		if (wpfd_module_is_activated( $k )) {
			$activated ++;
		}
	}

	return $activated;
}

/**
 * Vérifie que Divi soit iinstallé et activé
 */
function wpfd_divi_is_activated() {
	$theme = wp_get_theme();

	// Vérifier si le thème est un thème enfant
	if ($theme->parent()) {
		// Obtenir les informations du thème parent
		$parent_theme = $theme->parent();

		// Vérifier si le thème parent est Divi
		if ($parent_theme->get( 'Name' ) === 'Divi') {
			return true;
		}
	}

	if ($theme->get( 'Name' ) == 'Divi') {
		return true;
	}

	// Vérifier si le plugin Divi Builder est actif
	include_once (ABSPATH . 'wp-admin/includes/plugin.php');
	if (is_plugin_active( 'divi-builder/divi-builder.php' )) {
		return true;
	}

	// Divi n'est pas installé
	return false;
}

/**
 * Récupére le numéro de version de Divi
 */
function wpfd_get_divi_version() {
	// Vérifie si le thème actif est Divi
	$current_theme = wp_get_theme();
	if ($current_theme->get( 'Name' ) === 'Divi') {
		// Récupère et retourne la version de Divi
		return $current_theme->get( 'Version' );
	}

	// Vérifie si un thème enfant de Divi est utilisé
	if ($current_theme->get( 'Template' ) === 'Divi') {
		$parent_theme = wp_get_theme( $current_theme->get( 'Template' ) );
		return $parent_theme->get( 'Version' );
	}

	// Si Divi n'est pas activé
	return null;
}

/**
 * Vérifie si un module est activé
 */
function wpfd_module_is_activated($slug) {
	$modules_settings = get_option( 'wpfd_modules_settings' );

	if (isset( $modules_settings['enable_' . $slug] ) && $modules_settings['enable_' . $slug] != 1) {
		return false;
	}

	return true;
}

function wpfd_scripts_manager() {
	wp_localize_script('jquery', 'wpfd', [
		'ajax_url' => admin_url('admin-ajax.php')
	]);
	
	if (wpfd_module_is_activated('wpfd_rating')) {
		wp_localize_script('jquery', 'wpfd_rating', [
			'nonce'    => wp_create_nonce('wpfd_rating_nonce')
		]);
	}
}
add_action('wp_enqueue_scripts', 'wpfd_scripts_manager');

// Ajouter une colonne pour les types de posts personnalisés
function wpfd_rating_column_add($columns) {
	$new_columns = [];
	$added = false;
	
	foreach ($columns as $key => $value) {
		if ($key === 'comments' || $key === 'date') {
			// Ajouter la colonne "Ratings" avant la date
			if (!$added) {
				$new_columns['wpfd_rating_good'] = esc_html__("👍", 'wprunway-for-divi');
				$new_columns['wpfd_rating_bad'] = esc_html__("👎", 'wprunway-for-divi');
				$added = true;
			}
		}
		$new_columns[$key] = $value; // Ajouter la colonne existante
	}
	
	return $new_columns;
}

// Afficher le contenu de la colonne
function wpfd_rating_column_content($column_name, $post_id) {
	if ($column_name === 'wpfd_rating_good') {
		echo esc_html(get_post_meta($post_id, 'wpfd_rating_good_votes', true) ?: 0);
	}
	else if ($column_name === 'wpfd_rating_bad') {
		echo esc_html(get_post_meta($post_id, 'wpfd_rating_bad_votes', true) ?: 0);
	}
}

// Rendre les colonnes triables
function wpfd_rating_make_sortable($sortable_columns) {
	$sortable_columns['wpfd_rating_good'] = 'wpfd_rating_good_votes';
	$sortable_columns['wpfd_rating_bad'] = 'wpfd_rating_bad_votes';
	return $sortable_columns;
}


// Modifier la requête pour trier les colonnes personnalisées
function wpfd_rating_sort_columns($query) {
	if (!is_admin() || !$query->is_main_query()) {
		return;
	}
	
	$orderby = $query->get('orderby');
	
	if ($orderby === 'wpfd_rating_good_votes') {
		$query->set('meta_key', 'wpfd_rating_good_votes');
		$query->set('orderby', 'meta_value_num');
	}
	
	if ($orderby === 'wpfd_rating_bad_votes') {
		$query->set('meta_key', 'wpfd_rating_bad_votes');
		$query->set('orderby', 'meta_value_num');
	}
}
add_action('init', function () {
	$functionnalities_settings = get_option( 'wpfd_functionnalities_settings' );
	
	if (!isset($functionnalities_settings['enable_rating_columns']) || $functionnalities_settings['enable_rating_columns'] === 1) {
		add_filter("manage_posts_columns", 'wpfd_rating_column_add');
		add_action("manage_posts_custom_column", 'wpfd_rating_column_content', 10, 2);
		add_filter('manage_edit-post_sortable_columns', 'wpfd_rating_make_sortable');
		
		add_filter("manage_pages_columns", 'wpfd_rating_column_add');
		add_action("manage_pages_custom_column", 'wpfd_rating_column_content', 10, 2);
		add_filter('manage_edit-page_sortable_columns', 'wpfd_rating_make_sortable');
		
		$post_types = get_post_types(['_builtin' => false], 'names');
		foreach ($post_types as $post_type) {
			if ($post_type != 'project') {// to fix double display
				add_filter("manage_{$post_type}_posts_columns", 'wpfd_rating_column_add');
				add_action("manage_{$post_type}_posts_custom_column", 'wpfd_rating_column_content', 10, 2);
			}
			add_filter("manage_edit-{$post_type}_sortable_columns", 'wpfd_rating_make_sortable');
		}
		
		add_action('pre_get_posts', 'wpfd_rating_sort_columns');
	}
});