<?php
if (! defined( 'ABSPATH' ))
	exit();

function handle_wpfd_rating_vote() {
	// Vérifier la présence des données
	if (!isset($_POST['post_id'], $_POST['vote'], $_POST['wpnonce'])) {
		wp_send_json_error(['message' => esc_html__("Missing data", 'wprunway-for-divi')]);
	}
	
	// Vérifier le nonce
	if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['wpnonce'])), 'wpfd_rating_nonce')) {
		wp_send_json_error(['message' => esc_html__("Invalid nonce", 'wprunway-for-divi')]);
	}
	
	$post_id = sanitize_text_field(intval($_POST['post_id']));
	$vote = sanitize_text_field(wp_unslash($_POST['vote']));
	
	// Vérifier la validité du vote
	if (!in_array($vote, ['good', 'bad'])) {
		wp_send_json_error(['message' => esc_html__("Invalid data", "wprunway-for-divi")]);
	}
	
	$meta_key = ($vote === 'good') ? 'wpfd_rating_good_votes' : 'wpfd_rating_bad_votes';
	
	$cookie_name = 'wpfd_rating_voted_' . $post_id;
	$previous_vote = isset($_COOKIE[$cookie_name]) ? sanitize_text_field(wp_unslash($_COOKIE[$cookie_name])) : null;
	
	// Récupérer les votes actuels
	$wpfd_rating_good_votes = get_post_meta($post_id, 'wpfd_rating_good_votes', true) ?: 0;
	$wpfd_rating_bad_votes = get_post_meta($post_id, 'wpfd_rating_bad_votes', true) ?: 0;
	
	// Gestion du vote
	if ($previous_vote === $vote) {
		// Annuler le vote si l'utilisateur clique sur le même bouton
		$new_count = max(0, get_post_meta($post_id, $meta_key, true) - 1);
		update_post_meta($post_id, $meta_key, $new_count);
		
		// Supprimer le cookie
		setcookie($cookie_name, '', time() - 3600, "/");
		$previous_vote = null; // Réinitialiser la variable
		$message = esc_html__("Thank you! Your vote has been canceled.", 'wprunway-for-divi');
	}
	elseif ($previous_vote === null) {
		// Ajouter le nouveau vote
		update_post_meta($post_id, $meta_key, $$meta_key + 1);
		
		// Mettre à jour le cookie avec le nouveau vote
		setcookie($cookie_name, $vote, time() + (86400 * 30), "/");
		$previous_vote = $vote;
		$message = esc_html__("Thank you! Your vote has been recorded.", 'wprunway-for-divi');
	}
	else {
		wp_send_json_error(['message' => esc_html__("Sorry! Your vote is already recorded", "wprunway-for-divi")]);
	}
	
	// Récupérer les nouvelles valeurs
	$updated_good_votes = get_post_meta($post_id, 'wpfd_rating_good_votes', true) ?: 0;
	$updated_bad_votes = get_post_meta($post_id, 'wpfd_rating_bad_votes', true) ?: 0;
	
	wp_send_json_success([
		'good_votes' => $updated_good_votes,
		'bad_votes' => $updated_bad_votes,
		'user_vote' => $previous_vote, // Permet au frontend de savoir si l'utilisateur a un vote actif
		'message' => $message
	]);
}

// Déclarer l'ajax pour les utilisateurs connectés et non connectés
add_action('wp_ajax_handle_wpfd_rating_vote', 'handle_wpfd_rating_vote');
add_action('wp_ajax_nopriv_handle_wpfd_rating_vote', 'handle_wpfd_rating_vote');