<div class="wrap">
	<h1><?php
	esc_html_e('WPRunway for Divi', 'wprunway-for-divi');
	?></h1>
	<?php

	settings_errors();
	?>
	<form method="post" action="options.php">
		<div class="wpfd_admin_row">
			<div class="wpfd_admin_column_left">
				<!-- Tab links -->
				<div class="wpfd_admin_tab">
					<button class="wpfd_admin_tablinks wpfd_admin_defaulttablink"
						type="button" data-target="#wpfd_admin_tab_welcome">
							<?php esc_html_e( 'Welcome', 'wprunway-for-divi' ); ?>
						</button>
					<button class="wpfd_admin_tablinks" type="button"
						data-target="#wpfd_admin_tab_modules">
							<?php esc_html_e( 'Modules', 'wprunway-for-divi' ); ?>
						</button>
					<button class="wpfd_admin_tablinks" type="button"
						data-target="#wpfd_admin_tab_functionnalities">
							<?php esc_html_e( 'Fonctionnalities', 'wprunway-for-divi' ); ?>
						</button>
					<button class="wpfd_admin_tablinks" type="button"
						data-target="#wpfd_admin_tab_about">
							<?php esc_html_e('About', 'wprunway-for-divi'); ?>
						</button>
				</div>

				<!-- Tab welcome -->
				<div id="wpfd_admin_tab_welcome" class="wpfd_admin_tabcontent">
					<h2><?php esc_html_e('Welcome', 'wprunway-for-divi'); ?></h2>
					<p><?php esc_html_e('Your tool to optimize and enrich your websites under Divi!', 'wprunway-for-divi'); ?></p>
					<h3><?php esc_html_e('Status', 'wprunway-for-divi'); ?></h3>
					<ul>
						<li>
							<?php
								echo esc_html__('Divi version: ', 'wprunway-for-divi');
		
								$divi_version = wpfd_get_divi_version();
		
								if ($divi_version == null) {
									echo esc_html__("Divi is not activated.", 'wprunway-for-divi');
								} else {
									/* translators: %1$s is replaced with Divi version */
									echo sprintf(esc_html__("✔ %s is activated.", 'wprunway-for-divi'), esc_html($divi_version));
								}
							?>
						</li>
						<li><?php echo sprintf('%1$s %2$s', esc_html__("WPRunway for Divi version:", 'wprunway-for-divi'), esc_attr(WPFD_PLUGIN_VERSION)); ?></li>
						<li>
							<?php 
								/* translators: %1$s is replaced with number of activated modules and %1$s by number of modules */
							echo sprintf(esc_html__('Modules activated: %1$s out of %2$s', 'wprunway-for-divi'), esc_html(wpfd_count_active_modules()), esc_html(wpfd_count_modules()));
							?>
						</li>
					</ul>
				</div>

				<!-- Tab modules -->
				<div id="wpfd_admin_tab_modules" class="wpfd_admin_tabcontent">
					<?php
					settings_fields('wpfd_modules_settings_group');
					do_settings_sections('wpfd_modules_settings_section');
					esc_html_e('More to come...', 'wprunway-for-divi');
					?>
				</div>

				<!-- Tab functionnalities -->
				<div id="wpfd_admin_tab_functionnalities" class="wpfd_admin_tabcontent">
					<?php
					settings_fields('wpfd_functionnalities_settings_group');
					do_settings_sections('wpfd_functionnalities_settings_section');
					esc_html_e('More to come...', 'wprunway-for-divi');
					?>
				</div>

				<!-- Tab about -->
				<div id="wpfd_admin_tab_about" class="wpfd_admin_tabcontent">
					<h2><?php
					esc_html_e('About', 'wprunway-for-divi');
					?></h2>
					<p><?php
					echo sprintf('%1$s <a href="%2$s">%2$s</a>', esc_html__("Plugin made by François Yerg", 'wprunway-for-divi'), "https://www.francoisyerg.net");
					?></p>
					<p><?php
					echo sprintf('%1$s <a href="mailto:%2$s">%2$s</a>', esc_html__("If you have any questions or to report a bug:", 'wprunway-for-divi'), esc_attr(WPFD_PLUGIN_EMAIL));
					?></p>
				</div>
			</div>
			<!-- .wpfd_admin_column_left -->
			<div class="wpfd_admin_column_right">
				<div class="wpfd_admin_box wpfd_admin_box_actions">
					<div class="wpfd_admin_box_title">
						<h2><?php esc_html_e('Actions', 'wprunway-for-divi')?></h2>
					</div>
					<div class="wpfd_admin_box_content">
						<?php submit_button(esc_html__('Save changes', 'wprunway-for-divi')); ?>
					</div>
				</div>
				<div class="wpfd_admin_box wpfd_admin_box_banner">
					<div class="wpfd_admin_box_title">
						<h2><?php esc_html_e('Need help for your website?', 'wprunway-for-divi')?></h2>
					</div>
					<div class="wpfd_admin_box_content">
					    <p><?php esc_html_e("Checkout my website to know more about my freelance web developer services and contact informations.", "wprunway-for-divi"); ?></p>
					    <a href="https://www.francoisyerg.net" target="_blank" class="wpr-btn"><?php esc_html_e("See more", "wprunway-for-divi"); ?></a>
					</div>
				</div>
			</div>
			<!-- .wpfd_admin_column_right -->
	
	</form>
</div>
</div>