/**
 * WeChat Pay Checkout Handler
 * Handles description display and submit button enabling for WeChat Pay payment gateway
 */
window.addEventListener('fluent_cart_load_payments_wechat', function(event) {
    // Get submit button configuration
    const submitButton = window.fluentcart_checkout_vars?.submit_button;
    
    // Get payment container for this gateway
    const container = document.querySelector('.fluent-cart-checkout_embed_payment_container_wechat');
    
    // Get translations/description from localized data
    const wechatData = window.wpkj_fc_wechat_data || {};
    const description = wechatData.description || 'Pay securely with WeChat Pay';
    
    // Display description in the container
    if (container) {
        container.innerHTML = `<p>${description}</p>`;
    }
    
    // Mark WeChat Pay as ready
    window.is_wechat_ready = true;
    
    // Enable the checkout submit button
    if (event.detail && event.detail.paymentLoader) {
        event.detail.paymentLoader.enableCheckoutButton(submitButton?.text || 'Place Order');
    }
});
